/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.util;

import hep.io.root.RootClass;
import hep.io.root.RootClassNotFound;
import hep.io.root.RootObject;
import hep.io.root.interfaces.TDirectory;
import hep.io.root.interfaces.TH1;
import hep.io.root.interfaces.TKey;
import hep.io.root.util.FakeTKey;
import java.io.IOException;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

class RootHistogramTreeModel
implements TreeModel {
    private TKey top;

    RootHistogramTreeModel(TDirectory topDir) {
        this.top = new FakeTKey(topDir);
    }

    protected void handleException(IOException x) {
        throw new RuntimeException("IOException reading root file", x);
    }

    protected void handleException(RootClassNotFound x) {
        throw new RuntimeException("RootClassNotFound reading root file", x);
    }

    public Object getChild(Object parent, int index) {
        try {
            TKey node = (TKey)parent;
            RootObject object = node.getObject();
            if (object instanceof TDirectory) {
                TDirectory dir = (TDirectory)object;
                int nKeys = dir.nKeys();
                for (int i = 0; i < nKeys; ++i) {
                    TKey key = dir.getKey(i);
                    RootClass keyClass = key.getObjectClass();
                    Class javaClass = keyClass.getJavaClass();
                    if (!TDirectory.class.isAssignableFrom(javaClass) && !TH1.class.isAssignableFrom(javaClass) || index-- != 0) continue;
                    return key;
                }
            }
            return null;
        }
        catch (IOException x) {
            this.handleException(x);
            return null;
        }
        catch (RootClassNotFound x) {
            this.handleException(x);
            return null;
        }
    }

    public int getChildCount(Object parent) {
        try {
            TKey node = (TKey)parent;
            TDirectory dir = (TDirectory)node.getObject();
            int nKeys = dir.nKeys();
            int nChildren = 0;
            for (int i = 0; i < nKeys; ++i) {
                TKey key = dir.getKey(i);
                RootClass keyClass = key.getObjectClass();
                Class javaClass = keyClass.getJavaClass();
                if (TDirectory.class.isAssignableFrom(javaClass)) {
                    ++nChildren;
                    continue;
                }
                if (!TH1.class.isAssignableFrom(javaClass)) continue;
                ++nChildren;
            }
            return nChildren;
        }
        catch (IOException x) {
            this.handleException(x);
            return 0;
        }
        catch (RootClassNotFound x) {
            this.handleException(x);
            return 0;
        }
    }

    public int getIndexOfChild(Object parent, Object child) {
        try {
            TKey node = (TKey)parent;
            TDirectory dir = (TDirectory)node.getObject();
            int nKeys = dir.nKeys();
            int nChildren = 0;
            for (int i = 0; i < nKeys; ++i) {
                TKey key = dir.getKey(i);
                if (key == child) {
                    return nChildren;
                }
                RootClass keyClass = key.getObjectClass();
                Class javaClass = keyClass.getJavaClass();
                if (TDirectory.class.isAssignableFrom(javaClass)) {
                    ++nChildren;
                    continue;
                }
                if (!TH1.class.isAssignableFrom(javaClass)) continue;
                ++nChildren;
            }
            return -1;
        }
        catch (IOException x) {
            this.handleException(x);
            return -1;
        }
        catch (RootClassNotFound x) {
            this.handleException(x);
            return -1;
        }
    }

    public Object getRoot() {
        return this.top;
    }

    public boolean isLeaf(Object parent) {
        try {
            TKey key = (TKey)parent;
            RootClass rc = key.getObjectClass();
            Class javaClass = rc.getJavaClass();
            return !TDirectory.class.isAssignableFrom(javaClass);
        }
        catch (IOException x) {
            this.handleException(x);
            return true;
        }
        catch (RootClassNotFound x) {
            this.handleException(x);
            return true;
        }
    }

    public void removeTreeModelListener(TreeModelListener p1) {
    }

    public void valueForPathChanged(TreePath p1, Object p2) {
    }

    public void addTreeModelListener(TreeModelListener p1) {
    }
}

