/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.reps;

import hep.io.root.core.AbstractRootObject;
import hep.io.root.core.RootInput;
import hep.io.root.interfaces.TBranch;
import hep.io.root.interfaces.TLeafB;
import hep.io.root.interfaces.TLeafI;
import java.io.IOException;
import org.apache.bcel.Constants;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.Type;

public abstract class TLeafBRep
extends AbstractRootObject
implements TLeafB,
Constants {
    private Object lastValue;
    private TBranch branch;
    private byte lastByte;
    private long lastByteIndex;
    private long lastValueIndex;

    public void setBranch(TBranch branch) {
        this.branch = branch;
        this.lastValueIndex = -1L;
        this.lastByteIndex = -1L;
    }

    public byte getValue(long index) throws IOException {
        try {
            if (index == this.lastByteIndex) {
                return this.lastByte;
            }
            this.lastByteIndex = index;
            RootInput in = this.branch.setPosition(this, this.lastByteIndex);
            this.lastByte = in.readByte();
            return this.lastByte;
        }
        catch (IOException x) {
            this.lastByteIndex = -1L;
            throw x;
        }
    }

    public Object getWrappedValue(long index) throws IOException {
        try {
            if (index == this.lastValueIndex) {
                return this.lastValue;
            }
            this.lastValueIndex = index;
            RootInput in = this.branch.setPosition(this, index);
            int arrayDim = this.getArrayDim();
            if (arrayDim == 0) {
                this.lastValue = new Byte(in.readByte());
                return this.lastValue;
            }
            if (arrayDim == 1) {
                TLeafI count = (TLeafI)this.getLeafCount();
                int len = count == null ? this.getLen() : count.getValue(index);
                byte[] array = new byte[len];
                in.readFixedArray(array);
                this.lastValue = array;
                return array;
            }
            this.lastValue = this.readMultiArray(in, Byte.TYPE, index);
            return this.lastValue;
        }
        catch (IOException x) {
            this.lastValueIndex = -1L;
            throw x;
        }
    }

    public void generateReadCode(InstructionList il, InstructionFactory factory, ConstantPoolGen cp, String className) {
        String leafClassName = this.getClass().getName();
        int arrayDim = this.getArrayDim();
        if (arrayDim == 0) {
            il.append((Instruction)factory.createInvoke(leafClassName, "getValue", (Type)Type.BYTE, new Type[]{Type.LONG}, (short)182));
        } else {
            il.append((Instruction)factory.createInvoke(leafClassName, "getWrappedValue", (Type)Type.OBJECT, new Type[]{Type.LONG}, (short)182));
        }
    }

    abstract Object[] readMultiArray(RootInput var1, Class var2, long var3);
}

