/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.reps;

import hep.io.root.RootClassNotFound;
import hep.io.root.core.AbstractRootObject;
import hep.io.root.core.CloneLeaf;
import hep.io.root.core.GenericRootClass;
import hep.io.root.core.HollowBuilder;
import hep.io.root.core.RootClassFactory;
import hep.io.root.core.RootInput;
import hep.io.root.core.SingleLeaf;
import hep.io.root.interfaces.TBranch;
import hep.io.root.interfaces.TBranchClones;
import hep.io.root.interfaces.TObjArray;
import java.io.IOException;

public abstract class TBranchClonesRep
extends AbstractRootObject
implements TBranchClones {
    private Class hollowClass;
    private RootInput rin;
    private String fClassName;
    private String fName;
    private String fTitle;
    private TBranch fBranchCount;
    private TObjArray fBranches;
    private TObjArray fLeaves;
    private double fEntries;
    private double fTotBytes;
    private double fZipBytes;
    private int fBasketSize;
    private int fBits;
    private int fCompress;
    private int fEntryNumber;
    private int fEntryOffset;
    private int fMaxBaskets;
    private int fOffset;
    private int fUniqueId;
    private int fWriteBasket;

    public TObjArray getLeaves() {
        return this.fLeaves;
    }

    public Class getObjectClass() {
        try {
            if (this.hollowClass == null) {
                HollowBuilder builder = new HollowBuilder((TBranch)this, true);
                String name = "hep.io.root.hollow." + this.getClassName();
                RootClassFactory factory = this.rin.getFactory();
                GenericRootClass gc = (GenericRootClass)factory.create(this.getClassName());
                this.hollowClass = factory.getLoader().loadSpecial(builder, name, gc);
                builder.populateStatics(this.hollowClass, factory);
                return this.hollowClass;
            }
            return this.hollowClass;
        }
        catch (RootClassNotFound x) {
            throw new RuntimeException("Error looking up class for TBranchClones " + x.getClassName(), x);
        }
    }

    public void readMembers(RootInput in) throws IOException {
        int v = in.readVersion(this);
        v = in.readVersion(this);
        v = in.readVersion(this);
        this.fUniqueId = in.readInt();
        this.fBits = in.readInt();
        this.fName = in.readObject("TString").toString();
        this.fTitle = in.readObject("TString").toString();
        this.fCompress = in.readInt();
        this.fBasketSize = in.readInt();
        this.fEntryOffset = in.readInt();
        this.fMaxBaskets = in.readInt();
        this.fWriteBasket = in.readInt();
        this.fEntryNumber = in.readInt();
        this.fEntries = in.readDouble();
        this.fTotBytes = in.readDouble();
        this.fZipBytes = in.readDouble();
        this.fOffset = in.readInt();
        this.fBranchCount = (TBranch)in.readObjectRef();
        this.fClassName = in.readObject("TString").toString();
        this.fBranches = (TObjArray)in.readObject("TObjArray");
        this.rin = in.getTop();
        CloneLeaf leaf = new CloneLeaf();
        leaf.setBranch(this);
        this.fLeaves = new SingleLeaf(leaf);
    }
}

