/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.daemon.xrootd;

import hep.io.root.daemon.DaemonInputStream;
import hep.io.root.daemon.xrootd.OpenFile;
import hep.io.root.daemon.xrootd.Session;
import hep.io.root.daemon.xrootd.XrootdURLConnection;
import java.io.IOException;

public class XrootdInputStream
extends DaemonInputStream {
    private static int MAXGETSIZE = -1;
    private byte[] buffer;
    private int bpos = 0;
    private int blen = 0;
    private OpenFile file;
    private Session handle;
    private XrootdURLConnection connection;

    public XrootdInputStream(XrootdURLConnection conn) throws IOException {
        this.connection = conn;
        this.handle = conn.getSession();
        this.file = this.handle.open(conn.getURL().getFile(), 0, 16);
        this.buffer = new byte[conn.getBufferSize()];
    }

    public int read() throws IOException {
        int i;
        if (this.bpos >= this.blen && !this.fillBuffer()) {
            return -1;
        }
        if ((i = this.buffer[this.bpos++]) < 0) {
            i += 256;
        }
        return i;
    }

    public void close() throws IOException {
        if (this.handle != null) {
            this.handle.close(this.file);
            this.handle = null;
            if (this.connection != null) {
                this.connection.streamClosed();
            }
        }
    }

    public int read(byte[] values, int offset, int size) throws IOException {
        if (this.bpos >= this.blen) {
            int l;
            long pos = this.position + (long)this.bpos;
            int n = size;
            if (MAXGETSIZE > 0 && n > MAXGETSIZE) {
                n = MAXGETSIZE;
            }
            if ((l = this.handle.read(this.file, pos, values, offset, n)) > 0) {
                this.position += (long)l;
            } else {
                l = -1;
            }
            return l;
        }
        int l = Math.min(size, this.blen - this.bpos);
        System.arraycopy(this.buffer, this.bpos, values, offset, l);
        this.bpos += l;
        return l;
    }

    public long skip(long skip) throws IOException {
        this.setPosition(this.getPosition() + skip);
        return skip;
    }

    public void setPosition(long pos) {
        if (pos > this.position && pos < this.position + (long)this.blen) {
            this.bpos = (int)(pos - this.position);
        } else {
            this.blen = 0;
            this.bpos = 0;
            super.setPosition(pos);
        }
    }

    public int available() throws IOException {
        return this.blen - this.bpos;
    }

    private boolean fillBuffer() throws IOException {
        this.position += (long)this.bpos;
        this.bpos = 0;
        int n = this.buffer.length;
        if (MAXGETSIZE > 0 && n > MAXGETSIZE) {
            n = MAXGETSIZE;
        }
        this.blen = this.handle.read(this.file, this.position, this.buffer, 0, n);
        return true;
    }

    public long getPosition() {
        return this.position + (long)this.bpos;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

