/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.daemon.xrootd;

import hep.io.root.daemon.xrootd.Callback;
import hep.io.root.daemon.xrootd.Destination;
import hep.io.root.daemon.xrootd.Message;
import hep.io.root.daemon.xrootd.Multiplexor;
import hep.io.root.daemon.xrootd.OpenFile;
import hep.io.root.daemon.xrootd.OpenOperation;
import hep.io.root.daemon.xrootd.Operation;
import hep.io.root.daemon.xrootd.Response;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReadOperation
extends Operation<Integer> {
    private OpenFile file;

    ReadOperation(OpenFile file, long fileOffset, byte[] buffer, int bufOffset, int size) {
        super("read", new ReadMessage(file, fileOffset, size), new ReadCallback(ByteBuffer.wrap(buffer, bufOffset, size)));
        this.file = file;
    }

    ReadOperation(OpenFile file, long fileOffset, ByteBuffer buffer) {
        super("read", new ReadMessage(file, fileOffset, buffer.remaining()), new ReadCallback(buffer));
        this.file = file;
    }

    ReadOperation(OpenFile file, FileChannel fileChannel, long fileOffset, int size) {
        super("read", new ReadMessage(file, fileOffset, size), new FileReadCallback(fileChannel, fileOffset, size));
        this.file = file;
    }

    @Override
    Operation getPrerequisite() {
        return new OpenOperation(this.file);
    }

    @Override
    Destination getDestination() {
        return this.file.getDestination();
    }

    @Override
    Multiplexor getMultiplexor() {
        return this.file.getMultiplexor();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileReadCallback
    extends Callback<Integer> {
        private FileChannel fileChannel;
        private long bufOffset;
        private long readLength;
        private int bufLength;

        FileReadCallback(FileChannel fileChannel, long bufOffset, int bufLength) {
            this.bufOffset = bufOffset;
            this.readLength = 0L;
            this.bufLength = bufLength;
            this.fileChannel = fileChannel;
        }

        @Override
        public Integer responseReady(Response response) throws IOException {
            int ll = 0;
            while (ll < response.getLength()) {
                long l = this.fileChannel.transferFrom(response.getSocketChannel(), this.bufOffset + this.readLength + (long)ll, response.getLength() - ll);
                if (l <= 0L) {
                    throw new EOFException();
                }
                ll = (int)((long)ll + l);
            }
            this.readLength += (long)ll;
            return this.readLength == 0L ? -1 : (int)this.readLength;
        }

        @Override
        public void clear() {
            this.readLength = 0L;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReadCallback
    extends Callback<Integer> {
        private ByteBuffer buffer;
        private int initialPosition;

        ReadCallback(ByteBuffer buffer) {
            this.initialPosition = buffer.position();
            this.buffer = buffer;
        }

        @Override
        public Integer responseReady(Response response) throws IOException {
            response.readData(this.buffer);
            int result = this.buffer.position() - this.initialPosition;
            return result == 0 ? -1 : result;
        }

        @Override
        public void clear() {
            this.buffer.position(this.initialPosition);
        }
    }

    private static class ReadMessage
    extends Message {
        private OpenFile file;
        private long fileOffset;
        private int size;

        ReadMessage(OpenFile file, long fileOffset, int size) {
            super(3013);
            this.file = file;
            this.fileOffset = fileOffset;
            this.size = size;
        }

        void writeExtra(ByteBuffer out) throws IOException {
            out.putInt(this.file.getHandle());
            out.putLong(this.fileOffset);
            out.putInt(this.size);
        }
    }
}

