/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.daemon.xrootd;

import hep.io.root.daemon.xrootd.Callback;
import hep.io.root.daemon.xrootd.FileStatus;
import hep.io.root.daemon.xrootd.Message;
import hep.io.root.daemon.xrootd.OpenFile;
import hep.io.root.daemon.xrootd.Operation;
import hep.io.root.daemon.xrootd.Response;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OpenOperation
extends Operation<OpenFile> {
    OpenOperation(String path, int mode, int options) {
        this(new OpenFile(path, mode, options));
    }

    OpenOperation(OpenFile file) {
        super("open", new OpenMessage(file), new OpenCallback(file));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OpenCallback
    extends Callback<OpenFile> {
        private OpenFile file;

        OpenCallback(OpenFile file) {
            this.file = file;
        }

        @Override
        public OpenFile responseReady(Response response) throws IOException {
            int handle = response.readInt();
            this.file.setHandleAndDestination(handle, response.getDestination(), response.getMultiplexor());
            if (response.getLength() > 4) {
                this.file.setCompressionSize(response.readInt());
            }
            if (response.getLength() > 8) {
                this.file.setCompressionType(response.readInt());
            }
            if (response.getLength() > 12) {
                String info = response.getDataAsString();
                this.file.setStatus(new FileStatus(info, response.getDestination()));
            }
            return this.file;
        }
    }

    private static class OpenMessage
    extends Message {
        private OpenFile file;

        OpenMessage(OpenFile file) {
            super(3010, file.getPath());
            this.writeShort(file.getMode());
            this.writeShort(file.getOptions());
            this.file = file;
        }
    }
}

