/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.daemon.xrootd;

import hep.io.root.daemon.xrootd.AuthOperation;
import hep.io.root.daemon.xrootd.Destination;
import hep.io.root.daemon.xrootd.LoginOperation;
import hep.io.root.daemon.xrootd.Multiplexor;
import hep.io.root.daemon.xrootd.MultiplexorMBean;
import hep.io.root.daemon.xrootd.Response;
import hep.io.root.daemon.xrootd.ResponseListener;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.StandardMBean;

class MultiplexorManager {
    private static Logger logger = Logger.getLogger(MultiplexorManager.class.getName());
    private static MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
    private Map<Destination, Multiplexor> multiplexorMap = new HashMap<Destination, Multiplexor>();
    private Map<Destination, List<MultiplexorReadyCallback>> inProgressConnections = new HashMap<Destination, List<MultiplexorReadyCallback>>();
    private ScheduledThreadPoolExecutor scheduler;

    MultiplexorManager(ScheduledThreadPoolExecutor scheduler) {
        this.scheduler = scheduler;
        scheduler.scheduleAtFixedRate(new IdleConnectionCloser(), 5L, 5L, TimeUnit.SECONDS);
    }

    private void createMultiplexor(Destination destination, int attempt) {
        Destination actualDestination = destination.getAlternateDestination(attempt);
        try {
            Multiplexor multiplexor = new Multiplexor(actualDestination);
            multiplexor.connect(new LoginResponseListener(actualDestination, attempt));
        }
        catch (IOException x) {
            this.connectionFailed(actualDestination, attempt, x);
        }
    }

    private synchronized void connectionComplete(Multiplexor multiplexor) {
        this.multiplexorMap.put(multiplexor.getDestination(), multiplexor);
        this.registerMultiplexor(multiplexor);
        List<MultiplexorReadyCallback> callbacks = this.inProgressConnections.get(multiplexor.getDestination());
        for (MultiplexorReadyCallback callback : callbacks) {
            callback.multiplexorReady(multiplexor);
        }
        this.inProgressConnections.remove(multiplexor.getDestination());
    }

    private synchronized void connectionFailed(Destination destination, int attempt, IOException iOException) {
        logger.log(Level.WARNING, String.format("Connection to %s failed (attempt %d) ", destination, attempt), iOException);
        this.scheduler.schedule(new Reconnect(destination, attempt + 1), 2L, TimeUnit.SECONDS);
    }

    synchronized Multiplexor getMultiplexor(Destination destination, MultiplexorReadyCallback callback) {
        Multiplexor result = this.multiplexorMap.get(destination);
        if (result != null && result.isSocketClosed()) {
            this.multiplexorMap.remove(result);
            this.unregisterMultiplexor(result);
            result = null;
        }
        if (result == null) {
            List<MultiplexorReadyCallback> callbacks = this.inProgressConnections.get(destination);
            if (callbacks == null) {
                callbacks = new ArrayList<MultiplexorReadyCallback>();
                this.inProgressConnections.put(destination, callbacks);
                callbacks.add(callback);
                this.createMultiplexor(destination, 0);
            } else {
                callbacks.add(callback);
            }
        }
        return result;
    }

    private ObjectName getObjectNameForMultiplexor(Multiplexor m) throws MalformedObjectNameException {
        return new ObjectName("hep.io.root.daemon.xrootd:type=Multiplexor,name=" + m.toString().replace(":", ";"));
    }

    private void registerMultiplexor(Multiplexor result) {
        try {
            mbs.registerMBean(new StandardMBean(result, MultiplexorMBean.class), this.getObjectNameForMultiplexor(result));
        }
        catch (Exception x) {
            logger.log(Level.WARNING, "Could not register multiplexor mbean", x);
        }
    }

    private void unregisterMultiplexor(Multiplexor m) {
        try {
            mbs.unregisterMBean(this.getObjectNameForMultiplexor(m));
        }
        catch (Exception x) {
            logger.log(Level.WARNING, "Could not unregister multiplexor mbean", x);
        }
    }

    private class IdleConnectionCloser
    implements Runnable {
        private IdleConnectionCloser() {
        }

        public void run() {
            Iterator i = MultiplexorManager.this.multiplexorMap.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                Multiplexor m = (Multiplexor)entry.getValue();
                if (!m.isIdle()) continue;
                i.remove();
                MultiplexorManager.this.unregisterMultiplexor(m);
                m.close();
                logger.log(Level.FINE, "Closed idle connection: " + m);
            }
        }
    }

    private class Reconnect
    implements Runnable {
        private Destination destination;
        private int attempt;

        public Reconnect(Destination destination, int attempt) {
            this.destination = destination;
            this.attempt = attempt;
        }

        public void run() {
            MultiplexorManager.this.createMultiplexor(this.destination, this.attempt);
        }
    }

    private class LoginResponseListener
    implements ResponseListener {
        private Destination destination;
        private LoginOperation login;
        private AuthOperation auth;
        private Stage stage = Stage.CONNECT;
        private int attempt;

        LoginResponseListener(Destination destination, int attempt) {
            this.attempt = attempt;
            this.destination = destination;
            this.login = new LoginOperation(destination.getUserName());
        }

        public void reschedule(long seconds, TimeUnit SECONDS) {
            throw new UnsupportedOperationException("Not supported during login.");
        }

        public void handleError(IOException iOException) {
            throw new UnsupportedOperationException("Not supported during login.");
        }

        public void handleRedirect(String host, int port) throws UnknownHostException {
            throw new UnsupportedOperationException("Not supported during login.");
        }

        public void handleResponse(Response response) throws IOException {
            switch (this.stage) {
                case CONNECT: {
                    response.getMultiplexor().handleInitialHandshakeResponse(response);
                    this.stage = Stage.LOGIN;
                    response.getMultiplexor().sendMessage(this.login.getMessage(), this);
                    break;
                }
                case LOGIN: {
                    LoginOperation.LoginSession session = (LoginOperation.LoginSession)this.login.getCallback().responseReady(response);
                    if (session.getSecurity() != null) {
                        this.stage = Stage.AUTH;
                        this.auth = new AuthOperation();
                        response.getMultiplexor().sendMessage(this.auth.getMessage(), this);
                        break;
                    }
                    MultiplexorManager.this.connectionComplete(response.getMultiplexor());
                    break;
                }
                case AUTH: {
                    this.auth.getCallback().responseReady(response);
                    MultiplexorManager.this.connectionComplete(response.getMultiplexor());
                }
            }
        }

        public void handleSocketError(IOException iOException) {
            MultiplexorManager.this.connectionFailed(this.destination, this.attempt, iOException);
        }
    }

    static interface MultiplexorReadyCallback {
        public void multiplexorReady(Multiplexor var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Stage {
        CONNECT,
        LOGIN,
        AUTH;

    }
}

