/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.daemon.xrootd;

import hep.io.root.daemon.xrootd.Destination;
import java.util.Date;

public class FileStatus {
    private String id;
    private long size;
    private int flags;
    private Date modTime;
    private Destination destination;

    FileStatus(String response, Destination destination) {
        String[] tokens = response.replace("\u0000", "").split(" +");
        this.id = tokens[0];
        this.size = Long.parseLong(tokens[1]);
        this.flags = Integer.parseInt(tokens[2]);
        this.modTime = new Date(Long.parseLong(tokens[3]) * 1000L);
        this.destination = destination;
    }

    public int getFlags() {
        return this.flags;
    }

    public String getId() {
        return this.id;
    }

    public Date getModTime() {
        return this.modTime;
    }

    public long getSize() {
        return this.size;
    }

    public String toString() {
        return String.format("location=%s id=%s\nsize=%,d lastModified=%s flags=%d", this.destination, this.id, this.size, this.modTime, this.flags);
    }

    public Destination getFileLocation() {
        return this.destination;
    }
}

