/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.core;

import hep.io.root.RootClass;
import hep.io.root.RootClassNotFound;
import hep.io.root.core.BasicMember;
import hep.io.root.core.BasicRootClass;
import hep.io.root.core.GenericRootClass;
import hep.io.root.core.IntrinsicRootClass;
import hep.io.root.core.RootClassFactory;
import hep.io.root.core.StreamerInfo;
import hep.io.root.interfaces.TStreamerBasicPointer;
import hep.io.root.interfaces.TStreamerElement;
import hep.io.root.interfaces.TStreamerInfo;
import hep.io.root.interfaces.TStreamerLoop;
import java.util.Vector;
import org.apache.bcel.Constants;
import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.ANEWARRAY;
import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.GOTO;
import org.apache.bcel.generic.IFEQ;
import org.apache.bcel.generic.IF_ICMPGE;
import org.apache.bcel.generic.IINC;
import org.apache.bcel.generic.ILOAD;
import org.apache.bcel.generic.ISTORE;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.NEWARRAY;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;

public class StreamerInfoNew
extends StreamerInfo
implements Constants {
    private static final int kBase = 0;
    private static final int kOffsetL = 20;
    private static final int kOffsetP = 40;
    private static final int kCounter = 6;
    private static final int kCharStar = 7;
    private static final int kChar = 1;
    private static final int kShort = 2;
    private static final int kInt = 3;
    private static final int kLong = 4;
    private static final int kFloat = 5;
    private static final int kDouble = 8;
    private static final int kDouble32 = 9;
    private static final int kUChar = 11;
    private static final int kUShort = 12;
    private static final int kUInt = 13;
    private static final int kULong = 14;
    private static final int kBits = 15;
    private static final int kLong64 = 16;
    private static final int kULong64 = 17;
    private static final int kBool = 18;
    private static final int kObject = 61;
    private static final int kAny = 62;
    private static final int kObjectp = 63;
    private static final int kObjectP = 64;
    private static final int kTString = 65;
    private static final int kTObject = 66;
    private static final int kTNamed = 67;
    private static final int kMissing = 99999;
    private static final int kSkip = 100;
    private static final int kSkipL = 120;
    private static final int kSkipP = 140;
    private static final int kObjectV = 47;
    private static final int kObjectVV = 48;
    private static final int kConv = 200;
    private static final int kConvL = 220;
    private static final int kConvP = 240;
    private static final int kStreamer = 500;
    private static final int kStreamLoop = 501;
    private static final int kSTL = 300;
    private static final int kSTLstring = 365;
    private static final int kSTLvector = 1;
    private static final int kSTLlist = 2;
    private static final int kSTLdeque = 3;
    private static final int kSTLmap = 4;
    private static final int kSTLset = 5;
    private static final int kSTLmultimap = 6;
    private static final int kSTLmultiset = 7;
    private TStreamerInfo streamerInfo;
    private boolean resolved = false;
    private static boolean debug = System.getProperty("debugRoot") != null;

    public StreamerInfoNew(TStreamerInfo streamerInfo) {
        this.streamerInfo = streamerInfo;
    }

    public int getCheckSum() {
        return this.streamerInfo.getCheckSum();
    }

    public int getVersion() {
        return this.streamerInfo.getClassVersion();
    }

    public void resolve(RootClassFactory factory) throws RootClassNotFound {
        if (!this.resolved) {
            Vector<BasicRootClass> sv = new Vector<BasicRootClass>();
            Vector<BasicMember> mv = new Vector<BasicMember>();
            for (TStreamerElement element : this.streamerInfo.getElements()) {
                if (element == null) continue;
                String typeName = element.getTypeName().toString();
                if (typeName.equals("BASE")) {
                    String className = element.getName().toString();
                    sv.addElement(factory.create(className));
                    continue;
                }
                try {
                    mv.addElement(new MemberNew(element, factory));
                }
                catch (RootClassNotFound x) {
                    if (debug) {
                        System.err.println("Substituting dummy element for " + element.getName() + " of type " + x.getClassName());
                    }
                    mv.addElement(new DummyMember(element, factory));
                }
            }
            this.superClasses = new RootClass[sv.size()];
            sv.copyInto(this.superClasses);
            this.members = new BasicMember[mv.size()];
            mv.copyInto(this.members);
            this.resolved = true;
        }
    }

    int getBits() {
        return this.streamerInfo.getBits();
    }

    private class DummyMember
    extends BasicMember {
        private String varComment;
        private String varName;
        private int[] maxIndex;
        private int arrayDim;
        private int varType;

        DummyMember(TStreamerElement element, RootClassFactory factory) {
            this.varName = element.getName();
            this.varComment = element.getTitle();
            this.arrayDim = element.getArrayDim();
            this.varType = element.getType();
            this.maxIndex = element.getMaxIndex();
        }

        public int getArrayDim() {
            return this.arrayDim;
        }

        public String getComment() {
            return this.varComment;
        }

        public Type getJavaType() {
            return Type.STRING;
        }

        public int getMaxIndex(int index) {
            return this.maxIndex[index];
        }

        public String getName() {
            return this.varName;
        }

        public RootClass getType() {
            return null;
        }

        public void generateReadCode(InstructionList il, InstructionFactory factory, ConstantPoolGen cp, String className) {
            System.err.println("Warnng: Generating dummy read for " + this.varName);
            il.append((Instruction)factory.createInvoke("hep.io.root.core.RootInput", "skipObject", (Type)Type.VOID, Type.NO_ARGS, (short)185));
        }
    }

    private class MemberNew
    extends BasicMember {
        private BasicRootClass varClass;
        private String varComment;
        private String varCounter;
        private String varName;
        private int[] maxIndex;
        private int arrayDim;
        private int varType;

        MemberNew(TStreamerElement element, RootClassFactory factory) throws RootClassNotFound {
            this.varName = element.getName();
            this.varComment = element.getTitle();
            this.arrayDim = element.getArrayDim();
            String typeName = element.getTypeName();
            this.varType = element.getType();
            this.maxIndex = element.getMaxIndex();
            if (typeName.endsWith("*")) {
                if (this.varType == 62) {
                    this.varType = 64;
                }
                typeName = typeName.substring(0, typeName.length() - 1);
            }
            if (this.varType >= 40 && this.varType <= 60) {
                ++this.arrayDim;
            }
            this.varClass = this.varType == 3 ? factory.create("Int_t") : factory.create(typeName);
            if (element instanceof TStreamerBasicPointer) {
                this.varCounter = ((TStreamerBasicPointer)element).getCountName();
            } else if (element instanceof TStreamerLoop) {
                this.varCounter = ((TStreamerLoop)element).getCountName();
                ++this.arrayDim;
            }
        }

        public int getArrayDim() {
            return this.arrayDim;
        }

        public String getComment() {
            return this.varComment;
        }

        public Type getJavaType() {
            Type t = this.varClass.getJavaTypeForMethod();
            if (this.arrayDim > 0) {
                t = new ArrayType(t, this.arrayDim);
            }
            return t;
        }

        public int getMaxIndex(int index) {
            return this.maxIndex[index];
        }

        public String getName() {
            return this.varName;
        }

        public RootClass getType() {
            return this.varClass;
        }

        public String getVarCounter() {
            return this.varCounter;
        }

        public void generateReadCode(InstructionList il, InstructionFactory factory, ConstantPoolGen cp, String className) {
            try {
                switch (this.varType) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 65: 
                    case 66: 
                    case 67: {
                        this.varClass.generateReadCode(il, factory, cp);
                        break;
                    }
                    case 7: {
                        il.append((Instruction)InstructionConstants.DUP);
                        il.append((Instruction)factory.createInvoke("hep.io.root.core.RootInput", "readInt", (Type)Type.INT, Type.NO_ARGS, (short)185));
                        il.append((Instruction)factory.createInvoke("hep.io.root.core.RootInput", "skipBytes", (Type)Type.INT, new Type[]{Type.INT}, (short)185));
                        il.append((Instruction)InstructionConstants.POP);
                        il.append(InstructionConstants.ICONST_0);
                        break;
                    }
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 48: 
                    case 49: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 56: 
                    case 57: 
                    case 58: {
                        il.append((Instruction)InstructionConstants.DUP);
                        il.append((Instruction)factory.createInvoke("hep.io.root.core.RootInput", "readByte", (Type)Type.BYTE, Type.NO_ARGS, (short)185));
                        BranchHandle bh = il.append((BranchInstruction)new IFEQ(null));
                        il.append((Instruction)InstructionConstants.ALOAD_0);
                        il.append((Instruction)factory.createInvoke(className, nameMangler.mangleMember(this.varCounter), (Type)Type.INT, Type.NO_ARGS, (short)183));
                        BasicType type = (BasicType)this.varClass.getJavaType();
                        il.append((Instruction)new NEWARRAY(type));
                        il.append((Instruction)InstructionConstants.DUP_X1);
                        Type[] arrayArgType = new Type[]{new ArrayType((Type)type, 1)};
                        il.append((Instruction)factory.createInvoke("hep.io.root.core.RootInput", "readFixedArray", (Type)Type.VOID, arrayArgType, (short)185));
                        BranchHandle bh2 = il.append((BranchInstruction)new GOTO(null));
                        bh.setTarget(il.append((Instruction)InstructionConstants.POP));
                        il.append(InstructionConstants.ACONST_NULL);
                        bh2.setTarget(il.append(InstructionConstants.NOP));
                        break;
                    }
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 28: 
                    case 29: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 36: 
                    case 37: 
                    case 38: {
                        IntrinsicRootClass intrinsic = (IntrinsicRootClass)this.varClass;
                        intrinsic.generateReadArrayCode(il, factory, cp, this.arrayDim, this.maxIndex);
                        break;
                    }
                    case 64: {
                        ((GenericRootClass)this.varClass).generateReadPointerCode(il, factory, cp);
                        break;
                    }
                    case 501: {
                        if (!this.varClass.getClassName().equals("TString")) {
                            System.err.println("Warning: Generating dummy read for " + this.varName);
                            il.append((Instruction)factory.createInvoke("hep.io.root.core.RootInput", "dump", (Type)Type.VOID, Type.NO_ARGS, (short)185));
                            il.append(InstructionConstants.ACONST_NULL);
                            break;
                        }
                        il.append((Instruction)factory.createInvoke("hep.io.root.core.RootInput", "readVersion", (Type)Type.INT, Type.NO_ARGS, (short)185));
                        il.append((Instruction)InstructionConstants.POP);
                        BasicMember varMember = StreamerInfoNew.this.getMember(this.varCounter);
                        if (varMember == null) {
                            throw new RuntimeException("Cannot find variable counter " + this.varCounter);
                        }
                        Type varMemberType = varMember.getJavaType();
                        il.append((Instruction)InstructionConstants.DUP);
                        il.append((Instruction)factory.createInvoke(className, nameMangler.mangleMember(this.varCounter), varMemberType, Type.NO_ARGS, (short)183));
                        if (varMemberType != Type.INT) {
                            il.append(factory.createCast(varMemberType, (Type)Type.INT));
                        }
                        il.append((Instruction)InstructionConstants.DUP);
                        il.append((Instruction)InstructionConstants.ISTORE_2);
                        ObjectType xxxType = (ObjectType)this.varClass.getJavaTypeForMethod();
                        il.append((Instruction)new ANEWARRAY(cp.addClass(xxxType)));
                        il.append((Instruction)new ASTORE(3));
                        il.append(InstructionConstants.ICONST_0);
                        il.append((Instruction)new ISTORE(4));
                        InstructionHandle ih = il.append((Instruction)new ILOAD(4));
                        il.append((Instruction)InstructionConstants.ILOAD_2);
                        BranchHandle bh = il.append((BranchInstruction)new IF_ICMPGE(null));
                        il.append((Instruction)new ALOAD(3));
                        il.append((Instruction)new ILOAD(4));
                        il.append((Instruction)InstructionConstants.ALOAD_1);
                        this.varClass.generateReadCode(il, factory, cp);
                        if (this.varClass.getConvertMethod() != null && this.arrayDim == 1) {
                            il.append((Instruction)factory.createInvoke("hep.io.root.interfaces." + this.varClass.getClassName(), this.varClass.getConvertMethod(), this.varClass.getJavaTypeForMethod(), Type.NO_ARGS, (short)185));
                        }
                        il.append((Instruction)InstructionConstants.AASTORE);
                        il.append((Instruction)new IINC(4, 1));
                        il.append((BranchInstruction)new GOTO(ih));
                        bh.setTarget(il.append(InstructionConstants.NOP));
                        il.append((Instruction)new ALOAD(3));
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unable to decode varType " + this.varType + " in class " + className);
                    }
                }
                if (this.varClass.getConvertMethod() != null && this.arrayDim == 0) {
                    il.append((Instruction)factory.createInvoke("hep.io.root.interfaces." + this.varClass.getClassName(), this.varClass.getConvertMethod(), this.varClass.getJavaTypeForMethod(), Type.NO_ARGS, (short)185));
                }
            }
            catch (RuntimeException x) {
                System.err.println("Error reading member " + this.varName + " of type " + this.varClass.getClassName());
                throw x;
            }
        }
    }
}

