/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.core;

import hep.io.root.RootClass;
import hep.io.root.RootMember;
import hep.io.root.core.BasicMember;
import hep.io.root.core.BasicRootClass;
import hep.io.root.core.ClassBuilder;
import hep.io.root.core.GenericRootClass;
import hep.io.root.core.NameMangler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.bcel.Constants;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.CPInstruction;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.EmptyVisitor;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.Type;
import org.apache.bcel.generic.Visitor;

class ProxyBuilder
implements ClassBuilder,
Constants {
    private static boolean debugRoot = System.getProperty("debugRoot") != null;
    private static NameMangler nameMangler = NameMangler.instance();
    private boolean hasHeader;

    public ProxyBuilder() {
        this(true);
    }

    protected ProxyBuilder(boolean hasHeader) {
        this.hasHeader = hasHeader;
    }

    public String getStem() {
        return "hep.io.root.proxy";
    }

    public JavaClass build(GenericRootClass klass) {
        Class<?> implementedInterface;
        ArrayList<GenericRootClass> sup;
        InstructionFactory factory;
        InstructionList il;
        ConstantPoolGen cp;
        ClassGen cg;
        String className;
        block11: {
            className = nameMangler.mangleFullClassName(this.getStem(), klass.getClassName());
            cg = new ClassGen(className, "hep/io/root/core/AbstractRootObject", "<generated>", 33, new String[]{nameMangler.mangleInterfaceName(klass.getClassName())});
            cp = cg.getConstantPool();
            il = new InstructionList();
            factory = new InstructionFactory(cg);
            cg.addEmptyConstructor(1);
            sup = new ArrayList<GenericRootClass>();
            RootClass[] superClasses = klass.getSuperClasses();
            this.iterativelyAdd(sup, superClasses);
            sup.add(klass);
            Iterator i = sup.listIterator(sup.size());
            while (i.hasPrevious()) {
                BasicRootClass rc = (BasicRootClass)i.previous();
                String repName = "hep.io.root.reps." + rc.getClassName() + "Rep";
                try {
                    Class<?> repClass = Class.forName(repName);
                    JavaClass rep = Repository.lookupClass(repClass);
                    if (rep == null) continue;
                    Field[] repFields = rep.getFields();
                    ConstantPoolGen oldCp = new ConstantPoolGen(rep.getConstantPool().copy());
                    for (int j = 0; j < repFields.length; ++j) {
                        if (repFields[j].isStatic() || cg.containsField(repFields[j].getName()) != null) continue;
                        cg.addField(new FieldGen(repFields[j], cp).getField());
                    }
                    Method[] repMethods = rep.getMethods();
                    for (int j = 0; j < repMethods.length; ++j) {
                        if (repMethods[j].isAbstract() || repMethods[j].getName().equals("<init>") || cg.containsMethod(repMethods[j].getName(), repMethods[j].getSignature()) != null) continue;
                        MethodGen mg = new MethodGen(repMethods[j], className, cp);
                        CPFixup fixup = new CPFixup(oldCp, cp, repName, className);
                        Iterator it = mg.getInstructionList().iterator();
                        while (it.hasNext()) {
                            ((InstructionHandle)it.next()).accept((Visitor)fixup);
                        }
                        cg.addMethod(mg.getMethod());
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            i = sup.iterator();
            while (i.hasNext()) {
                this.generateFields((RootClass)i.next(), cp, cg);
            }
            implementedInterface = null;
            try {
                implementedInterface = Class.forName(nameMangler.mangleInterfaceName(klass.getClassName()));
            }
            catch (ClassNotFoundException x) {
                if (!debugRoot) break block11;
                System.out.println("Warning, could not load interface " + klass.getClassName());
            }
        }
        Iterator i = sup.iterator();
        while (i.hasNext()) {
            ProxyBuilder.generateMethods((RootClass)i.next(), cp, il, factory, cg, className, implementedInterface);
        }
        if (cg.containsMethod("readMembers", "(Lhep/io/root/core/RootInput;)V") == null) {
            MethodGen mg = new MethodGen(1, (Type)Type.VOID, new Type[]{new ObjectType("hep/io/root/core/RootInput")}, new String[]{"in"}, "readMembers", null, il, cp);
            mg.addException("java/io/IOException");
            klass.generateStreamer(cp, il, factory, className, this.hasHeader);
            il.append((Instruction)InstructionConstants.RETURN);
            mg.setMaxStack();
            mg.setMaxLocals();
            cg.addMethod(mg.getMethod());
            il.dispose();
        }
        return cg.getJavaClass();
    }

    private void generateFields(RootClass k, ConstantPoolGen cp, ClassGen cg) {
        RootMember[] members = k.getMembers();
        for (int i = 0; i < members.length; ++i) {
            Type type;
            if (cg.containsField(members[i].getName()) != null || (type = ((BasicMember)members[i]).getJavaType()) == null) continue;
            FieldGen fg = new FieldGen(2, type, members[i].getName(), cp);
            cg.addField(fg.getField());
        }
    }

    private static void generateMethods(RootClass k, ConstantPoolGen cp, InstructionList il, InstructionFactory factory, ClassGen cg, String className, Class implementedInterface) {
        RootMember[] members = k.getMembers();
        for (int i = 0; i < members.length; ++i) {
            Type type;
            Type returnType = type = ((BasicMember)members[i]).getJavaType();
            try {
                if (implementedInterface != null) {
                    returnType = Type.getType(implementedInterface.getMethod(nameMangler.mangleMember(members[i].getName()), null).getReturnType());
                }
                if (!returnType.equals((Object)type) && debugRoot) {
                    System.err.println("Warning: Interface type mismatch " + implementedInterface.getName() + "." + nameMangler.mangleMember(members[i].getName()) + " " + returnType + " " + type);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (cg.containsMethod(nameMangler.mangleMember(members[i].getName()), "()" + returnType.getSignature()) != null) continue;
            MethodGen mg = new MethodGen(1, returnType, null, null, nameMangler.mangleMember(members[i].getName()), null, il, cp);
            if (members[i].getType() == null) {
                il.append((CompoundInstruction)new PUSH(cp, "<<Unreadable>>"));
            } else {
                il.append((Instruction)InstructionConstants.ALOAD_0);
                il.append((Instruction)factory.createGetField(className, members[i].getName(), type));
            }
            if (!returnType.equals((Object)type)) {
                il.append(factory.createCast(type, returnType));
            }
            il.append((Instruction)InstructionFactory.createReturn((Type)returnType));
            mg.setMaxStack();
            mg.setMaxLocals();
            cg.addMethod(mg.getMethod());
            il.dispose();
        }
    }

    private void iterativelyAdd(List list, RootClass[] superClasses) {
        for (int i = 0; i < superClasses.length; ++i) {
            RootClass[] supsup = superClasses[i].getSuperClasses();
            this.iterativelyAdd(list, supsup);
            list.add(superClasses[i]);
        }
    }

    private static class CPFixup
    extends EmptyVisitor {
        private ConstantPoolGen newCP;
        private ConstantPoolGen oldCP;
        private String newClass;
        private String oldClass;

        CPFixup(ConstantPoolGen oldCP, ConstantPoolGen newCP, String oldClass, String newClass) {
            this.oldCP = oldCP;
            this.newCP = newCP;
            this.oldClass = oldClass;
            this.newClass = newClass;
        }

        public void visitCPInstruction(CPInstruction cpi) {
            ConstantCP fr;
            int index = cpi.getIndex();
            Constant oldConstant = this.oldCP.getConstant(index);
            if (oldConstant instanceof ConstantCP && (fr = (ConstantCP)oldConstant).getClass(this.oldCP.getConstantPool()).equals(this.oldClass)) {
                fr.setClassIndex(this.oldCP.addClass(this.newClass));
            }
            index = this.newCP.addConstant(oldConstant, this.oldCP);
            cpi.setIndex(index);
        }
    }
}

