/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.core;

import hep.io.root.RootClass;
import hep.io.root.RootMember;
import hep.io.root.core.BasicMember;
import hep.io.root.core.ClassBuilder;
import hep.io.root.core.GenericRootClass;
import hep.io.root.core.NameMangler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.Type;

class CloneBuilder
implements ClassBuilder,
Constants {
    private static NameMangler nameMangler = NameMangler.instance();
    private static boolean optimize;

    CloneBuilder() {
    }

    public String getStem() {
        return "hep.io.root.clone";
    }

    public JavaClass build(GenericRootClass klass) {
        optimize = (klass.getStreamerInfo().getBits() & 0x1000) == 0;
        String className = nameMangler.mangleFullClassName(this.getStem(), klass.getClassName());
        String clonesClassName = nameMangler.mangleFullClassName("hep.io.root.clones", klass.getClassName());
        ClassGen cg = new ClassGen(className, "hep/io/root/core/Clone", "<generated>", 33, new String[]{nameMangler.mangleInterfaceName(klass.getClassName())});
        ConstantPoolGen cp = cg.getConstantPool();
        InstructionList il = new InstructionList();
        InstructionFactory factory = new InstructionFactory(cg);
        cg.addEmptyConstructor(1);
        ArrayList<GenericRootClass> sup = new ArrayList<GenericRootClass>();
        RootClass[] superClasses = klass.getSuperClasses();
        this.iterativelyAdd(sup, superClasses);
        sup.add(klass);
        cg.addField(new FieldGen(2, (Type)Type.INT, "index", cp).getField());
        cg.addField(new FieldGen(2, (Type)new ObjectType(clonesClassName), "clones", cp).getField());
        MethodGen mg = new MethodGen(1, (Type)Type.VOID, new Type[]{Type.INT, new ObjectType("hep.io.root.core.Clones")}, new String[]{"index", "clones"}, "setData", className, il, cp);
        il.append((Instruction)InstructionConstants.ALOAD_0);
        il.append((Instruction)InstructionConstants.ILOAD_1);
        il.append((Instruction)factory.createPutField(className, "index", (Type)Type.INT));
        il.append((Instruction)InstructionConstants.ALOAD_0);
        il.append((Instruction)InstructionConstants.ALOAD_2);
        il.append(factory.createCast((Type)new ObjectType("hep.io.root.core.Clones"), (Type)new ObjectType(clonesClassName)));
        il.append((Instruction)factory.createPutField(className, "clones", (Type)new ObjectType(clonesClassName)));
        il.append((Instruction)InstructionConstants.RETURN);
        mg.setMaxStack();
        mg.setMaxLocals();
        cg.addMethod(mg.getMethod());
        il.dispose();
        Iterator i = sup.iterator();
        while (i.hasNext()) {
            CloneBuilder.generateMethods((RootClass)i.next(), cp, il, factory, cg, className, clonesClassName);
        }
        return cg.getJavaClass();
    }

    private static void generateMethods(RootClass k, ConstantPoolGen cp, InstructionList il, InstructionFactory factory, ClassGen cg, String className, String clonesClassName) {
        if (k.getClassName().equals("TObject") && optimize) {
            return;
        }
        RootMember[] members = k.getMembers();
        int blockStart = -1;
        int blockEnd = -1;
        for (int i = 0; i < members.length; ++i) {
            ArrayType arrayType;
            Type type;
            BasicMember member = (BasicMember)members[i];
            if (optimize && i + 1 < members.length && member.getArrayDim() == 0 && member.getJavaType().equals((Object)((BasicMember)members[i + 1]).getJavaType())) {
                if (blockStart < 0) {
                    blockStart = i;
                }
                blockEnd = i + 2;
                continue;
            }
            if (blockStart < 0) {
                type = member.getJavaType();
                arrayType = new ArrayType(type, 1);
                MethodGen mg = new MethodGen(1, type, null, null, nameMangler.mangleMember(member.getName()), className, il, cp);
                il.append((Instruction)InstructionConstants.ALOAD_0);
                il.append((Instruction)factory.createGetField(className, "clones", (Type)new ObjectType(clonesClassName)));
                il.append((Instruction)factory.createGetField(clonesClassName, member.getName(), (Type)arrayType));
                il.append((Instruction)InstructionConstants.ALOAD_0);
                il.append((Instruction)factory.createGetField(className, "index", (Type)Type.INT));
                il.append((Instruction)InstructionFactory.createArrayLoad((Type)type));
                il.append((Instruction)InstructionFactory.createReturn((Type)type));
                mg.setMaxStack();
                mg.setMaxLocals();
                cg.addMethod(mg.getMethod());
                il.dispose();
                continue;
            }
            type = member.getJavaType();
            arrayType = new ArrayType(type, 1);
            int multiplier = blockEnd - blockStart;
            for (int j = blockStart; j < blockEnd; ++j) {
                int offset = j - blockStart;
                BasicMember blockMember = (BasicMember)members[j];
                MethodGen mg = new MethodGen(1, type, null, null, nameMangler.mangleMember(blockMember.getName()), className, il, cp);
                il.append((Instruction)InstructionConstants.ALOAD_0);
                il.append((Instruction)factory.createGetField(className, "clones", (Type)new ObjectType(clonesClassName)));
                il.append((Instruction)factory.createGetField(clonesClassName, member.getName(), (Type)arrayType));
                il.append((Instruction)InstructionConstants.ALOAD_0);
                il.append((Instruction)factory.createGetField(className, "index", (Type)Type.INT));
                il.append((CompoundInstruction)new PUSH(cp, multiplier));
                il.append((Instruction)InstructionConstants.IMUL);
                if (offset > 0) {
                    il.append((CompoundInstruction)new PUSH(cp, offset));
                    il.append((Instruction)InstructionConstants.IADD);
                }
                il.append((Instruction)InstructionFactory.createArrayLoad((Type)type));
                il.append((Instruction)InstructionFactory.createReturn((Type)type));
                mg.setMaxStack();
                mg.setMaxLocals();
                cg.addMethod(mg.getMethod());
                il.dispose();
            }
            blockStart = -1;
        }
    }

    private void iterativelyAdd(List list, RootClass[] superClasses) {
        for (int i = 0; i < superClasses.length; ++i) {
            RootClass[] supsup = superClasses[i].getSuperClasses();
            this.iterativelyAdd(list, supsup);
            list.add(superClasses[i]);
        }
    }
}

