/*
 * Decompiled with CFR 0.152.
 */
package org.jblas;

import org.jblas.ComplexDoubleMatrix;
import org.jblas.ComplexFloatMatrix;
import org.jblas.DoubleMatrix;
import org.jblas.FloatMatrix;
import org.jblas.SimpleBlas;

public class Eigen {
    private static final DoubleMatrix dummyDouble = new DoubleMatrix(1);
    private static final FloatMatrix dummyFloat = new FloatMatrix(1);

    public static DoubleMatrix symmetricEigenvalues(DoubleMatrix A) {
        A.assertSquare();
        DoubleMatrix eigenvalues = new DoubleMatrix(A.rows);
        int[] isuppz = new int[2 * A.rows];
        SimpleBlas.syevr('N', 'A', 'U', A.dup(), 0.0, 0.0, 0, 0, 0.0, eigenvalues, dummyDouble, isuppz);
        return eigenvalues;
    }

    public static DoubleMatrix[] symmetricEigenvectors(DoubleMatrix A) {
        A.assertSquare();
        DoubleMatrix eigenvalues = new DoubleMatrix(A.rows);
        DoubleMatrix eigenvectors = A.dup();
        int[] isuppz = new int[2 * A.rows];
        SimpleBlas.syevr('V', 'A', 'U', A.dup(), 0.0, 0.0, 0, 0, 0.0, eigenvalues, eigenvectors, isuppz);
        return new DoubleMatrix[]{eigenvectors, DoubleMatrix.diag(eigenvalues)};
    }

    public static ComplexDoubleMatrix eigenvalues(DoubleMatrix A) {
        A.assertSquare();
        DoubleMatrix WR = new DoubleMatrix(A.rows);
        DoubleMatrix WI = WR.dup();
        SimpleBlas.geev('N', 'N', A.dup(), WR, WI, dummyDouble, dummyDouble);
        return new ComplexDoubleMatrix(WR, WI);
    }

    public static ComplexDoubleMatrix[] eigenvectors(DoubleMatrix A) {
        A.assertSquare();
        DoubleMatrix WR = new DoubleMatrix(A.rows);
        DoubleMatrix WI = WR.dup();
        DoubleMatrix VR = new DoubleMatrix(A.rows, A.rows);
        SimpleBlas.geev('N', 'V', A.dup(), WR, WI, dummyDouble, VR);
        ComplexDoubleMatrix E = new ComplexDoubleMatrix(WR, WI);
        ComplexDoubleMatrix V = new ComplexDoubleMatrix(A.rows, A.rows);
        for (int i = 0; i < A.rows; ++i) {
            if (E.get(i).isReal()) {
                V.putColumn(i, new ComplexDoubleMatrix(VR.getColumn(i)));
                continue;
            }
            ComplexDoubleMatrix v = new ComplexDoubleMatrix(VR.getColumn(i), VR.getColumn(i + 1));
            V.putColumn(i, v);
            V.putColumn(i + 1, v.conji());
            ++i;
        }
        return new ComplexDoubleMatrix[]{V, ComplexDoubleMatrix.diag(E)};
    }

    public static DoubleMatrix symmetricGeneralizedEigenvalues(DoubleMatrix A, DoubleMatrix B) {
        A.assertSquare();
        B.assertSquare();
        DoubleMatrix W = new DoubleMatrix(A.rows);
        SimpleBlas.sygvd(1, 'N', 'U', A.dup(), B.dup(), W);
        return W;
    }

    public static DoubleMatrix[] symmetricGeneralizedEigenvectors(DoubleMatrix A, DoubleMatrix B) {
        A.assertSquare();
        B.assertSquare();
        DoubleMatrix[] result = new DoubleMatrix[2];
        DoubleMatrix dA = A.dup();
        DoubleMatrix dB = B.dup();
        DoubleMatrix W = new DoubleMatrix(dA.rows);
        SimpleBlas.sygvd(1, 'V', 'U', dA, dB, W);
        result[0] = dA;
        result[1] = W;
        return result;
    }

    public static FloatMatrix symmetricEigenvalues(FloatMatrix A) {
        A.assertSquare();
        FloatMatrix eigenvalues = new FloatMatrix(A.rows);
        int[] isuppz = new int[2 * A.rows];
        SimpleBlas.syevr('N', 'A', 'U', A.dup(), 0.0f, 0.0f, 0, 0, 0.0f, eigenvalues, dummyFloat, isuppz);
        return eigenvalues;
    }

    public static FloatMatrix[] symmetricEigenvectors(FloatMatrix A) {
        A.assertSquare();
        FloatMatrix eigenvalues = new FloatMatrix(A.rows);
        FloatMatrix eigenvectors = A.dup();
        int[] isuppz = new int[2 * A.rows];
        SimpleBlas.syevr('V', 'A', 'U', A.dup(), 0.0f, 0.0f, 0, 0, 0.0f, eigenvalues, eigenvectors, isuppz);
        return new FloatMatrix[]{eigenvectors, FloatMatrix.diag(eigenvalues)};
    }

    public static ComplexFloatMatrix eigenvalues(FloatMatrix A) {
        A.assertSquare();
        FloatMatrix WR = new FloatMatrix(A.rows);
        FloatMatrix WI = WR.dup();
        SimpleBlas.geev('N', 'N', A.dup(), WR, WI, dummyFloat, dummyFloat);
        return new ComplexFloatMatrix(WR, WI);
    }

    public static ComplexFloatMatrix[] eigenvectors(FloatMatrix A) {
        A.assertSquare();
        FloatMatrix WR = new FloatMatrix(A.rows);
        FloatMatrix WI = WR.dup();
        FloatMatrix VR = new FloatMatrix(A.rows, A.rows);
        SimpleBlas.geev('N', 'V', A.dup(), WR, WI, dummyFloat, VR);
        ComplexFloatMatrix E = new ComplexFloatMatrix(WR, WI);
        ComplexFloatMatrix V = new ComplexFloatMatrix(A.rows, A.rows);
        for (int i = 0; i < A.rows; ++i) {
            if (E.get(i).isReal()) {
                V.putColumn(i, new ComplexFloatMatrix(VR.getColumn(i)));
                continue;
            }
            ComplexFloatMatrix v = new ComplexFloatMatrix(VR.getColumn(i), VR.getColumn(i + 1));
            V.putColumn(i, v);
            V.putColumn(i + 1, v.conji());
            ++i;
        }
        return new ComplexFloatMatrix[]{V, ComplexFloatMatrix.diag(E)};
    }

    public static FloatMatrix symmetricGeneralizedEigenvalues(FloatMatrix A, FloatMatrix B) {
        A.assertSquare();
        B.assertSquare();
        FloatMatrix W = new FloatMatrix(A.rows);
        SimpleBlas.sygvd(1, 'N', 'U', A.dup(), B.dup(), W);
        return W;
    }

    public static FloatMatrix[] symmetricGeneralizedEigenvectors(FloatMatrix A, FloatMatrix B) {
        A.assertSquare();
        B.assertSquare();
        FloatMatrix[] result = new FloatMatrix[2];
        FloatMatrix dA = A.dup();
        FloatMatrix dB = B.dup();
        FloatMatrix W = new FloatMatrix(dA.rows);
        SimpleBlas.sygvd(1, 'V', 'U', dA, dB, W);
        result[0] = dA;
        result[1] = W;
        return result;
    }
}

