/*
 * Decompiled with CFR 0.152.
 */
package com.edsdev.jconvert.util;

import com.edsdev.jconvert.util.Logger;
import com.edsdev.jconvert.util.ResourceManager;
import java.util.Properties;

public class JConvertProperties {
    private static Properties props = null;
    public static final String MAJOR_VERSION = "MajorVersion";
    public static final String MINOR_VERSION = "MinorVersion";
    public static final String REVISION = "Revision";
    public static final String APP_NAME = "ApplicationName";
    public static final String BUILD_DATE = "BuildDate";
    private static final Logger log = Logger.getInstance(JConvertProperties.class);

    private JConvertProperties() {
    }

    public static String getMajorVersion() {
        return props.getProperty(MAJOR_VERSION);
    }

    public static String getMinorVersion() {
        return props.getProperty(MINOR_VERSION);
    }

    public static String getRevision() {
        return props.getProperty(REVISION);
    }

    public static String getAppName() {
        return props.getProperty(APP_NAME);
    }

    public static String getBuildDate() {
        return props.getProperty(BUILD_DATE);
    }

    public static String getProp(String string) {
        return props.getProperty(string);
    }

    public static String getBuidVersion() {
        return JConvertProperties.getMajorVersion() + "." + JConvertProperties.getMinorVersion() + "." + JConvertProperties.getRevision();
    }

    static {
        try {
            props = ResourceManager.loadProperties("jconvert.properties");
        }
        catch (Exception exception) {
            log.error("Failed to load the jconvert properties.", exception);
        }
    }
}

