/*
 * Decompiled with CFR 0.152.
 */
package jport;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.border.EtchedBorder;
import jehep.misc.FontChooser;
import jehep.shelljython.JyShell;
import jhplot.JHPlot;
import jhplot.gui.GHPanel;
import jhplot.utils.AboutDialog;
import jhplot.utils.MemoryMonitor;
import jplot.Utils;
import jport.EnvGlobal;

public abstract class GPortoFrame
extends GHPanel
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected boolean set;
    protected JFrame mainFrame = new JFrame();
    private MemoryMonitor memMon;
    private JPanel infoPanel;
    protected static int N1 = 0;
    protected static int N2 = 0;
    protected int N1final;
    protected int N2final;
    protected int N1edit;
    protected int N2edit;
    protected JMenuBar bar;
    protected JyShell jconsole;
    protected JMenu menu;
    protected JMenu about;
    protected JMenu shell;
    protected JSplitPane splitPane;
    protected JMenuItem item00;
    protected JMenuItem item01;
    protected JMenuItem item02;
    protected JMenuItem item04;
    protected JMenuItem item05;
    protected JMenuItem item06;
    protected JMenuItem item11;
    protected JMenuItem item12;
    protected JMenuItem item_1;
    protected JMenuItem item_2;

    public GPortoFrame(String title, int xsize, int ysize, int n1, int n2, boolean set) {
        super(xsize, ysize);
        this.mainFrame.setDefaultCloseOperation(0);
        this.mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                GPortoFrame.this.quitFrame();
            }
        });
        this.set = set;
        N1 = 0;
        N2 = 0;
        if (n1 == 0 || n2 == 0) {
            n1 = 1;
            n2 = 1;
        }
        this.N1final = n1;
        this.N2final = n2;
        this.mainFrame.setTitle(title);
        ImageIcon icone = new ImageIcon(this.getClass().getClassLoader().getResource("jhplot/images/logo_jhepwork_24x24.jpg"));
        this.mainFrame.setIconImage(icone.getImage());
        this.mainPanel.setLayout(new GridLayout(this.N2final, this.N1final, 0, 0));
        this.infoPanel = new JPanel();
        this.infoPanel.setLayout(new BorderLayout());
        this.infoPanel.setBorder(new EtchedBorder());
        this.infoPanel.add((Component)JHPlot.statusbar, "West");
        this.memMon = new MemoryMonitor();
        this.memMon.setPreferredSize(new Dimension(65, 14));
        this.memMon.setMinimumSize(new Dimension(30, 10));
        this.infoPanel.add((Component)this.memMon, "East");
        this.mainFrame.add((Component)this.infoPanel, "South");
        this.jconsole = new JyShell();
        this.splitPane = new JSplitPane(1, this.CanvasPanel, (Component)this.jconsole);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerLocation(0.65);
        this.mainFrame.getContentPane().add((Component)this.splitPane, "Center");
        this.bar = new JMenuBar();
        this.menu = new JMenu("File");
        this.about = new JMenu("Help");
        this.shell = new JMenu("Settings");
        this.item00 = new JMenuItem(new ExitAction());
        this.item01 = new JMenuItem(new ExportAction());
        this.item02 = new JMenuItem(new PrintAction());
        this.item04 = new JMenuItem(new ReadAction());
        this.item05 = new JMenuItem(new ClearAction());
        this.item06 = new JMenuItem(new RefreshAction());
        this.item11 = new JMenuItem(new ShowAboutAction());
        this.item12 = new JMenuItem(new ShowHelpAction());
        this.menu.add(this.item01);
        this.menu.add(this.item02);
        this.menu.add(this.item04);
        this.menu.add(this.item05);
        this.menu.add(this.item06);
        this.menu.insertSeparator(6);
        this.menu.add(this.item00);
        this.bar.add(this.menu);
        this.about.add(this.item11);
        this.about.add(this.item12);
        this.bar.add(this.about);
        this.mainFrame.setJMenuBar(this.bar);
        this.item_1 = new JMenuItem(new ShellFont());
        this.item_2 = new JMenuItem(new ShellClear());
        this.bar.add(Box.createHorizontalGlue());
        this.shell.add(this.item_1);
        this.shell.add(this.item_2);
        this.bar.add(this.shell);
        this.mainFrame.pack();
    }

    protected void RefreshJSsoft() {
        Thread t = new Thread("refreshing beanshell"){

            @Override
            public void run() {
                GPortoFrame.this.jconsole.clear();
                System.gc();
            }
        };
        t.start();
    }

    public GPortoFrame(String title, int n1, int n2) {
        this(title, n1, n2, 1, 1, true);
    }

    public GPortoFrame(String title, int xs, int ys, boolean set) {
        this(title, xs, ys, 1, 1, set);
    }

    public GPortoFrame(String title, int xs, int ys, int n1, int n2) {
        this(title, xs, ys, n1, n2, true);
    }

    public GPortoFrame(String title) {
        this(title, 600, 400, 1, 1, true);
    }

    public GPortoFrame() {
        this("Default", 600, 400, 1, 1, true);
    }

    public void addGraph(int i1, int i2, Component a) {
        this.addComp(a);
    }

    public void cd(int cols, int rows) {
        N1 = cols - 1;
        N2 = rows - 1;
        if (cols > this.N1final || rows > this.N2final) {
            this.ErrorMessage("Wrong number of canvas in cd() method\n  ");
            N1 = 0;
            N2 = 0;
            return;
        }
    }

    public int getCdX() {
        return N1;
    }

    public void setPlotsNum(int nx, int ny) {
        this.N1final = nx;
        this.N2final = ny;
        this.mainPanel.setLayout(new GridLayout(this.N2final, this.N1final, 0, 0));
        this.CanvasPanel.updateUI();
    }

    public void updateFrame() {
        this.CanvasPanel.repaint();
        this.CanvasPanel.updateUI();
        this.mainFrame.repaint();
    }

    public int getNtotX() {
        return this.N1final;
    }

    public int getNtotY() {
        return this.N2final;
    }

    public int getCdY() {
        return N2;
    }

    protected void doNotShowFrame() {
        this.mainFrame.setVisible(false);
    }

    protected void removeFrame() {
        this.item00 = null;
        this.item11 = null;
        this.item01 = null;
        this.item02 = null;
        this.menu = null;
        this.about = null;
        this.memMon = null;
        this.infoPanel = null;
        this.disposeGHPanel();
        this.mainFrame.setVisible(false);
        this.mainFrame.dispose();
        this.jconsole = null;
        System.gc();
    }

    public JFrame getFrame() {
        return this.mainFrame;
    }

    public URL getHTMLUrl(String name) {
        URL url = null;
        try {
            url = this.getClass().getResource("/html/" + name);
        }
        catch (Exception e) {
            Utils.oops((Frame)this.mainFrame, (String)"Impossible to load the About content.\nSomething's wrong with the installation.");
        }
        return url;
    }

    protected void showAbout() {
        new AboutDialog((Component)this.mainFrame);
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    protected abstract void OpenReadDialog();

    protected abstract void ClearFrame();

    protected abstract void RefreshFrame();

    protected abstract void showHelp();

    protected abstract void quitFrame();

    public void fontChooser() {
        Font f = FontChooser.showDialog((Frame)this.getFrame(), (String)"Choose font", (Font)EnvGlobal.globalFont);
        if (f != null) {
            EnvGlobal.globalFont = f;
            this.jconsole.setConsoleFont(f);
            this.jconsole.clear();
        }
    }

    private void ErrorMessage(String a) {
        JOptionPane dialogError = new JOptionPane();
        JOptionPane.showMessageDialog(dialogError, a, "Error", 0);
    }

    private class ExitAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        ExitAction() {
            super("Exit");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GPortoFrame.this.quitFrame();
        }
    }

    private class ExportAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        ExportAction() {
            super("Export");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    private class PrintAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        PrintAction() {
            super("Print");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GPortoFrame.this.printGraph();
        }
    }

    private class ReadAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        ReadAction() {
            super("Read Jython file");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GPortoFrame.this.OpenReadDialog();
        }
    }

    private class ClearAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        ClearAction() {
            super("Clear frame");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GPortoFrame.this.ClearFrame();
        }
    }

    private class RefreshAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        RefreshAction() {
            super("Refresh frame");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GPortoFrame.this.RefreshFrame();
        }
    }

    private class ShowAboutAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        ShowAboutAction() {
            super("About");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GPortoFrame.this.showAbout();
        }
    }

    private class ShowHelpAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        ShowHelpAction() {
            super("Help");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GPortoFrame.this.showHelp();
        }
    }

    private class ShellFont
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        ShellFont() {
            super("Fonts");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GPortoFrame.this.fontChooser();
        }
    }

    private class ShellClear
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        ShellClear() {
            super("Reload");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GPortoFrame.this.RefreshJSsoft();
        }
    }
}

