/*
 * Decompiled with CFR 0.152.
 */
package com.aptech.gaussApi5_0;

import au.com.forward.utils.ReadWriteOrderedLock;
import com.aptech.gaussApi5_0.Gauss;
import com.aptech.gaussApi5_0.GaussErrorLogException;
import com.aptech.gaussApi5_0.GaussException;
import com.aptech.gaussApi5_0.GaussMatrix;
import com.aptech.gaussApi5_0.GaussMatrixInfo;
import com.aptech.gaussApi5_0.GaussStringArray;
import com.aptech.gaussApi5_0.IGaussReader;
import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;

public class GaussWorkspace {
    private static final int COMPILE_EXECUTE = 1;
    private static final int COMPILE_EXECUTE_FILE = 2;
    private static final int COMPILE_SAVE = 3;
    private static final int COMPILE_SAVE_FILE = 4;
    private static final int LOAD_EXECUTE_FILE = 5;
    private static final int SAVE_WORKSPACE = 6;
    private static final int SET_MATRIX = 7;
    private static final int SET_STRING = 8;
    private static final int SET_STRING_ARRAY = 9;
    public static int MAX_NUMBER_OF_ERROR_MESSAGES = 6;
    private static Writer defaultOutput = new PrintWriter(System.out);
    private static Writer defaultError = new PrintWriter(System.err);
    private static String lastDefaultOutputThread = "";
    private static String lastDefaultErrorThread = "";
    private static ThreadLocal<ArrayList<Writer>> outputList = new ThreadLocal<ArrayList<Writer>>(){

        @Override
        protected ArrayList<Writer> initialValue() {
            return new ArrayList<Writer>(1);
        }
    };
    private static ThreadLocal<ArrayList<Writer>> errorList = new ThreadLocal<ArrayList<Writer>>(){

        @Override
        protected ArrayList<Writer> initialValue() {
            return new ArrayList<Writer>(1);
        }
    };
    private static ThreadLocal<IGaussReader> input = new ThreadLocal<IGaussReader>(){

        @Override
        protected IGaussReader initialValue() {
            return null;
        }
    };
    private static ThreadLocal<String> errorMsg = new ThreadLocal<String>(){

        @Override
        protected String initialValue() {
            return null;
        }
    };
    private static ThreadLocal<Exception> writeException = new ThreadLocal<Exception>(){

        @Override
        protected Exception initialValue() {
            return null;
        }
    };
    private static ThreadLocal<Integer> errorMsgNo = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return new Integer(0);
        }
    };
    private static ThreadLocal<Integer> nextKey = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return new Integer(0);
        }
    };
    private ReadWriteOrderedLock callDisposeLock = new ReadWriteOrderedLock(Gauss.DEBUG_THREADS);
    ReadWriteOrderedLock workspaceLock = new ReadWriteOrderedLock(Gauss.DEBUG_THREADS);
    private String name = null;
    private String fileName = null;
    private String loadedGaussName = null;
    private int gaussWorkspaceHandle = -1;
    private int activeCalls = 0;
    private boolean shutdownCalled = false;

    public GaussWorkspace(String string) {
        this.name = string = Gauss.checkForEmptyString(string, "workspaceName");
        Gauss.createWorkspace(this);
    }

    public GaussWorkspace(String string, File file) {
        this.name = string = Gauss.checkForEmptyString(string, "workspaceName");
        this.fileName = file.getPath();
        Gauss.createWorkspace(this);
        this.loadedGaussName = this.getGaussName();
        this.setGaussName(string);
    }

    GaussWorkspace() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultOutput(Writer writer) {
        if (writer == null) {
            throw new NullPointerException("Cannot set a null defaultOut");
        }
        Writer writer2 = defaultOutput;
        synchronized (writer2) {
            defaultOutput = writer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultError(Writer writer) {
        if (writer == null) {
            throw new NullPointerException("Cannot set a null defaultError");
        }
        Writer writer2 = defaultError;
        synchronized (writer2) {
            defaultError = writer;
        }
    }

    public static void setGaussReader(IGaussReader iGaussReader) {
        input.set(iGaussReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Writer getDefaultOutput() {
        Writer writer = defaultOutput;
        synchronized (writer) {
            return defaultOutput;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Writer getDefaultError() {
        Writer writer = defaultError;
        synchronized (writer) {
            return defaultError;
        }
    }

    public static IGaussReader getGaussReader() {
        return input.get();
    }

    public static int getSymbolType(Object object) {
        if (object == null) {
            return -1;
        }
        if (object instanceof GaussMatrix) {
            return 6;
        }
        if (object instanceof String) {
            return 13;
        }
        if (object instanceof GaussStringArray) {
            return 15;
        }
        return -1;
    }

    public static void error(String string) {
        writeException.set(null);
        GaussWorkspace.flushOutput();
        GaussWorkspace.outputIoString(string, errorList.get(), true, true);
        Exception exception = writeException.get();
        writeException.set(null);
        if (exception != null) {
            throw new GaussException(exception);
        }
    }

    public static void output(String string) {
        GaussWorkspace.output(string, false);
    }

    public static void output(String string, boolean bl) {
        writeException.set(null);
        GaussWorkspace.outputIoString(string, outputList.get(), false, bl);
        Exception exception = writeException.get();
        writeException.set(null);
        if (exception != null) {
            throw new GaussException(exception);
        }
    }

    public static void addOutputWriter(Writer writer) {
        if (writer == null) {
            throw new NullPointerException("Cannot add a null Writer");
        }
        ArrayList<Writer> arrayList = outputList.get();
        arrayList.add(writer);
        outputList.set(arrayList);
    }

    public static void removeOutputWriter(Writer writer) {
        if (writer == null) {
            throw new NullPointerException("Cannot remove a null Writer");
        }
        ArrayList<Writer> arrayList = outputList.get();
        int n = arrayList.indexOf(writer);
        if (n >= 0) {
            arrayList.remove(n);
        }
        outputList.set(arrayList);
    }

    public static void removeAllOutputWriters() {
        ArrayList<Writer> arrayList = outputList.get();
        arrayList.clear();
        outputList.set(arrayList);
    }

    public static void addErrorWriter(Writer writer) {
        if (writer == null) {
            throw new NullPointerException("Cannot add a null Writer");
        }
        ArrayList<Writer> arrayList = errorList.get();
        arrayList.add(writer);
        errorList.set(arrayList);
    }

    public static void removeErrorWriter(Writer writer) {
        if (writer == null) {
            throw new NullPointerException("Cannot remove a null Writer");
        }
        ArrayList<Writer> arrayList = errorList.get();
        int n = arrayList.indexOf(writer);
        if (n >= 0) {
            arrayList.remove(n);
        }
        errorList.set(arrayList);
    }

    public static void removeAllErrorWriters() {
        ArrayList<Writer> arrayList = errorList.get();
        arrayList.clear();
        errorList.set(arrayList);
    }

    public static void flushOutputs() {
        writeException.set(null);
        GaussWorkspace.flushOutput();
        Exception exception = writeException.get();
        writeException.set(null);
        if (exception != null) {
            throw new GaussException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void flushOutput() {
        block10: {
            ArrayList<Writer> arrayList = outputList.get();
            if (arrayList.isEmpty()) {
                try {
                    Writer writer = defaultOutput;
                    synchronized (writer) {
                        defaultOutput.flush();
                    }
                }
                catch (Exception exception) {
                    if (writeException.get() != null) break block10;
                    writeException.set(exception);
                }
            } else {
                for (int i = 0; i < arrayList.size(); ++i) {
                    try {
                        arrayList.get(i).flush();
                        continue;
                    }
                    catch (Exception exception) {
                        if (writeException.get() != null) continue;
                        writeException.set(exception);
                    }
                }
            }
        }
    }

    private static byte[] getBytes(int n) {
        IGaussReader iGaussReader = input.get();
        byte[] byArray = new byte[]{0};
        if (iGaussReader == null) {
            Integer n2;
            if (writeException.get() == null) {
                writeException.set(new GaussException("con or cons called but no input IGaussReader set."));
            }
            if ((n2 = nextKey.get()) != 0) {
                byArray = new String("x").getBytes();
            }
            GaussWorkspace.updateNextKey(n2);
            return byArray;
        }
        try {
            String string = iGaussReader.cons(n);
            byte[] byArray2 = string.getBytes();
            if (byArray2.length > n && writeException.get() == null) {
                writeException.set(new GaussException("String returned by call to IGaussReader.cons() exceeded " + n + " maxBytesToRead. String:'" + string + "'"));
            }
            return byArray2;
        }
        catch (Exception exception) {
            Integer n3;
            if (writeException.get() == null) {
                writeException.set(exception);
            }
            if ((n3 = nextKey.get()) != 0) {
                byArray = new String("x").getBytes();
            }
            GaussWorkspace.updateNextKey(n3);
            return byArray;
        }
    }

    private static void outputErrorGaussBytes(byte[] byArray) {
        GaussWorkspace.flushOutput();
        String string = "";
        string = new String(byArray);
        int n = errorMsgNo.get();
        if (n < MAX_NUMBER_OF_ERROR_MESSAGES) {
            String string2 = errorMsg.get();
            if (string2 != null) {
                errorMsg.set(string2 + string);
            } else {
                errorMsg.set(string);
            }
            errorMsgNo.set(new Integer(n + 1));
        }
        GaussWorkspace.outputIoString(string, errorList.get(), true, true);
    }

    private static void outputGaussBytes(byte[] byArray) {
        String string = "";
        string = new String(byArray);
        GaussWorkspace.outputIoString(string, outputList.get(), false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void outputIoString(String string, ArrayList arrayList, boolean bl, boolean bl2) {
        if (arrayList.isEmpty()) {
            Writer writer = defaultError;
            synchronized (writer) {
                Writer writer2 = defaultOutput;
                synchronized (writer2) {
                    block17: {
                        String string2 = Thread.currentThread().getName();
                        String string3 = Gauss.nl + "Thread:" + Thread.currentThread().getName() + " -- " + Gauss.nl;
                        try {
                            Writer writer3;
                            if (bl) {
                                writer3 = defaultError;
                                if (!lastDefaultErrorThread.equals(string2)) {
                                    writer3.flush();
                                    writer3.write(string3);
                                    lastDefaultErrorThread = string2;
                                }
                            } else {
                                writer3 = defaultOutput;
                                if (!lastDefaultOutputThread.equals(string2)) {
                                    writer3.flush();
                                    writer3.write(string3);
                                    lastDefaultOutputThread = string2;
                                }
                            }
                            writer3.write(string);
                            if (bl2) {
                                writer3.flush();
                            }
                        }
                        catch (Exception exception) {
                            if (writeException.get() != null) break block17;
                            writeException.set(exception);
                        }
                    }
                }
            }
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            try {
                Writer writer = (Writer)arrayList.get(i);
                writer.write(string);
                if (!bl2) continue;
                writer.flush();
                continue;
            }
            catch (Exception exception) {
                if (writeException.get() != null) continue;
                writeException.set(exception);
            }
        }
    }

    private static void updateNextKey(int n) {
        if (n == 0) {
            nextKey.set(new Integer(-1));
        } else {
            nextKey.set(new Integer(0));
        }
    }

    private static int key() {
        IGaussReader iGaussReader = input.get();
        int n = 0;
        if (iGaussReader == null) {
            if (writeException.get() == null) {
                writeException.set(new GaussException("key() called but no input IGaussReader set."));
            }
            Integer n2 = nextKey.get();
            n = n2;
            GaussWorkspace.updateNextKey(n);
            return n;
        }
        try {
            return iGaussReader.key();
        }
        catch (Exception exception) {
            if (writeException.get() == null) {
                writeException.set(exception);
            }
            Integer n3 = nextKey.get();
            n = n3;
            GaussWorkspace.updateNextKey(n);
            return n;
        }
    }

    private static int keyw() {
        IGaussReader iGaussReader = input.get();
        int n = 0;
        if (iGaussReader == null) {
            if (writeException.get() == null) {
                writeException.set(new GaussException("keyw or show called but no input IGaussReader set."));
            }
            Integer n2 = nextKey.get();
            n = n2;
            GaussWorkspace.updateNextKey(n);
            return n;
        }
        try {
            return iGaussReader.keyw();
        }
        catch (Exception exception) {
            if (writeException.get() == null) {
                writeException.set(exception);
            }
            Integer n3 = nextKey.get();
            n = n3;
            GaussWorkspace.updateNextKey(n);
            return n;
        }
    }

    private static int keyav() {
        IGaussReader iGaussReader = input.get();
        int n = 0;
        if (iGaussReader == null) {
            if (writeException.get() == null) {
                writeException.set(new GaussException("keyav() called but no input IGaussReader set"));
            }
            Integer n2 = nextKey.get();
            n = n2;
            GaussWorkspace.updateNextKey(n);
            return n;
        }
        try {
            return iGaussReader.keyav();
        }
        catch (Exception exception) {
            if (writeException.get() == null) {
                writeException.set(exception);
            }
            Integer n3 = nextKey.get();
            n = n3;
            GaussWorkspace.updateNextKey(n);
            return n;
        }
    }

    public void setGlobal(String string, Object object) {
        string = Gauss.checkForEmptyString(string, "globalName");
        if (object == null) {
            throw new NullPointerException("Cannot set a null global");
        }
        if (object instanceof String) {
            byte[] byArray = ((String)object).getBytes();
            this.setObject(string, byArray, 8);
        } else if (object instanceof GaussMatrix) {
            this.setObject(string, object, 7);
        } else if (object instanceof GaussStringArray) {
            this.setObject(string, object, 9);
        } else {
            throw new IllegalArgumentException("global is not a String, GaussMatrix or GaussStringArray");
        }
    }

    public String getName() {
        return this.name;
    }

    public String getLoadFileName() {
        return this.fileName;
    }

    public String getLoadGaussName() {
        return this.loadedGaussName;
    }

    protected void setGaussName(String string) {
        int n = -1;
        if (string == null) {
            throw new NullPointerException("Gauss name cannot be null.");
        }
        n = this.addCall();
        if (n < 0) {
            throw new IllegalStateException("GaussWorkspace " + this.getName() + " has beed disposed.");
        }
        if (Gauss.DEBUG_THREADS) {
            System.out.println("in setGaussName for " + this.getName() + " requestReadLock() on thread:" + Thread.currentThread().getName());
        }
        try {
            this.workspaceLock.requestReadLock();
        }
        catch (InterruptedException interruptedException) {
            this.removeCall(false);
            throw new GaussException("setGaussName() interrupted while waiting to access the GAUSS Engine.", interruptedException, 0);
        }
        try {
            string = string + Gauss.STRING_TERMINATION;
            byte[] byArray = string.getBytes();
            this.JNI_SetGaussName(n, byArray);
        }
        catch (RuntimeException runtimeException) {
            this.throwErrorMsgException();
            throw runtimeException;
        }
        finally {
            this.workspaceLock.releaseLock();
            if (Gauss.DEBUG_THREADS) {
                System.out.println("in setGaussName for " + this.getName() + " releaseReadLock() on thread:" + Thread.currentThread().getName());
            }
            this.removeCall(true);
        }
    }

    public String getGaussName() {
        int n = -1;
        String string = null;
        n = this.addCall();
        if (n < 0) {
            throw new IllegalStateException("GaussWorkspace " + this.getName() + " has beed disposed.");
        }
        if (Gauss.DEBUG_THREADS) {
            System.out.println("in getGaussName for " + this.getName() + " requestReadLock() on thread:" + Thread.currentThread().getName());
        }
        try {
            this.workspaceLock.requestReadLock();
        }
        catch (InterruptedException interruptedException) {
            this.removeCall(false);
            throw new GaussException("getGaussName() interrupted while waiting to access the GAUSS Engine.", interruptedException, 0);
        }
        try {
            byte[] byArray = GaussWorkspace.JNI_GetGaussName(n);
            if (byArray == null) {
                String string2 = "";
                return string2;
            }
            String string3 = string = new String(byArray);
            return string3;
        }
        catch (RuntimeException runtimeException) {
            this.throwErrorMsgException();
            throw runtimeException;
        }
        finally {
            this.workspaceLock.releaseLock();
            if (Gauss.DEBUG_THREADS) {
                System.out.println("in getGaussName for " + this.getName() + " releaseReadLock() on thread:" + Thread.currentThread().getName());
            }
            this.removeCall(true);
        }
    }

    public Object getGlobal(String string) {
        int n = -1;
        string = Gauss.checkForEmptyString(string, "globalName");
        n = this.addCall();
        if (n < 0) {
            throw new IllegalStateException("GaussWorkspace " + this.getName() + " has been disposed.");
        }
        if (Gauss.DEBUG_THREADS) {
            System.out.println("in getGlobal for " + this.getName() + " requestReadLock() on thread:" + Thread.currentThread().getName());
        }
        try {
            this.workspaceLock.requestReadLock();
        }
        catch (InterruptedException interruptedException) {
            this.removeCall(false);
            throw new GaussException("getGlobal() interrupted while waiting for access to GAUSS Engine.", interruptedException, 0);
        }
        try {
            string = string + Gauss.STRING_TERMINATION;
            byte[] byArray = string.getBytes();
            Object object = this.JNI_GetGlobal(n, byArray);
            return object;
        }
        catch (RuntimeException runtimeException) {
            this.throwErrorMsgException();
            throw runtimeException;
        }
        finally {
            this.workspaceLock.releaseLock();
            if (Gauss.DEBUG_THREADS) {
                System.out.println("in getGlobal for " + this.getName() + " releaseReadLock() on thread:" + Thread.currentThread().getName());
            }
            this.removeCall(true);
        }
    }

    public GaussMatrixInfo getMatrixInfo(String string) {
        int n = -1;
        string = Gauss.checkForEmptyString(string, "globalMatrixName");
        n = this.addCall();
        if (n < 0) {
            throw new IllegalStateException("GaussWorkspace " + this.getName() + " has beed disposed.");
        }
        if (Gauss.DEBUG_THREADS) {
            System.out.println("in getMatrixInfo for " + this.getName() + " requestReadLock() on thread:" + Thread.currentThread().getName());
        }
        try {
            this.workspaceLock.requestReadLock();
        }
        catch (InterruptedException interruptedException) {
            this.removeCall(false);
            throw new GaussException("getMatrixInfo() interrupted while waiting for access to GAUSS Engine.", interruptedException, 0);
        }
        try {
            string = string + Gauss.STRING_TERMINATION;
            byte[] byArray = string.getBytes();
            GaussMatrixInfo gaussMatrixInfo = (GaussMatrixInfo)this.JNI_GetMatrixInfo(n, byArray);
            return gaussMatrixInfo;
        }
        catch (RuntimeException runtimeException) {
            this.throwErrorMsgException();
            throw runtimeException;
        }
        finally {
            this.workspaceLock.releaseLock();
            if (Gauss.DEBUG_THREADS) {
                System.out.println("in getMatrixInfo for " + this.getName() + " releaseReadLock() on thread:" + Thread.currentThread().getName());
            }
            this.removeCall(true);
        }
    }

    public int getSymbolType(String string) {
        int n = -1;
        string = Gauss.checkForEmptyString(string, "globalName");
        n = this.addCall();
        if (n < 0) {
            throw new IllegalStateException("GaussWorkspace " + this.getName() + " has beed disposed.");
        }
        if (Gauss.DEBUG_THREADS) {
            System.out.println("in getSymbolType for " + this.getName() + " requestReadLock() on thread:" + Thread.currentThread().getName());
        }
        try {
            this.workspaceLock.requestReadLock();
        }
        catch (InterruptedException interruptedException) {
            this.removeCall(false);
            throw new GaussException("getSymbolType() interrupted while waiting for access to GAUSS Engine.", interruptedException, 0);
        }
        try {
            string = string + Gauss.STRING_TERMINATION;
            byte[] byArray = string.getBytes();
            int n2 = this.JNI_GetSymbolType(n, byArray);
            return n2;
        }
        catch (RuntimeException runtimeException) {
            this.throwErrorMsgException();
            throw runtimeException;
        }
        finally {
            this.workspaceLock.releaseLock();
            if (Gauss.DEBUG_THREADS) {
                System.out.println("in getSymbolType for " + this.getName() + " releaseReadLock() on thread:" + Thread.currentThread().getName());
            }
            this.removeCall(true);
        }
    }

    public synchronized int getNumberOfActiveCalls() {
        return this.activeCalls;
    }

    public void clearGlobal(String string) {
        string = Gauss.checkForEmptyString(string, "globalName");
        this.run("clearg " + string + ";", false, false);
    }

    public void copyGlobal(String string, GaussWorkspace gaussWorkspace, String string2) {
        int n = -1;
        int n2 = -1;
        string = Gauss.checkForEmptyString(string, "fromGlobalName");
        string2 = Gauss.checkForEmptyString(string2, "toGlobalName");
        if (gaussWorkspace == null) {
            throw new NullPointerException("toWorkspace");
        }
        n = this.addCall();
        if (n < 0) {
            throw new IllegalStateException("GaussWorkspace " + this.getName() + " has beed disposed.");
        }
        n2 = gaussWorkspace.addCall();
        if (n2 < 0) {
            this.removeCall(false);
            throw new IllegalStateException("GaussWorkspace " + gaussWorkspace.getName() + " has beed disposed.");
        }
        if (Gauss.DEBUG_THREADS) {
            System.out.println("in copyGlobal for " + this.getName() + " requestReadLock() on thread:" + Thread.currentThread().getName());
        }
        try {
            this.workspaceLock.requestReadLock();
        }
        catch (InterruptedException interruptedException) {
            gaussWorkspace.removeCall(false);
            this.removeCall(false);
            throw new GaussException("getGlobal() interrupted while waiting for access to GAUSS Engine.", interruptedException, 0);
        }
        if (Gauss.DEBUG_THREADS) {
            System.out.println("in copyGlobal for " + gaussWorkspace.getName() + " requestWriteLock() on thread:" + Thread.currentThread().getName());
        }
        try {
            gaussWorkspace.workspaceLock.requestWriteLock();
        }
        catch (InterruptedException interruptedException) {
            this.workspaceLock.releaseLock();
            gaussWorkspace.removeCall(false);
            this.removeCall(false);
            throw new GaussException("copyGlobal() interrupted while waiting for access to GAUSS Engine.", interruptedException, 0);
        }
        try {
            string = string + Gauss.STRING_TERMINATION;
            byte[] byArray = string.getBytes();
            string2 = string2 + Gauss.STRING_TERMINATION;
            byte[] byArray2 = string2.getBytes();
            this.JNI_CopyGlobal(n, byArray, n2, byArray2);
        }
        catch (RuntimeException runtimeException) {
            this.throwErrorMsgException();
            throw runtimeException;
        }
        finally {
            gaussWorkspace.workspaceLock.releaseLock();
            if (Gauss.DEBUG_THREADS) {
                System.out.println("in copyGlobal for " + gaussWorkspace.getName() + " releaseWriteLock() on thread:" + Thread.currentThread().getName());
            }
            this.workspaceLock.releaseLock();
            if (Gauss.DEBUG_THREADS) {
                System.out.println("in copyGlobal for " + this.getName() + " releaseReadLock() on thread:" + Thread.currentThread().getName());
            }
            gaussWorkspace.removeCall(false);
            this.removeCall(true);
        }
    }

    public Object[] call(String string, Object[] objectArray) {
        return this.call(string, objectArray, false);
    }

    public Object[] call(String string, Object[] objectArray, boolean bl) {
        Object[] objectArray2;
        int n = -1;
        int n2 = -1;
        string = Gauss.checkForEmptyString(string, "procedureName");
        if (objectArray == null) {
            throw new NullPointerException("args.  Use new Object[0] if the procedure takes no arguments");
        }
        block9: for (int i = 0; i < objectArray.length; ++i) {
            switch (GaussWorkspace.getSymbolType(objectArray[i])) {
                case 6: 
                case 13: 
                case 15: {
                    continue block9;
                }
                default: {
                    throw new IllegalArgumentException("args[" + i + "] is not a GaussMatrix or String or GaussStringArray");
                }
            }
        }
        n = this.addCall();
        if (n < 0) {
            throw new IllegalStateException("GaussWorkspace " + this.getName() + " has beed disposed.");
        }
        if (Gauss.DEBUG_THREADS) {
            System.out.println("in call for " + this.getName() + " " + (bl ? "requestReadLock()" : "requestWriteLock()") + " on thread:" + Thread.currentThread().getName());
        }
        try {
            if (bl) {
                this.workspaceLock.requestReadLock();
            } else {
                this.workspaceLock.requestWriteLock();
            }
        }
        catch (InterruptedException interruptedException) {
            this.removeCall(false);
            throw new GaussException("call() interrupted while waiting for access to GAUSS Engine.", interruptedException, 0);
        }
        try {
            string = string + Gauss.STRING_TERMINATION;
            byte[] byArray = string.getBytes();
            objectArray2 = this.JNI_CallProcedure(n, byArray, objectArray, bl);
        }
        catch (RuntimeException runtimeException) {
            try {
                this.throwErrorMsgException();
                throw runtimeException;
            }
            catch (Throwable throwable) {
                this.workspaceLock.releaseLock();
                if (Gauss.DEBUG_THREADS) {
                    System.out.println("in call for " + this.getName() + " " + (bl ? "releaseReadLock()" : "releaseWriteLock()") + " on thread:" + Thread.currentThread().getName());
                }
                this.removeCall(true);
                throw throwable;
            }
        }
        this.workspaceLock.releaseLock();
        if (Gauss.DEBUG_THREADS) {
            System.out.println("in call for " + this.getName() + " " + (bl ? "releaseReadLock()" : "releaseWriteLock()") + " on thread:" + Thread.currentThread().getName());
        }
        this.removeCall(true);
        return objectArray2;
    }

    public void run(String string) {
        this.run(string, false, false);
    }

    public void run(String string, boolean bl, boolean bl2) {
        this.compileExecuteSaveProgram(string, bl, bl2, 1, null);
    }

    public void run(File file) {
        this.run(file, false, false);
    }

    public void run(File file, boolean bl, boolean bl2) {
        String string = null;
        string = file.getPath();
        this.compileExecuteSaveProgram(string, bl, bl2, 2, null);
    }

    public void clear() {
        this.run("new", false, false);
    }

    public void load(File file) {
        String string = file.getPath();
        this.compileExecuteSaveProgram(string, false, false, 5, null);
    }

    public void save(String string, File file) {
        this.save(string, false, false, file);
    }

    public void save(String string, boolean bl, boolean bl2, File file) {
        String string2 = file.getPath();
        this.compileExecuteSaveProgram(string, bl, bl2, 3, string2);
    }

    public void save(File file, File file2) {
        this.save(file, false, false, file2);
    }

    public void save(File file, boolean bl, boolean bl2, File file2) {
        String string = file.getPath();
        String string2 = file2.getPath();
        this.compileExecuteSaveProgram(string, bl, bl2, 4, string2);
    }

    public void saveWorkspace(File file) {
        String string = file.getPath();
        this.compileExecuteSaveProgram(string, true, true, 6, null);
    }

    public Object[] execute(String string) {
        return this.execute(string, false, false);
    }

    public Object[] execute(String string, boolean bl, boolean bl2) {
        Object[] objectArray;
        int n = -1;
        Object[] objectArray2 = null;
        n = this.addCall();
        if (n < 0) {
            throw new IllegalStateException("GaussWorkspace " + this.getName() + " has been disposed.");
        }
        if (Gauss.DEBUG_THREADS) {
            System.out.println("in execute for " + this.getName() + " " + (bl2 ? "requestReadLock()" : "requestWriteLock()") + " on thread:" + Thread.currentThread().getName());
        }
        try {
            if (bl2) {
                this.workspaceLock.requestReadLock();
            } else {
                this.workspaceLock.requestWriteLock();
            }
        }
        catch (InterruptedException interruptedException) {
            this.removeCall(false);
            throw new GaussException("execute() interrupted while waiting for access to GAUSS Engine.", interruptedException, 0);
        }
        try {
            string = Gauss.checkForEmptyString(string, "expression");
            string = string + Gauss.STRING_TERMINATION;
            byte[] byArray = string.getBytes();
            if (byArray.length > 20475) {
                throw new IllegalArgumentException("Expression exceeds 20475 bytes.&nbsp;  '" + string.substring(0, 256) + "....'");
            }
            objectArray = objectArray2 = this.JNI_CompileExecuteExpression(n, byArray, bl, bl2);
        }
        catch (RuntimeException runtimeException) {
            try {
                this.throwErrorMsgException();
                throw runtimeException;
            }
            catch (Throwable throwable) {
                this.workspaceLock.releaseLock();
                if (Gauss.DEBUG_THREADS) {
                    System.out.println("in execute for " + this.getName() + " " + (bl2 ? "releaseReadLock()" : "releaseWriteLock()") + " on thread:" + Thread.currentThread().getName());
                }
                this.removeCall(true);
                throw throwable;
            }
        }
        this.workspaceLock.releaseLock();
        if (Gauss.DEBUG_THREADS) {
            System.out.println("in execute for " + this.getName() + " " + (bl2 ? "releaseReadLock()" : "releaseWriteLock()") + " on thread:" + Thread.currentThread().getName());
        }
        this.removeCall(true);
        return objectArray;
    }

    public boolean hasBeenDisposed() {
        return this.getGaussWorkspaceHandle() == -1;
    }

    public void shutdown() {
        this.shutdownCalled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.hasBeenDisposed()) {
            return;
        }
        if (Gauss.DEBUG_THREADS) {
            System.out.println("In dispose for " + this.getName() + " requestWriteLock() on thread:" + Thread.currentThread().getName());
        }
        try {
            this.callDisposeLock.requestWriteLock();
        }
        catch (InterruptedException interruptedException) {
            throw new GaussException("dispose() interrupted while waiting for calls to workspace to complete.", interruptedException, 0);
        }
        try {
            Gauss.disposeWorkspace(this);
        }
        finally {
            if (Gauss.DEBUG_THREADS) {
                System.out.println("Exiting dispose for " + this.getName() + " releaseWriteLock() on thread:" + Thread.currentThread().getName());
            }
            this.callDisposeLock.releaseLock();
        }
    }

    public String toString() {
        String string = "GaussWorkspace '" + this.getName() + "'";
        if (this.fileName != null) {
            string = string + Gauss.nl + " loaded from " + this.fileName + Gauss.nl;
        }
        string = this.hasBeenDisposed() ? string + " disposed " : string + " active (gaussWorkspaceHandle " + this.getGaussWorkspaceHandle() + ")";
        return string;
    }

    synchronized int setGaussWorkspaceHandle(int n) {
        int n2 = this.gaussWorkspaceHandle;
        this.gaussWorkspaceHandle = n;
        return n2;
    }

    synchronized int getGaussWorkspaceHandle() {
        return this.gaussWorkspaceHandle;
    }

    synchronized int addCall() {
        int n = -1;
        if (Gauss.DEBUG_THREADS) {
            System.out.println("in addCall for " + this.getName() + " requestReadTryLock() on thread:" + Thread.currentThread().getName());
        }
        if (this.callDisposeLock.requestReadTryLock()) {
            if (this.shutdownCalled) {
                return -1;
            }
            n = this.getGaussWorkspaceHandle();
            if (n == -1) {
                if (Gauss.DEBUG_THREADS) {
                    System.out.println("Error workspace disposed in addCall for " + this.getName() + " releaseReadLock() on thread:" + Thread.currentThread().getName());
                }
                this.callDisposeLock.releaseLock();
                return n;
            }
            ++this.activeCalls;
            writeException.set(null);
            errorMsg.set(null);
            errorMsgNo.set(new Integer(0));
            nextKey.set(new Integer(0));
        }
        return n;
    }

    synchronized void removeCall(boolean bl) {
        GaussWorkspace.flushOutput();
        nextKey.set(new Integer(0));
        --this.activeCalls;
        if (Gauss.DEBUG_THREADS) {
            System.out.println("in removeCall for " + this.getName() + " releaseReadLock() on thread:" + Thread.currentThread().getName());
        }
        this.callDisposeLock.releaseLock();
        if (this.activeCalls < 0) {
            throw new IllegalStateException("Too many workspace access completed on workspace " + this.getName());
        }
        String string = errorMsg.get();
        errorMsg.set(null);
        errorMsgNo.set(new Integer(0));
        Exception exception = writeException.get();
        writeException.set(null);
        if (bl && string != null) {
            throw new GaussErrorLogException(string);
        }
        if (exception != null) {
            throw new GaussException(exception);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setObject(String string, Object object, int n) {
        int n2 = -1;
        n2 = this.addCall();
        if (n2 < 0) {
            throw new IllegalStateException("GaussWorkspace " + this.getName() + " has been disposed.");
        }
        if (Gauss.DEBUG_THREADS) {
            System.out.println("in setObject for " + this.getName() + " requestWriteLock() on thread:" + Thread.currentThread().getName());
        }
        try {
            this.workspaceLock.requestWriteLock();
        }
        catch (InterruptedException interruptedException) {
            this.removeCall(false);
            throw new GaussException("setObject() interrupted while waiting for access to GAUSS Engine.", interruptedException, 0);
        }
        try {
            string = string + Gauss.STRING_TERMINATION;
            byte[] byArray = string.getBytes();
            switch (n) {
                case 7: {
                    this.JNI_SetMatrix(n2, byArray, (GaussMatrix)object);
                    return;
                }
                case 8: {
                    this.JNI_SetString(n2, byArray, (byte[])object);
                    return;
                }
                case 9: {
                    this.JNI_SetStringArray(n2, byArray, (GaussStringArray)object);
                    return;
                }
                default: {
                    throw new RuntimeException(" Invalid action:" + n);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            this.throwErrorMsgException();
            throw runtimeException;
        }
        finally {
            this.workspaceLock.releaseLock();
            if (Gauss.DEBUG_THREADS) {
                System.out.println("in setObject for " + this.getName() + " releaseWriteLock() on thread:" + Thread.currentThread().getName());
            }
            this.removeCall(true);
        }
    }

    private void throwErrorMsgException() {
        String string = errorMsg.get();
        errorMsg.set(null);
        errorMsgNo.set(new Integer(0));
        if (string != null) {
            throw new GaussErrorLogException(string);
        }
    }

    private void compileExecuteSaveProgram(String string, boolean bl, boolean bl2, int n, String string2) {
        int n2 = -1;
        boolean bl3 = false;
        n2 = this.addCall();
        if (n2 < 0) {
            throw new IllegalStateException("GaussWorkspace " + this.getName() + " has been disposed.");
        }
        if (Gauss.DEBUG_THREADS) {
            System.out.println("in compileExecuteSaveProgram for " + this.getName() + " " + (bl2 ? "requestReadLock()" : "requestWriteLock()") + " on thread:" + Thread.currentThread().getName());
        }
        try {
            switch (n) {
                case 3: 
                case 4: {
                    if (bl) {
                        this.workspaceLock.requestReadLock();
                        break;
                    }
                    this.workspaceLock.requestWriteLock();
                    break;
                }
                default: {
                    if (bl && bl2) {
                        this.workspaceLock.requestReadLock();
                        break;
                    }
                    this.workspaceLock.requestWriteLock();
                    break;
                }
            }
        }
        catch (InterruptedException interruptedException) {
            this.removeCall(false);
            throw new GaussException("Interrupted while waiting for access to GAUSS Engine.", interruptedException, 0);
        }
        try {
            string = Gauss.checkForEmptyString(string, "program or file name");
            bl3 = string.indexOf("\n") >= 0;
            string = string + Gauss.STRING_TERMINATION;
            byte[] byArray = string.getBytes();
            byte[] byArray2 = null;
            if (string2 != null) {
                string2 = string2 + Gauss.STRING_TERMINATION;
                byArray2 = string2.getBytes();
            }
            switch (n) {
                case 1: {
                    this.JNI_CompileExecuteProgram(n2, byArray, bl, bl2, bl3);
                    break;
                }
                case 2: {
                    this.JNI_CompileExecuteProgramFile(n2, byArray, bl, bl2);
                    break;
                }
                case 3: {
                    this.JNI_CompileSaveProgram(n2, byArray, bl, bl2, bl3, byArray2);
                    break;
                }
                case 4: {
                    this.JNI_CompileSaveProgramFile(n2, byArray, bl, bl2, byArray2);
                    break;
                }
                case 5: {
                    this.JNI_LoadExecuteProgramFile(n2, byArray);
                    break;
                }
                case 6: {
                    this.JNI_SaveWorkspace(n2, byArray);
                    break;
                }
                default: {
                    throw new RuntimeException(" Invalid action:" + n);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            try {
                this.throwErrorMsgException();
                throw runtimeException;
            }
            catch (Throwable throwable) {
                this.workspaceLock.releaseLock();
                if (Gauss.DEBUG_THREADS) {
                    System.out.println("in compileExecuteSaveProgram for " + this.getName() + " " + (bl2 ? "releaseReadLock()" : "releaseWriteLock()") + " on thread:" + Thread.currentThread().getName());
                }
                this.removeCall(true);
                throw throwable;
            }
        }
        this.workspaceLock.releaseLock();
        if (Gauss.DEBUG_THREADS) {
            System.out.println("in compileExecuteSaveProgram for " + this.getName() + " " + (bl2 ? "releaseReadLock()" : "releaseWriteLock()") + " on thread:" + Thread.currentThread().getName());
        }
        this.removeCall(true);
    }

    private void swapLock() {
        this.workspaceLock.swapWriteToReadLock();
    }

    private native Object[] JNI_CompileExecuteExpression(int var1, byte[] var2, boolean var3, boolean var4);

    private native void JNI_CompileExecuteProgram(int var1, byte[] var2, boolean var3, boolean var4, boolean var5);

    private native void JNI_CompileExecuteProgramFile(int var1, byte[] var2, boolean var3, boolean var4);

    private native void JNI_CompileSaveProgram(int var1, byte[] var2, boolean var3, boolean var4, boolean var5, byte[] var6);

    private native void JNI_CompileSaveProgramFile(int var1, byte[] var2, boolean var3, boolean var4, byte[] var5);

    private native void JNI_LoadExecuteProgramFile(int var1, byte[] var2);

    private native void JNI_SaveWorkspace(int var1, byte[] var2);

    private native void JNI_SetMatrix(int var1, byte[] var2, GaussMatrix var3);

    private native void JNI_SetString(int var1, byte[] var2, byte[] var3);

    private native void JNI_SetStringArray(int var1, byte[] var2, GaussStringArray var3);

    private native Object JNI_GetGlobal(int var1, byte[] var2);

    private native void JNI_CopyGlobal(int var1, byte[] var2, int var3, byte[] var4);

    private native Object JNI_GetMatrixInfo(int var1, byte[] var2);

    private native int JNI_GetSymbolType(int var1, byte[] var2);

    private native Object[] JNI_CallProcedure(int var1, byte[] var2, Object[] var3, boolean var4);

    private static native byte[] JNI_GetGaussName(int var0);

    private native void JNI_SetGaussName(int var1, byte[] var2);
}

