/*
 * Decompiled with CFR 0.152.
 */
package com.aptech.gaussApi5_0;

import au.com.forward.utils.ReadWriteOrderedLock;
import com.aptech.gaussApi5_0.GaussException;
import com.aptech.gaussApi5_0.GaussLibrary;
import com.aptech.gaussApi5_0.GaussMatrix;
import com.aptech.gaussApi5_0.GaussMatrixInfo;
import com.aptech.gaussApi5_0.GaussStringArray;
import com.aptech.gaussApi5_0.GaussWorkspace;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;

public class Gauss {
    public static final String VERSION = "1.0.10";
    public static final String DATE = "2004/04/09";
    public static final int INVALID_SYMBOL = -1;
    public static final int SYMBOL_NOT_FOUND = 0;
    public static final int MATRIX = 6;
    public static final int PROCEDURE = 8;
    public static final int STRING = 13;
    public static final int STRING_ARRAY = 15;
    public static final int OTHER = 99;
    public static final String nl;
    static boolean DEBUG_THREADS;
    private static final byte[] TERMINATION_CHARS;
    static final String STRING_TERMINATION;
    static final int MAX_PATH_BYTES = 1024;
    static final int MAX_EXPRESSION_BYTES = 20475;
    static final int NULL_HANDLE = -1;
    private static boolean byteOrderBIG_ENDIAN;
    private static int maximumNumberOfWorkspaces;
    private static HashMap<String, GaussWorkspace> workspaces;
    private static boolean initialized;
    private static Boolean systemErrEnabled;
    private static Object workspaceHandleLock;
    private static Object initializeLock;
    private static ReadWriteOrderedLock createShutdownLock;
    private static final GaussException gaussException;
    private static final GaussMatrix gaussMatrix;
    private static final GaussMatrixInfo gaussMatrixInfo;
    private static final GaussStringArray gaussStringArray;
    private static final GaussWorkspace gaussWorkspace;

    private Gauss() {
    }

    public static boolean isByteOrderBIG_ENDIAN() {
        return byteOrderBIG_ENDIAN;
    }

    public static void setLogFileName(String string) {
        Gauss.setLogFileName(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLogFileName(String string, boolean bl) {
        Object object = initializeLock;
        synchronized (object) {
            if (initialized) {
                throw new IllegalStateException("Tried to setLogFileName after GAUSS was initialized.  Call GAUSS.shutdown() first.");
            }
            if (string != null) {
                string = Gauss.checkForEmptyString(string, "logFileName");
            }
            String string2 = bl ? "a" : "w";
            string = string + STRING_TERMINATION;
            string2 = string2 + STRING_TERMINATION;
            byte[] byArray = null;
            try {
                if (string != null && (byArray = string.getBytes()).length > 1024) {
                    throw new IllegalArgumentException("New log file name exceeds 1024 bytes.  '" + string.substring(0, 256) + "....'");
                }
                Gauss.JNI_SetLogFile(byArray, string2.getBytes());
            }
            finally {
                GaussWorkspace.flushOutput();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setHome(String string) {
        Object object = initializeLock;
        synchronized (object) {
            if (initialized) {
                throw new IllegalStateException("Tried to setHome after GAUSS was initialized.  Call GAUSS.shutdown() first.");
            }
            string = Gauss.checkForEmptyString(string, "homeDir");
            string = string + STRING_TERMINATION;
            try {
                byte[] byArray = string.getBytes();
                if (byArray.length > 1024) {
                    throw new IllegalArgumentException("New GAUSS Home dir exceeds 1024 bytes '" + string.substring(0, 256) + "....'");
                }
                Gauss.JNI_SetHome(byArray);
            }
            finally {
                GaussWorkspace.flushOutput();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setHomeVar(String string) {
        Object object = initializeLock;
        synchronized (object) {
            if (initialized) {
                throw new IllegalStateException("Tried to setHomeVar after GAUSS was initialized.  Call GAUSS.shutdown() first.");
            }
            string = Gauss.checkForEmptyString(string, "environmentalVariableName");
            string = string + STRING_TERMINATION;
            try {
                byte[] byArray = string.getBytes();
                if (byArray.length > 1024) {
                    throw new IllegalArgumentException("New GAUSS Home environmental variable exceeds 1024 bytes '" + string.substring(0, 256) + "....'");
                }
                Gauss.JNI_SetHomeVar(byArray);
            }
            finally {
                GaussWorkspace.flushOutput();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GaussWorkspace getWorkspace(String string) {
        string = Gauss.checkForEmptyString(string, "workspaceName");
        HashMap<String, GaussWorkspace> hashMap = workspaces;
        synchronized (hashMap) {
            return workspaces.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getLogFileName() {
        Object object = initializeLock;
        synchronized (object) {
            String string;
            try {
                byte[] byArray = Gauss.JNI_GetLogFile();
                if (byArray == null) {
                    String string2 = null;
                    return string2;
                }
                string = new String(byArray);
            }
            finally {
                GaussWorkspace.flushOutput();
            }
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getJNIVersion() {
        String string;
        Object object = initializeLock;
        synchronized (object) {
            try {
                byte[] byArray = Gauss.JNI_GetJNIVersion();
                string = GaussLibrary.getName() + " " + new String(byArray);
            }
            finally {
                GaussWorkspace.flushOutput();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHome() {
        String string;
        Object object = initializeLock;
        synchronized (object) {
            try {
                byte[] byArray = Gauss.JNI_GetHome();
                if (byArray == null) {
                    throw new GaussException("getHome() returned null");
                }
                string = new String(byArray);
            }
            finally {
                GaussWorkspace.flushOutput();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getHomeVar() {
        Object object = initializeLock;
        synchronized (object) {
            String string;
            try {
                byte[] byArray = Gauss.JNI_GetHomeVar();
                if (byArray == null) {
                    String string2 = "";
                    return string2;
                }
                string = new String(byArray);
            }
            finally {
                GaussWorkspace.flushOutput();
            }
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean enableSystemErrOutput(boolean bl) {
        Object object = initializeLock;
        synchronized (object) {
            boolean bl2;
            if (initialized) {
                throw new IllegalStateException("Tried to enableSystemErrOutput after GAUSS was initialized.  Call GAUSS.shutdown() first.");
            }
            try {
                Gauss.JNI_SetSystemErrOutput(bl);
                bl2 = systemErrEnabled;
                systemErrEnabled = new Boolean(bl);
            }
            finally {
                GaussWorkspace.flushOutput();
            }
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        block20: {
            if (DEBUG_THREADS) {
                System.out.println("in shutdown request ShutDown WriteLock() on thread:" + Thread.currentThread().getName());
            }
            try {
                createShutdownLock.requestWriteLock();
            }
            catch (InterruptedException interruptedException) {
                throw new GaussException("Call to shutdown() interrupted.", interruptedException, 0);
            }
            try {
                if (!initialized) break block20;
                Object object = initializeLock;
                synchronized (object) {
                    int n;
                    GaussWorkspace[] gaussWorkspaceArray;
                    block21: {
                        if (initialized) break block21;
                        return;
                    }
                    HashMap<String, GaussWorkspace> hashMap = workspaces;
                    synchronized (hashMap) {
                        gaussWorkspaceArray = workspaces.values().toArray(new GaussWorkspace[0]);
                    }
                    for (n = 0; n < gaussWorkspaceArray.length; ++n) {
                        gaussWorkspaceArray[n].shutdown();
                    }
                    for (n = 0; n < gaussWorkspaceArray.length; ++n) {
                        gaussWorkspaceArray[n].dispose();
                    }
                    HashMap<String, GaussWorkspace> hashMap2 = workspaces;
                    synchronized (hashMap2) {
                        workspaces.clear();
                    }
                    Gauss.JNI_Shutdown();
                    initialized = false;
                }
            }
            finally {
                if (DEBUG_THREADS) {
                    System.out.println("exiting shutdown release ShutDown WriteLock() on thread:" + Thread.currentThread().getName());
                }
                createShutdownLock.releaseLock();
                GaussWorkspace.flushOutput();
            }
        }
    }

    public static File translateDataLoop(File file) {
        File file2;
        try {
            file2 = File.createTempFile("jdl", null);
        }
        catch (IOException iOException) {
            throw new GaussException("Could not create temporary file.", iOException);
        }
        file2.deleteOnExit();
        return Gauss.translateDataLoop(file, file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File translateDataLoop(File file, File file2) {
        Object var2_2 = null;
        int n = 0;
        String string = file.getPath();
        String string2 = file2.getPath();
        byte[] byArray = (string = string + STRING_TERMINATION).getBytes();
        if (byArray.length > 1024) {
            throw new IllegalArgumentException("srcFileName exceeds 1024 bytes.  '" + string.substring(0, 256) + "....'");
        }
        byte[] byArray2 = (string2 = string2 + STRING_TERMINATION).getBytes();
        if (byArray2.length > 1024) {
            throw new IllegalArgumentException("srcFileName exceeds 1024 bytes.  '" + string2.substring(0, 256) + "....'");
        }
        if (DEBUG_THREADS) {
            System.out.println("in translateDataLoop request GAUSS ReadLock() on thread:" + Thread.currentThread().getName());
        }
        try {
            createShutdownLock.requestReadLock();
        }
        catch (InterruptedException interruptedException) {
            throw new GaussException(" translateDataLoop() interrupted while waiting for GAUSS Engine to shutdown()/initialize().", interruptedException, 0);
        }
        try {
            Object object;
            if (!initialized) {
                object = initializeLock;
                synchronized (object) {
                    if (!initialized) {
                        Gauss.JNI_Initialize(maximumNumberOfWorkspaces);
                        initialized = true;
                    }
                }
            }
            if ((n = Gauss.JNI_TranslateDataLoop(byArray, byArray2)) > 0) {
                throw new GaussException("translateDataLoop had " + n + " errors.");
            }
            object = file2;
            return object;
        }
        finally {
            if (DEBUG_THREADS) {
                System.out.println("exiting translateDataLoop release GAUSS ReadLock() on thread:" + Thread.currentThread().getName());
            }
            createShutdownLock.releaseLock();
            GaussWorkspace.flushOutput();
        }
    }

    static boolean initialized() {
        return initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void createWorkspace(GaussWorkspace gaussWorkspace) {
        HashMap<String, GaussWorkspace> hashMap;
        int n = -1;
        if (DEBUG_THREADS) {
            System.out.println("in createWorkspace for " + gaussWorkspace.getName() + " request GAUSS ReadLock() on thread:" + Thread.currentThread().getName());
        }
        try {
            createShutdownLock.requestReadLock();
        }
        catch (InterruptedException interruptedException) {
            throw new GaussException("createWorkspace() interrupted while waiting for GAUSS Engine to shutdown()/initialize().", interruptedException, 0);
        }
        try {
            if (!initialized) {
                hashMap = initializeLock;
                synchronized (hashMap) {
                    if (!initialized) {
                        Gauss.JNI_Initialize(maximumNumberOfWorkspaces);
                        initialized = true;
                    }
                }
            }
            hashMap = gaussWorkspace.getName();
            Object object = workspaces;
            synchronized (object) {
                if (!gaussWorkspace.hasBeenDisposed()) {
                    throw new IllegalArgumentException("GaussWorkspace '" + (String)((Object)hashMap) + "' is already active.");
                }
                if (workspaces.containsKey(gaussWorkspace.getName())) {
                    throw new IllegalArgumentException("GaussWorkspace '" + (String)((Object)hashMap) + "' already exists.");
                }
                workspaces.put(gaussWorkspace.getName(), gaussWorkspace);
            }
            hashMap = (String)((Object)hashMap) + STRING_TERMINATION;
            object = ((String)((Object)hashMap)).getBytes();
            byte[] byArray = null;
            String string = null;
            string = gaussWorkspace.getLoadFileName();
            if (string != null) {
                string = string + STRING_TERMINATION;
                byArray = string.getBytes();
            }
            if (((Object)object).length > 1024) {
                throw new IllegalArgumentException("New workspace name exceeds 1024 bytes '" + ((String)((Object)hashMap)).substring(0, 256) + "....'");
            }
            n = Gauss.getFreeWorkspaceHandle();
            if (string != null) {
                Gauss.JNI_LoadWorkspace((byte[])object, byArray, n);
            } else {
                Gauss.JNI_CreateWorkspace((byte[])object, n);
            }
            gaussWorkspace.setGaussWorkspaceHandle(n);
        }
        finally {
            if (gaussWorkspace.getGaussWorkspaceHandle() == -1) {
                hashMap = workspaces;
                synchronized (hashMap) {
                    workspaces.remove(gaussWorkspace.getName());
                }
                Gauss.releaseWorkspaceHandle(n);
            }
            if (DEBUG_THREADS) {
                System.out.println("exiting createWorkspace for " + gaussWorkspace.getName() + " release GAUSS ReadLock() on thread:" + Thread.currentThread().getName());
            }
            createShutdownLock.releaseLock();
            GaussWorkspace.flushOutput();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void disposeWorkspace(GaussWorkspace gaussWorkspace) {
        int n = -1;
        if (DEBUG_THREADS) {
            System.out.println("in disposeWorkspace for " + gaussWorkspace.getName() + " on thread:" + Thread.currentThread().getName());
        }
        try {
            if (!initialized) {
                return;
            }
            HashMap<String, GaussWorkspace> hashMap = workspaces;
            synchronized (hashMap) {
                block12: {
                    if (!gaussWorkspace.hasBeenDisposed()) break block12;
                    return;
                }
                n = gaussWorkspace.setGaussWorkspaceHandle(-1);
                workspaces.remove(gaussWorkspace.getName());
            }
            Gauss.JNI_FreeWorkspace(n);
        }
        finally {
            Gauss.releaseWorkspaceHandle(n);
            GaussWorkspace.flushOutput();
            if (DEBUG_THREADS) {
                System.out.println("exiting disposeWorkspace for " + gaussWorkspace.getName() + " on thread:" + Thread.currentThread().getName());
            }
        }
    }

    static String checkForEmptyString(String string, String string2) {
        if (string == null) {
            throw new NullPointerException(string2);
        }
        if ((string = string.trim()).length() == 0) {
            throw new IllegalArgumentException(string2 + " is an empty string");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getFreeWorkspaceHandle() throws GaussException {
        if (!initialized) {
            throw new IllegalStateException("Tried to getFreeWorkspaceHandle before GAUSS Engine initialized.");
        }
        Object object = workspaceHandleLock;
        synchronized (object) {
            return Gauss.JNI_GetFreeWorkspaceHandle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releaseWorkspaceHandle(int n) throws GaussException {
        if (n != -1) {
            Object object = initializeLock;
            synchronized (object) {
                if (!initialized) {
                    throw new IllegalStateException("Tried to releaseWorkspaceHandle before GAUSS Engine initialized.");
                }
                Object object2 = workspaceHandleLock;
                synchronized (object2) {
                    Gauss.JNI_ReleaseWorkspaceHandle(n);
                }
            }
        }
    }

    private static native boolean JNI_GetByteOrder();

    private static native void JNI_Initialize(int var0);

    private static native void JNI_Shutdown();

    private static native byte[] JNI_GetJNIVersion();

    private static native void JNI_SetSystemErrOutput(boolean var0);

    private static native void JNI_SetLogFile(byte[] var0, byte[] var1);

    private static native void JNI_SetHome(byte[] var0);

    private static native void JNI_SetHomeVar(byte[] var0);

    private static native byte[] JNI_GetLogFile();

    private static native byte[] JNI_GetHome();

    private static native byte[] JNI_GetHomeVar();

    private static native void JNI_FreeWorkspace(int var0);

    private static native void JNI_ReleaseWorkspaceHandle(int var0);

    private static native int JNI_GetFreeWorkspaceHandle();

    private static native void JNI_CreateWorkspace(byte[] var0, int var1);

    private static native void JNI_LoadWorkspace(byte[] var0, byte[] var1, int var2);

    private static native int JNI_TranslateDataLoop(byte[] var0, byte[] var1);

    private static synchronized void load() {
        if (GaussLibrary.isLoaded()) {
            return;
        }
        String string = "";
        String string2 = System.getProperty("os.name");
        string = string2.indexOf("Win") > -1 ? ".dll" : ".so";
        File file = new File("jgrte/" + GaussLibrary.getName() + string);
        System.load(file.getAbsolutePath());
        GaussLibrary.setLoaded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMaximumNumberOfWorkspaces(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("maxWorkspaces must be > 0");
        }
        Object object = initializeLock;
        synchronized (object) {
            if (initialized) {
                throw new IllegalStateException("Tried to setLogFileName after GAUSS was initialized.  Call GAUSS.shutdown() first.");
            }
        }
        maximumNumberOfWorkspaces = n;
    }

    public static int getMaximumNumberOfWorkspaces() {
        return maximumNumberOfWorkspaces;
    }

    static {
        DEBUG_THREADS = false;
        TERMINATION_CHARS = new byte[]{0};
        STRING_TERMINATION = new String(TERMINATION_CHARS);
        maximumNumberOfWorkspaces = 100;
        workspaces = new HashMap(50);
        initialized = false;
        systemErrEnabled = new Boolean(true);
        workspaceHandleLock = new Object();
        initializeLock = new Object();
        createShutdownLock = new ReadWriteOrderedLock(DEBUG_THREADS);
        gaussException = new GaussException();
        gaussMatrix = new GaussMatrix();
        gaussMatrixInfo = new GaussMatrixInfo();
        gaussStringArray = new GaussStringArray();
        gaussWorkspace = new GaussWorkspace();
        Gauss.load();
        nl = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                String string = "\r\n";
                try {
                    string = System.getProperty("line.separator");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return string;
            }
        });
        byteOrderBIG_ENDIAN = Gauss.JNI_GetByteOrder();
    }
}

