/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.tools.resultConverter;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public class ResultConverter {
    public void convert(Map<Integer, String> mapItemIDtoStringValue, String outputFile, String outputFileConverted) throws IOException {
        FileInputStream finResult = new FileInputStream(new File(outputFile));
        BufferedReader myInputResult = new BufferedReader(new InputStreamReader(finResult));
        BufferedWriter writer = new BufferedWriter(new FileWriter(outputFileConverted));
        String thisLine = null;
        boolean firstLine = true;
        while ((thisLine = myInputResult.readLine()) != null) {
            boolean noItemsLeft = false;
            if (thisLine.isEmpty()) continue;
            if (firstLine) {
                firstLine = false;
            } else {
                writer.newLine();
            }
            String[] split = thisLine.split(" ");
            for (int i = 0; i < split.length; ++i) {
                String token = split[i];
                if (token.startsWith("#") || noItemsLeft) {
                    noItemsLeft = true;
                    writer.write(token);
                } else {
                    Integer itemID = this.isInteger(token);
                    if (itemID == null) {
                        writer.write(token);
                    } else if (itemID >= 0) {
                        writer.write(mapItemIDtoStringValue.get(itemID));
                    }
                }
                if (i == split.length - 1) continue;
                writer.write(" ");
            }
        }
        myInputResult.close();
        writer.close();
    }

    public void convert(String inputDB, String outputFile, String outputFileConverted) throws IOException {
        String thisLine;
        FileInputStream fin = new FileInputStream(new File(inputDB));
        BufferedReader myInputDB = new BufferedReader(new InputStreamReader(fin));
        HashMap<Integer, String> mapItemIDtoStringValue = new HashMap<Integer, String>();
        while ((thisLine = myInputDB.readLine()) != null) {
            if (!thisLine.startsWith("@ITEM")) continue;
            thisLine = thisLine.substring(6);
            int index = thisLine.indexOf("=");
            int itemID = Integer.parseInt(thisLine.substring(0, index));
            String stringValue = thisLine.substring(index + 1);
            mapItemIDtoStringValue.put(itemID, stringValue);
        }
        myInputDB.close();
        this.convert(mapItemIDtoStringValue, outputFile, outputFileConverted);
    }

    Integer isInteger(String string) {
        Integer result = null;
        try {
            result = Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            return null;
        }
        return result;
    }
}

