/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan_with_strings;

import ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan_with_strings.Itemset;
import ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan_with_strings.PairBIDE;
import ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan_with_strings.PseudoSequenceBIDE;
import ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan_with_strings.SequentialPattern;
import ca.pfv.spmf.input.sequence_database_list_strings.Sequence;
import ca.pfv.spmf.input.sequence_database_list_strings.SequenceDatabase;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AlgoBIDEPlus_withStrings {
    private long startTime;
    private long endTime;
    private int patternCount = 0;
    private int minsuppAbsolute;
    BufferedWriter writer = null;
    private List<PseudoSequenceBIDE> initialContext = null;

    public void runAlgorithm(SequenceDatabase database, String outputPath, int minsup) throws IOException {
        this.writer = new BufferedWriter(new FileWriter(outputPath));
        this.minsuppAbsolute = minsup;
        this.patternCount = 0;
        MemoryLogger.getInstance().reset();
        this.startTime = System.currentTimeMillis();
        this.bide(database);
        this.endTime = System.currentTimeMillis();
        this.writer.close();
    }

    private void bide(SequenceDatabase database) throws IOException {
        Map<String, Set<Integer>> mapSequenceID = this.findSequencesContainingItems(database);
        this.initialContext = new ArrayList<PseudoSequenceBIDE>();
        for (Sequence sequence : database.getSequences()) {
            Sequence optimizedSequence = sequence.cloneSequenceMinusItems(mapSequenceID, this.minsuppAbsolute);
            if (optimizedSequence.size() == 0) continue;
            this.initialContext.add(new PseudoSequenceBIDE(optimizedSequence, 0, 0));
        }
        for (Map.Entry entry : mapSequenceID.entrySet()) {
            if (((Set)entry.getValue()).size() < this.minsuppAbsolute) continue;
            String item = (String)entry.getKey();
            List<PseudoSequenceBIDE> projectedContext = this.buildProjectedContext(item, this.initialContext, false);
            SequentialPattern prefix = new SequentialPattern(0);
            prefix.addItemset(new Itemset(item));
            prefix.setSequencesID((Set)entry.getValue());
            int supportSuccessors = 0;
            if (!this.checkBackScanPruning(prefix)) {
                supportSuccessors = this.recursion(prefix, projectedContext);
            }
            if (prefix.getAbsoluteSupport() == supportSuccessors || this.checkBackwardExtension(prefix)) continue;
            this.savePattern(prefix);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private boolean checkBackScanPruning(SequentialPattern prefix) {
        for (int i = 0; i < prefix.getItemOccurencesTotalCount(); ++i) {
            ArrayList<PseudoSequenceBIDE> semimaximumPeriods = new ArrayList<PseudoSequenceBIDE>();
            for (PseudoSequenceBIDE sequence : this.initialContext) {
                PseudoSequenceBIDE period;
                if (!prefix.getSequencesID().contains(sequence.getId()) || (period = sequence.getIthSemiMaximumPeriodOfAPrefix(prefix.getItemsets(), i)) == null) continue;
                semimaximumPeriods.add(period);
            }
            Set<PairBIDE> paires = this.findAllFrequentPairsForBackwardExtensionCheck(prefix, semimaximumPeriods, i);
            for (PairBIDE pair : paires) {
                if (pair.getCount() != prefix.getAbsoluteSupport()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkBackwardExtension(SequentialPattern prefix) {
        for (int i = 0; i < prefix.getItemOccurencesTotalCount(); ++i) {
            ArrayList<PseudoSequenceBIDE> maximumPeriods = new ArrayList<PseudoSequenceBIDE>();
            for (PseudoSequenceBIDE sequence : this.initialContext) {
                PseudoSequenceBIDE period;
                if (!prefix.getSequencesID().contains(sequence.getId()) || (period = sequence.getIthMaximumPeriodOfAPrefix(prefix.getItemsets(), i)) == null) continue;
                maximumPeriods.add(period);
            }
            for (PairBIDE pair : this.findAllFrequentPairsForBackwardExtensionCheck(prefix, maximumPeriods, i)) {
                if (pair.getCount() != prefix.getAbsoluteSupport()) continue;
                return true;
            }
        }
        return false;
    }

    protected Set<PairBIDE> findAllFrequentPairsForBackwardExtensionCheck(SequentialPattern prefix, List<PseudoSequenceBIDE> maximumPeriods, int iPeriod) {
        HashMap<PairBIDE, PairBIDE> mapPaires = new HashMap<PairBIDE, PairBIDE>();
        String itemI = prefix.getIthItem(iPeriod);
        String itemIm1 = null;
        if (iPeriod > 0) {
            itemIm1 = prefix.getIthItem(iPeriod - 1);
        }
        for (PseudoSequenceBIDE period : maximumPeriods) {
            for (int i = 0; i < period.size(); ++i) {
                String item;
                int j;
                boolean sawI = false;
                boolean sawIm1 = false;
                for (j = 0; j < period.getSizeOfItemsetAt(i); ++j) {
                    item = period.getItemAtInItemsetAt(j, i);
                    if (item.equals(itemI)) {
                        sawI = true;
                        continue;
                    }
                    if (item.compareTo(itemI) > 0) break;
                }
                for (j = 0; j < period.getSizeOfItemsetAt(i); ++j) {
                    PairBIDE paire2;
                    item = period.getItemAtInItemsetAt(j, i);
                    if (itemIm1 != null && item.equals(itemIm1)) {
                        sawIm1 = true;
                    }
                    boolean isPrefix = period.isCutAtRight(i);
                    boolean isPostfix = period.isPostfix(i);
                    PairBIDE paire = new PairBIDE(isPrefix, isPostfix, item);
                    this.addPaire(mapPaires, period.getId(), paire);
                    if (sawIm1) {
                        paire2 = new PairBIDE(isPrefix, !isPostfix, item);
                        this.addPaire(mapPaires, period.getId(), paire2);
                    }
                    if (!sawI) continue;
                    paire2 = new PairBIDE(!isPrefix, isPostfix, item);
                    this.addPaire(mapPaires, period.getId(), paire2);
                }
            }
        }
        return mapPaires.keySet();
    }

    private void addPaire(Map<PairBIDE, PairBIDE> mapPaires, Integer seqID, PairBIDE paire) {
        PairBIDE oldPaire = mapPaires.get(paire);
        if (oldPaire == null) {
            mapPaires.put(paire, paire);
        } else {
            paire = oldPaire;
        }
        paire.getSequencesID().add(seqID);
    }

    private Map<String, Set<Integer>> findSequencesContainingItems(SequenceDatabase contexte) {
        HashMap<String, Set<Integer>> mapSequenceID = new HashMap<String, Set<Integer>>();
        for (Sequence sequence : contexte.getSequences()) {
            for (List<String> itemset : sequence.getItemsets()) {
                for (String item : itemset) {
                    HashSet<Integer> sequenceIDs = (HashSet<Integer>)mapSequenceID.get(item);
                    if (sequenceIDs == null) {
                        sequenceIDs = new HashSet<Integer>();
                        mapSequenceID.put(item, sequenceIDs);
                    }
                    sequenceIDs.add(sequence.getId());
                }
            }
        }
        return mapSequenceID;
    }

    private List<PseudoSequenceBIDE> buildProjectedContext(String item, List<PseudoSequenceBIDE> database, boolean inSuffix) {
        ArrayList<PseudoSequenceBIDE> sequenceDatabase = new ArrayList<PseudoSequenceBIDE>();
        for (PseudoSequenceBIDE sequence : database) {
            for (int i = 0; i < sequence.size(); ++i) {
                PseudoSequenceBIDE newSequence;
                int index = sequence.indexOf(i, item);
                if (index == -1 || sequence.isPostfix(i) != inSuffix) continue;
                if (index != sequence.getSizeOfItemsetAt(i) - 1) {
                    newSequence = new PseudoSequenceBIDE(sequence, i, index + 1);
                    if (newSequence.size() <= 0) continue;
                    sequenceDatabase.add(newSequence);
                    continue;
                }
                if (i == sequence.size() - 1 || (newSequence = new PseudoSequenceBIDE(sequence, i + 1, 0)).size() <= 0) continue;
                sequenceDatabase.add(newSequence);
            }
        }
        return sequenceDatabase;
    }

    private int recursion(SequentialPattern prefix, List<PseudoSequenceBIDE> contexte) throws IOException {
        Set<PairBIDE> pairs = this.findAllFrequentPairs(prefix, contexte);
        int maxSupport = 0;
        for (PairBIDE paire : pairs) {
            boolean noForwardSIExtension;
            if (paire.getCount() < this.minsuppAbsolute) continue;
            SequentialPattern newPrefix = paire.isPostfix() ? this.appendItemToPrefixOfSequence(prefix, paire.getItem()) : this.appendItemToSequence(prefix, paire.getItem());
            List<PseudoSequenceBIDE> projectedContext = this.buildProjectedContext(paire.getItem(), contexte, paire.isPostfix());
            newPrefix.setSequencesID(paire.getSequencesID());
            int maxSupportOfSuccessors = 0;
            if (!this.checkBackScanPruning(newPrefix)) {
                maxSupportOfSuccessors = this.recursion(newPrefix, projectedContext);
            }
            boolean bl = noForwardSIExtension = newPrefix.getAbsoluteSupport() != maxSupportOfSuccessors;
            if (noForwardSIExtension && !this.checkBackwardExtension(newPrefix)) {
                this.savePattern(newPrefix);
            }
            if (newPrefix.getAbsoluteSupport() <= maxSupport) continue;
            maxSupport = newPrefix.getAbsoluteSupport();
        }
        return maxSupport;
    }

    protected Set<PairBIDE> findAllFrequentPairs(SequentialPattern prefix, List<PseudoSequenceBIDE> sequences) {
        HashMap<PairBIDE, PairBIDE> mapPairs = new HashMap<PairBIDE, PairBIDE>();
        for (PseudoSequenceBIDE sequence : sequences) {
            for (int i = 0; i < sequence.size(); ++i) {
                for (int j = 0; j < sequence.getSizeOfItemsetAt(i); ++j) {
                    String item = sequence.getItemAtInItemsetAt(j, i);
                    PairBIDE paire = new PairBIDE(sequence.isCutAtRight(i), sequence.isPostfix(i), item);
                    this.addPaire(mapPairs, sequence.getId(), paire);
                }
            }
        }
        MemoryLogger.getInstance().checkMemory();
        return mapPairs.keySet();
    }

    private SequentialPattern appendItemToSequence(SequentialPattern prefix, String item) {
        SequentialPattern newPrefix = prefix.cloneSequence();
        newPrefix.addItemset(new Itemset(item));
        return newPrefix;
    }

    private SequentialPattern appendItemToPrefixOfSequence(SequentialPattern prefix, String item) {
        SequentialPattern newPrefix = prefix.cloneSequence();
        Itemset itemset = newPrefix.get(newPrefix.size() - 1);
        itemset.addItem(item);
        return newPrefix;
    }

    private void savePattern(SequentialPattern prefix) throws IOException {
        ++this.patternCount;
        StringBuffer r = new StringBuffer("");
        for (Itemset itemset : prefix.getItemsets()) {
            for (String item : itemset.getItems()) {
                r.append(item);
                r.append(' ');
            }
            r.append("-1 ");
        }
        r.append(" #SUP: ");
        r.append(prefix.getSequencesID().size());
        this.writer.write(r.toString());
        this.writer.newLine();
    }

    public void printStatistics(int size) {
        StringBuffer r = new StringBuffer(200);
        r.append("=============  Algorithm - STATISTICS =============\n Total time ~ ");
        r.append(this.endTime - this.startTime);
        r.append(" ms\n");
        r.append(" Closed sequential patterns count : ");
        r.append(this.patternCount);
        r.append('\n');
        r.append(" Max memory (mb):");
        r.append(MemoryLogger.getInstance().getMaxMemory());
        r.append('\n');
        r.append("===================================================\n");
        System.out.println(r.toString());
    }
}

