/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequential_rules.cmrules;

import ca.pfv.spmf.algorithms.sequential_rules.cmrules.Rule;
import java.util.ArrayList;
import java.util.List;

public class Rules {
    final List<Rule> rules = new ArrayList<Rule>();
    private final String name;

    public Rules(String name) {
        this.name = name;
    }

    public void printRules(int objectsCount) {
        System.out.println(" ------- " + this.name + " -------");
        int i = 0;
        for (Rule rule : this.rules) {
            System.out.print("  rule " + i + ":  ");
            rule.print();
            System.out.print(" seqSupp: " + rule.getSequentialSupport(objectsCount) + " (" + rule.getSequentialAbsoluteSeqSupport() + "/" + objectsCount + ") ");
            System.out.print(" seqConf: " + rule.getSequentialConfidence() + " (" + rule.getAbsoluteSupport() + "/" + rule.getItemset1().getAbsoluteSupport() + ") ");
            System.out.println("");
            ++i;
        }
        System.out.println(" --------------------------------");
    }

    public String toString(int objectsCount) {
        StringBuffer buffer = new StringBuffer(" ------- " + this.name + " -------\n");
        int i = 0;
        for (Rule rule : this.rules) {
            buffer.append("  rule ");
            buffer.append(i);
            buffer.append(":  ");
            buffer.append(rule.toString());
            buffer.append("  seqSupp: ");
            buffer.append(rule.getSequentialSupport(objectsCount));
            buffer.append(" (");
            buffer.append(rule.getSequentialAbsoluteSeqSupport());
            buffer.append("/");
            buffer.append(objectsCount);
            buffer.append("  seqConf: ");
            buffer.append(rule.getSequentialConfidence());
            buffer.append(" (");
            buffer.append(rule.getAbsoluteSupport());
            buffer.append("/");
            buffer.append(rule.getItemset1().getAbsoluteSupport());
            buffer.append("\n");
            ++i;
        }
        buffer.append("--------------------------------\n");
        return buffer.toString();
    }

    void addRule(Rule rule) {
        this.rules.add(rule);
    }

    public int getRulesCount() {
        return this.rules.size();
    }

    public List<Rule> getRules() {
        return this.rules;
    }
}

