/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.lcm;

import ca.pfv.spmf.algorithms.frequentpatterns.lcm.Dataset;
import ca.pfv.spmf.algorithms.frequentpatterns.lcm.Transaction;
import ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemset;
import ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemsets;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AlgoLCM {
    private Itemsets closedFrequentItemsets;
    BufferedWriter writer = null;
    private int frequentCount;
    long startTimestamp;
    long endTimestamp;
    int minsupRelative;
    boolean mineAllFrequentItemsets;
    private boolean mineAllMaximalItemsets;
    private List<Transaction>[] buckets;

    public Itemsets runAlgorithm(double minimumSupport, Dataset dataset, String outputPath, boolean mineAllFrequentItemsets, boolean mineAllMaximalItemsets) throws IOException {
        this.startTimestamp = System.currentTimeMillis();
        this.mineAllFrequentItemsets = mineAllFrequentItemsets;
        this.mineAllMaximalItemsets = mineAllMaximalItemsets;
        if (outputPath != null) {
            this.writer = new BufferedWriter(new FileWriter(outputPath));
        } else {
            this.writer = null;
            this.closedFrequentItemsets = new Itemsets("Itemsets");
        }
        this.frequentCount = 0;
        MemoryLogger.getInstance().reset();
        this.minsupRelative = (int)Math.ceil(minimumSupport * (double)dataset.getTransactions().size());
        this.performFirstOccurenceDelivery(dataset);
        for (Transaction transaction : dataset.getTransactions()) {
            transaction.removeInfrequentItems(this.buckets, this.minsupRelative);
        }
        ArrayList<Integer> allItems = new ArrayList<Integer>();
        for (Integer item : dataset.getUniqueItems()) {
            if (this.buckets[item].size() < this.minsupRelative) continue;
            allItems.add(item);
        }
        Collections.sort(allItems);
        if (mineAllFrequentItemsets) {
            this.backtrackingLCMFreq(null, dataset.getTransactions(), allItems);
        } else if (mineAllMaximalItemsets) {
            this.backtrackingLCMMax(null, dataset.getTransactions(), allItems, -1, -1);
        } else {
            this.backtrackingLCM(null, dataset.getTransactions(), allItems, -1);
        }
        this.endTimestamp = System.currentTimeMillis();
        if (this.writer != null) {
            this.writer.close();
        }
        MemoryLogger.getInstance().checkMemory();
        return this.closedFrequentItemsets;
    }

    private void backtrackingLCM(List<Integer> p, List<Transaction> transactionsOfP, List<Integer> frequentItems, int tailPosInP) throws IOException {
        for (int j = 0; j < frequentItems.size(); ++j) {
            List<Transaction> transactionsPe;
            Integer e = frequentItems.get(j);
            if (p != null && this.containsByBinarySearch(p, e, tailPosInP) || !this.isPPCExtension(p, transactionsPe = this.intersectTransactions(transactionsOfP, e), e)) continue;
            ArrayList<Integer> itemset = new ArrayList<Integer>();
            if (p != null) {
                for (int m = 0; m < p.size() && p.get(m) < e; ++m) {
                    itemset.add(p.get(m));
                }
            }
            itemset.add(e);
            int tailPositionInPe = itemset.size() - 1;
            for (int k = j + 1; k < frequentItems.size(); ++k) {
                Integer itemk = frequentItems.get(k);
                if (!this.isItemInAllTransactions(transactionsPe, itemk)) continue;
                itemset.add(itemk);
            }
            int supportPe = transactionsPe.size();
            this.output(itemset, supportPe);
            this.anyTimeDatabaseReduction(transactionsPe, j, frequentItems, p, e);
            ArrayList<Integer> newFrequentItems = new ArrayList<Integer>();
            for (int k = j + 1; k < frequentItems.size(); ++k) {
                Integer itemK = frequentItems.get(k);
                int supportK = this.buckets[itemK].size();
                if (supportK < this.minsupRelative) continue;
                newFrequentItems.add(itemK);
            }
            this.backtrackingLCM(itemset, transactionsPe, newFrequentItems, tailPositionInPe);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private boolean backtrackingLCMMax(List<Integer> p, List<Transaction> transactionsOfP, List<Integer> frequentItems, int tailPosInP, Integer itemELastAddedToP) throws IOException {
        throw new RuntimeException("This algorithm is unavailable in the current version of SPMF. \n");
    }

    private void backtrackingLCMFreq(List<Integer> p, List<Transaction> transactionsOfP, List<Integer> frequentItems) throws IOException {
        for (int j = 0; j < frequentItems.size(); ++j) {
            Integer e = frequentItems.get(j);
            if (p != null && this.containsByBinarySearch(p, e)) continue;
            List<Transaction> transactionsPe = this.intersectTransactions(transactionsOfP, e);
            ArrayList<Integer> itemset = new ArrayList<Integer>();
            if (p != null) {
                for (int m = 0; m < p.size() && p.get(m) < e; ++m) {
                    itemset.add(p.get(m));
                }
            }
            itemset.add(e);
            int tailPositionInPe = itemset.size() - 1;
            int supportPe = transactionsPe.size();
            this.output(itemset, supportPe);
            this.anyTimeDatabaseReduction(transactionsPe, j, frequentItems, p, e);
            ArrayList<Integer> newFrequentItems = new ArrayList<Integer>();
            for (int k = j + 1; k < frequentItems.size(); ++k) {
                Integer itemK = frequentItems.get(k);
                int supportK = this.buckets[itemK].size();
                if (supportK < this.minsupRelative) continue;
                newFrequentItems.add(itemK);
            }
            this.backtrackingLCMFreq(itemset, transactionsPe, newFrequentItems);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    public void performFirstOccurenceDelivery(Dataset dataset) {
        this.buckets = new List[dataset.getMaxItem() + 1];
        for (Integer item : dataset.uniqueItems) {
            this.buckets[item.intValue()] = new ArrayList<Transaction>();
        }
        for (Transaction transaction : dataset.getTransactions()) {
            for (Integer item : transaction.getItems()) {
                this.buckets[item].add(transaction);
            }
        }
    }

    private void anyTimeDatabaseReduction(List<Transaction> transactionsPe, int j, List<Integer> frequentItems, List<Integer> itemset, Integer e) {
        for (int i = j + 1; i < frequentItems.size(); ++i) {
            Integer item = frequentItems.get(i);
            this.buckets[item.intValue()] = new ArrayList<Transaction>();
        }
        for (Transaction transaction : transactionsPe) {
            for (int i = transaction.getItems().length - 1; i > transaction.offset; --i) {
                Integer item = transaction.getItems()[i];
                if (item <= e || !frequentItems.contains(item)) continue;
                this.buckets[item].add(transaction);
            }
        }
    }

    private void anyTimeDatabaseReductionMax(List<Transaction> transactionsPe, int j, List<Integer> frequentItems, List<Integer> itemset, Integer e) {
        for (int i = 0; i < frequentItems.size(); ++i) {
            Integer item = frequentItems.get(i);
            this.buckets[item.intValue()] = new ArrayList<Transaction>();
        }
        for (Transaction transaction : transactionsPe) {
            for (int i = transaction.getItems().length - 1; i >= 0; --i) {
                Integer item = transaction.getItems()[i];
                if (!frequentItems.contains(item)) continue;
                this.buckets[item].add(transaction);
            }
        }
    }

    public boolean containsByBinarySearch(List<Integer> items, Integer item, int searchAfterPosition) {
        if (items.size() == 0 || item > items.get(items.size() - 1)) {
            return false;
        }
        int low = searchAfterPosition + 1;
        int high = items.size() - 1;
        while (high >= low) {
            int middle = low + high >>> 1;
            if (items.get(middle).equals(item)) {
                return true;
            }
            if (items.get(middle) < item) {
                low = middle + 1;
            }
            if (items.get(middle) <= item) continue;
            high = middle - 1;
        }
        return false;
    }

    public boolean containsByBinarySearch(List<Integer> items, Integer item) {
        if (items.size() == 0 || item > items.get(items.size() - 1)) {
            return false;
        }
        int low = 0;
        int high = items.size() - 1;
        while (high >= low) {
            int middle = low + high >>> 1;
            if (items.get(middle).equals(item)) {
                return true;
            }
            if (items.get(middle) < item) {
                low = middle + 1;
            }
            if (items.get(middle) <= item) continue;
            high = middle - 1;
        }
        return false;
    }

    public List<Transaction> intersectTransactions(List<Transaction> transactionsOfP, Integer e) {
        ArrayList<Transaction> transactionsPe = new ArrayList<Transaction>();
        for (Transaction transaction : transactionsOfP) {
            int posE = transaction.containsByBinarySearch(e);
            if (posE == -1) continue;
            transactionsPe.add(new Transaction(transaction, posE));
        }
        return transactionsPe;
    }

    private boolean isPPCExtension(List<Integer> p, List<Transaction> transactionsPe, Integer e) {
        Transaction firstTrans = transactionsPe.get(0);
        Integer[] firstTransaction = firstTrans.getItems();
        for (int i = 0; i < firstTrans.offset; ++i) {
            Integer item = firstTransaction[i];
            if (item >= e || p != null && this.containsByBinarySearch(p, item) || !this.isItemInAllTransactionsExceptFirst(transactionsPe, item)) continue;
            return false;
        }
        return true;
    }

    private boolean isPPCMaxExtension(List<Integer> p, Integer e, List<Transaction> transactionsPe) {
        Integer item;
        Transaction firstTrans = transactionsPe.get(0);
        Integer[] firstTransaction = firstTrans.getItems();
        for (int i = 0; i < firstTransaction.length && (item = firstTransaction[i]) < e; ++i) {
            if (p != null && this.containsByBinarySearch(p, item) || !this.isItemInAtLeastMinsupTransactionsWithoutFirst(transactionsPe, item)) continue;
            return false;
        }
        return true;
    }

    private boolean isItemInAtLeastMinsupTransactionsWithoutFirst(List<Transaction> transactions, Integer item) {
        int supCount = 1;
        for (int i = 1; i < transactions.size(); ++i) {
            if (!transactions.get(i).containsByBinarySearchOriginalTransaction(item) || ++supCount != this.minsupRelative) continue;
            return true;
        }
        return false;
    }

    private boolean isItemInAtLeastMinsupTransactions(List<Transaction> transactions, Integer item) {
        int supCount = 0;
        for (Transaction transaction : transactions) {
            if (transaction.containsByBinarySearch(item) == -1 || ++supCount != this.minsupRelative) continue;
            return true;
        }
        return false;
    }

    private boolean isItemInAllTransactionsExceptFirst(List<Transaction> transactions, Integer item) {
        for (int i = 1; i < transactions.size(); ++i) {
            if (transactions.get(i).containsByBinarySearchOriginalTransaction(item)) continue;
            return false;
        }
        return true;
    }

    private boolean isItemInAllTransactions(List<Transaction> transactions, Integer item) {
        for (Transaction transaction : transactions) {
            if (transaction.containsByBinarySearch(item) != -1) continue;
            return false;
        }
        return true;
    }

    private void output(List<Integer> itemset, int support) throws IOException {
        if (!itemset.isEmpty()) {
            ++this.frequentCount;
            if (this.writer == null) {
                this.closedFrequentItemsets.addItemset(new Itemset(itemset, support), itemset.size());
            } else {
                StringBuffer buffer = new StringBuffer();
                for (int i = 0; i < itemset.size(); ++i) {
                    buffer.append(itemset.get(i));
                    if (i == itemset.size() - 1) continue;
                    buffer.append(' ');
                }
                buffer.append(" #SUP: ");
                buffer.append(support);
                this.writer.write(buffer.toString());
                this.writer.newLine();
            }
        }
    }

    public void printStats() {
        if (this.mineAllFrequentItemsets) {
            System.out.println("========== LCMFreq - STATS ============");
            System.out.println(" Freq. itemsets count: " + this.frequentCount);
        } else if (this.mineAllMaximalItemsets) {
            System.out.println("========== LCMMax - STATS ============");
            System.out.println(" Freq. maximal itemsets count: " + this.frequentCount);
        } else {
            System.out.println("========== LCM - STATS ============");
            System.out.println(" Freq. closed itemsets count: " + this.frequentCount);
        }
        System.out.println(" Total time ~: " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Max memory:" + MemoryLogger.getInstance().getMaxMemory());
        System.out.println("=====================================");
    }
}

