/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.hui_miner;

import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.Element;
import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.UtilityList;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoFHM {
    public double maxMemory = 0.0;
    public long startTimestamp = 0L;
    public long endTimestamp = 0L;
    public int huiCount = 0;
    public int candidateCount = 0;
    Map<Integer, Integer> mapItemToTWU;
    BufferedWriter writer = null;
    Map<Integer, Map<Integer, Integer>> mapFMAP;
    boolean debug = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAlgorithm(String input, String output, int minUtility) throws IOException {
        String thisLine;
        this.maxMemory = 0.0;
        this.mapFMAP = new HashMap<Integer, Map<Integer, Integer>>();
        this.startTimestamp = System.currentTimeMillis();
        this.writer = new BufferedWriter(new FileWriter(output));
        this.mapItemToTWU = new HashMap<Integer, Integer>();
        try (BufferedReader myInput = null;){
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                String[] split = thisLine.split(":");
                String[] items = split[0].split(" ");
                int transactionUtility = Integer.parseInt(split[1]);
                for (int i = 0; i < items.length; ++i) {
                    Integer item = Integer.parseInt(items[i]);
                    Integer twu = this.mapItemToTWU.get(item);
                    twu = twu == null ? transactionUtility : twu + transactionUtility;
                    this.mapItemToTWU.put(item, twu);
                }
            }
        }
        ArrayList<UtilityList> listOfUtilityLists = new ArrayList<UtilityList>();
        HashMap<Integer, UtilityList> mapItemToUtilityList = new HashMap<Integer, UtilityList>();
        for (Integer item : this.mapItemToTWU.keySet()) {
            if (this.mapItemToTWU.get(item) < minUtility) continue;
            UtilityList uList = new UtilityList(item);
            mapItemToUtilityList.put(item, uList);
            listOfUtilityLists.add(uList);
        }
        Collections.sort(listOfUtilityLists, new Comparator<UtilityList>(){

            @Override
            public int compare(UtilityList o1, UtilityList o2) {
                return AlgoFHM.this.compareItems(o1.item, o2.item);
            }
        });
        try {
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            int tid = 0;
            while ((thisLine = myInput.readLine()) != null) {
                Pair pair;
                int i;
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                String[] split = thisLine.split(":");
                String[] items = split[0].split(" ");
                String[] utilityValues = split[2].split(" ");
                int remainingUtility = 0;
                int newTWU = 0;
                ArrayList<Pair> revisedTransaction = new ArrayList<Pair>();
                for (i = 0; i < items.length; ++i) {
                    pair = new Pair();
                    pair.item = Integer.parseInt(items[i]);
                    pair.utility = Integer.parseInt(utilityValues[i]);
                    if (this.mapItemToTWU.get(pair.item) < minUtility) continue;
                    revisedTransaction.add(pair);
                    remainingUtility += pair.utility;
                    newTWU += pair.utility;
                }
                Collections.sort(revisedTransaction, new Comparator<Pair>(){

                    @Override
                    public int compare(Pair o1, Pair o2) {
                        return AlgoFHM.this.compareItems(o1.item, o2.item);
                    }
                });
                for (i = 0; i < revisedTransaction.size(); ++i) {
                    pair = (Pair)revisedTransaction.get(i);
                    int remain = remainingUtility;
                    UtilityList utilityListOfItem = (UtilityList)mapItemToUtilityList.get(pair.item);
                    Element element = new Element(tid, pair.utility, remainingUtility -= pair.utility);
                    utilityListOfItem.addElement(element);
                    Map<Integer, Integer> mapFMAPItem = this.mapFMAP.get(pair.item);
                    if (mapFMAPItem == null) {
                        mapFMAPItem = new HashMap<Integer, Integer>();
                        this.mapFMAP.put(pair.item, mapFMAPItem);
                    }
                    for (int j = i + 1; j < revisedTransaction.size(); ++j) {
                        Pair pairAfter = (Pair)revisedTransaction.get(j);
                        Integer twuSum = mapFMAPItem.get(pairAfter.item);
                        if (twuSum == null) {
                            mapFMAPItem.put(pairAfter.item, newTWU);
                            continue;
                        }
                        mapFMAPItem.put(pairAfter.item, twuSum + newTWU);
                    }
                }
                ++tid;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (myInput != null) {
                myInput.close();
            }
        }
        this.checkMemory();
        this.fhm(new int[0], null, listOfUtilityLists, minUtility);
        this.checkMemory();
        this.writer.close();
        this.endTimestamp = System.currentTimeMillis();
    }

    private int compareItems(int item1, int item2) {
        int compare = this.mapItemToTWU.get(item1) - this.mapItemToTWU.get(item2);
        return compare == 0 ? item1 - item2 : compare;
    }

    private void fhm(int[] prefix, UtilityList pUL, List<UtilityList> ULs, int minUtility) throws IOException {
        for (int i = 0; i < ULs.size(); ++i) {
            UtilityList X = ULs.get(i);
            if (X.sumIutils >= minUtility) {
                this.writeOut(prefix, X.item, X.sumIutils);
            }
            if (X.sumIutils + X.sumRutils < minUtility) continue;
            ArrayList<UtilityList> exULs = new ArrayList<UtilityList>();
            for (int j = i + 1; j < ULs.size(); ++j) {
                Integer twuF;
                UtilityList Y = ULs.get(j);
                Map<Integer, Integer> mapTWUF = this.mapFMAP.get(X.item);
                if (mapTWUF != null && (twuF = mapTWUF.get(Y.item)) != null && twuF < minUtility) continue;
                ++this.candidateCount;
                UtilityList temp = this.construct(pUL, X, Y);
                exULs.add(temp);
            }
            int[] newPrefix = new int[prefix.length + 1];
            System.arraycopy(prefix, 0, newPrefix, 0, prefix.length);
            newPrefix[prefix.length] = X.item;
            this.fhm(newPrefix, X, exULs, minUtility);
        }
    }

    private UtilityList construct(UtilityList P, UtilityList px, UtilityList py) {
        UtilityList pxyUL = new UtilityList(py.item);
        for (Element ex : px.elements) {
            Element ey = this.findElementWithTID(py, ex.tid);
            if (ey == null) continue;
            if (P == null) {
                Element eXY = new Element(ex.tid, ex.iutils + ey.iutils, ey.rutils);
                pxyUL.addElement(eXY);
                continue;
            }
            Element e = this.findElementWithTID(P, ex.tid);
            if (e == null) continue;
            Element eXY = new Element(ex.tid, ex.iutils + ey.iutils - e.iutils, ey.rutils);
            pxyUL.addElement(eXY);
        }
        return pxyUL;
    }

    private Element findElementWithTID(UtilityList ulist, int tid) {
        List<Element> list = ulist.elements;
        int first = 0;
        int last = list.size() - 1;
        while (first <= last) {
            int middle = first + last >>> 1;
            if (list.get((int)middle).tid < tid) {
                first = middle + 1;
                continue;
            }
            if (list.get((int)middle).tid > tid) {
                last = middle - 1;
                continue;
            }
            return list.get(middle);
        }
        return null;
    }

    private void writeOut(int[] prefix, int item, int utility) throws IOException {
        ++this.huiCount;
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < prefix.length; ++i) {
            buffer.append(prefix[i]);
            buffer.append(' ');
        }
        buffer.append(item);
        buffer.append("#UTIL: ");
        buffer.append(utility);
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    private void checkMemory() {
        double currentMemory = (double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024.0 / 1024.0;
        if (currentMemory > this.maxMemory) {
            this.maxMemory = currentMemory;
        }
    }

    public void printStats() throws IOException {
        System.out.println("=============  FHM ALGORITHM - STATS =============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Memory ~ " + this.maxMemory + " MB");
        System.out.println(" High-utility itemsets count : " + this.huiCount);
        System.out.println(" Candidate count : " + this.candidateCount);
        if (this.debug) {
            int pairCount = 0;
            double maxMemory = this.getObjectSize(this.mapFMAP);
            for (Map.Entry<Integer, Map<Integer, Integer>> entry : this.mapFMAP.entrySet()) {
                maxMemory += this.getObjectSize(entry.getKey());
                for (Map.Entry<Integer, Integer> entry2 : entry.getValue().entrySet()) {
                    ++pairCount;
                    maxMemory += this.getObjectSize(entry2.getKey()) + this.getObjectSize(entry2.getValue());
                }
            }
            System.out.println("CMAP size " + maxMemory + " MB");
            System.out.println("PAIR COUNT " + pairCount);
        }
        System.out.println("===================================================");
    }

    private double getObjectSize(Object object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(object);
        oos.close();
        double maxMemory = (double)baos.size() / 1024.0 / 1024.0;
        return maxMemory;
    }

    class Pair {
        int item = 0;
        int utility = 0;

        Pair() {
        }

        public String toString() {
            return "[" + this.item + "," + this.utility + "]";
        }
    }
}

