/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.hmine;

import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoHMine {
    private int minsup;
    BufferedWriter writer = null;
    private int frequentCount;
    long startTimestamp;
    long endTimestamp;
    List<List<Integer>> database;

    public void runAlgorithm(String input, String output, int minsup) throws IOException {
        String line2;
        String line;
        this.startTimestamp = System.currentTimeMillis();
        this.writer = new BufferedWriter(new FileWriter(output));
        this.frequentCount = 0;
        MemoryLogger.getInstance().reset();
        this.minsup = minsup;
        HashMap<Integer, Integer> mapItemCount = new HashMap<Integer, Integer>();
        BufferedReader reader = new BufferedReader(new FileReader(input));
        while ((line = reader.readLine()) != null) {
            String[] lineSplited;
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            for (String itemString : lineSplited = line.split(" ")) {
                Integer item = Integer.parseInt(itemString);
                Integer count = (Integer)mapItemCount.get(item);
                if (count == null) {
                    mapItemCount.put(item, 1);
                    continue;
                }
                count = count + 1;
                mapItemCount.put(item, count);
            }
        }
        reader.close();
        this.database = new ArrayList<List<Integer>>();
        HashMap<Integer, ArrayList<Integer>> mapItemTidset = new HashMap<Integer, ArrayList<Integer>>();
        BufferedReader reader2 = new BufferedReader(new FileReader(input));
        int tid = 0;
        while ((line2 = reader2.readLine()) != null) {
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            String[] lineSplited = line2.split(" ");
            ArrayList<Integer> transaction = new ArrayList<Integer>();
            for (String itemString : lineSplited) {
                Integer item = Integer.parseInt(itemString);
                if ((Integer)mapItemCount.get(item) < minsup) continue;
                transaction.add(item);
                ArrayList<Integer> tidset = (ArrayList<Integer>)mapItemTidset.get(item);
                if (tidset == null) {
                    tidset = new ArrayList<Integer>();
                    mapItemTidset.put(item, tidset);
                }
                tidset.add(tid);
            }
            this.database.add(transaction);
            ++tid;
        }
        reader2.close();
        for (Map.Entry entry : mapItemTidset.entrySet()) {
            int[] prefix = new int[]{(Integer)entry.getKey()};
            this.writeOut(prefix, ((List)entry.getValue()).size());
            this.hmine(prefix, (Integer)entry.getKey(), (List)entry.getValue());
        }
        this.endTimestamp = System.currentTimeMillis();
        this.writer.close();
    }

    private void hmine(int[] prefix, Integer itemProjection, List<Integer> links) throws IOException {
        HashMap<Integer, ArrayList<Integer>> mapItemTidset = new HashMap<Integer, ArrayList<Integer>>();
        for (Integer n : links) {
            boolean seen = false;
            for (Integer item : this.database.get(n)) {
                if (seen) {
                    ArrayList<Integer> tidset = (ArrayList<Integer>)mapItemTidset.get(item);
                    if (tidset == null) {
                        tidset = new ArrayList<Integer>();
                        mapItemTidset.put(item, tidset);
                    }
                    tidset.add(n);
                }
                if (!itemProjection.equals(item)) continue;
                seen = true;
            }
        }
        for (Map.Entry entry : mapItemTidset.entrySet()) {
            if (((List)entry.getValue()).size() < this.minsup) continue;
            int[] newPrefix = new int[prefix.length + 1];
            System.arraycopy(prefix, 0, newPrefix, 0, prefix.length);
            newPrefix[prefix.length] = (Integer)entry.getKey();
            this.writeOut(newPrefix, ((List)entry.getValue()).size());
            this.hmine(newPrefix, (Integer)entry.getKey(), (List)entry.getValue());
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private void writeOut(int[] itemset, int support) throws IOException {
        ++this.frequentCount;
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < itemset.length; ++i) {
            buffer.append(itemset[i]);
            if (i == itemset.length - 1) continue;
            buffer.append(' ');
        }
        buffer.append(" #SUP: ");
        buffer.append(support);
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    public void printStatistics() {
        System.out.println("========== HMINE - STATS ============");
        System.out.println(" Number of frequent  itemsets: " + this.frequentCount);
        System.out.println(" Total time ~: " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Max memory:" + MemoryLogger.getInstance().getMaxMemory());
        System.out.println("=====================================");
    }
}

