/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.fpgrowth;

import ca.pfv.spmf.algorithms.frequentpatterns.fpgrowth.FPNode;
import ca.pfv.spmf.algorithms.frequentpatterns.fpgrowth.FPTree;
import ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemset;
import ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemsets;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoFPGrowth {
    private long startTimestamp;
    private long endTime;
    private int transactionCount = 0;
    private int itemsetCount;
    public int relativeMinsupp;
    BufferedWriter writer = null;
    protected Itemsets patterns = null;
    private MemoryLogger memoryLogger = null;

    public Itemsets runAlgorithm(String input, String output, double minsupp) throws FileNotFoundException, IOException {
        String line;
        this.startTimestamp = System.currentTimeMillis();
        this.itemsetCount = 0;
        this.memoryLogger = new MemoryLogger();
        this.memoryLogger.checkMemory();
        if (output == null) {
            this.writer = null;
            this.patterns = new Itemsets("FREQUENT ITEMSETS");
        } else {
            this.patterns = null;
            this.writer = new BufferedWriter(new FileWriter(output));
        }
        final HashMap<Integer, Integer> mapSupport = new HashMap<Integer, Integer>();
        this.scanDatabaseToDetermineFrequencyOfSingleItems(input, mapSupport);
        this.relativeMinsupp = (int)Math.ceil(minsupp * (double)this.transactionCount);
        FPTree tree = new FPTree();
        BufferedReader reader = new BufferedReader(new FileReader(input));
        while ((line = reader.readLine()) != null) {
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            String[] lineSplited = line.split(" ");
            ArrayList<Integer> transaction = new ArrayList<Integer>();
            for (String itemString : lineSplited) {
                Integer item = Integer.parseInt(itemString);
                if ((Integer)mapSupport.get(item) < this.relativeMinsupp) continue;
                transaction.add(item);
            }
            Collections.sort(transaction, new Comparator<Integer>(){

                @Override
                public int compare(Integer item1, Integer item2) {
                    int compare = (Integer)mapSupport.get(item2) - (Integer)mapSupport.get(item1);
                    if (compare == 0) {
                        return item1 - item2;
                    }
                    return compare;
                }
            });
            tree.addTransaction(transaction);
        }
        reader.close();
        tree.createHeaderList(mapSupport);
        int[] prefixAlpha = new int[]{};
        if (tree.headerList.size() > 0) {
            this.fpgrowth(tree, prefixAlpha, this.transactionCount, mapSupport);
        }
        if (this.writer != null) {
            this.writer.close();
        }
        this.endTime = System.currentTimeMillis();
        this.memoryLogger.checkMemory();
        return this.patterns;
    }

    private void scanDatabaseToDetermineFrequencyOfSingleItems(String input, Map<Integer, Integer> mapSupport) throws FileNotFoundException, IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(input));
        while ((line = reader.readLine()) != null) {
            String[] lineSplited;
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            for (String itemString : lineSplited = line.split(" ")) {
                Integer item = Integer.parseInt(itemString);
                Integer count = mapSupport.get(item);
                if (count == null) {
                    mapSupport.put(item, 1);
                    continue;
                }
                count = count + 1;
                mapSupport.put(item, count);
            }
            ++this.transactionCount;
        }
        reader.close();
    }

    private void fpgrowth(FPTree tree, int[] prefixAlpha, int prefixSupport, Map<Integer, Integer> mapSupport) throws IOException {
        if (!tree.hasMoreThanOnePath) {
            if (tree.root.childs.size() == 0) {
                System.out.println("Test");
            }
            this.addAllCombinationsForPathAndPrefix(tree.root.childs.get(0), prefixAlpha);
        } else {
            this.fpgrowthMoreThanOnePath(tree, prefixAlpha, prefixSupport, mapSupport);
        }
    }

    private void fpgrowthMoreThanOnePath(FPTree tree, int[] prefixAlpha, int prefixSupport, Map<Integer, Integer> mapSupport) throws IOException {
        for (int i = tree.headerList.size() - 1; i >= 0; --i) {
            Integer item = tree.headerList.get(i);
            int support = mapSupport.get(item);
            if (support < this.relativeMinsupp) continue;
            int[] beta = new int[prefixAlpha.length + 1];
            System.arraycopy(prefixAlpha, 0, beta, 0, prefixAlpha.length);
            beta[prefixAlpha.length] = item;
            int betaSupport = prefixSupport < support ? prefixSupport : support;
            this.saveItemset(beta, betaSupport);
            ArrayList prefixPaths = new ArrayList();
            FPNode path = tree.mapItemNodes.get(item);
            while (path != null) {
                if (path.parent.itemID != -1) {
                    ArrayList<FPNode> prefixPath = new ArrayList<FPNode>();
                    prefixPath.add(path);
                    FPNode parent = path.parent;
                    while (parent.itemID != -1) {
                        prefixPath.add(parent);
                        parent = parent.parent;
                    }
                    prefixPaths.add(prefixPath);
                }
                path = path.nodeLink;
            }
            HashMap<Integer, Integer> mapSupportBeta = new HashMap<Integer, Integer>();
            for (List list : prefixPaths) {
                int n = ((FPNode)list.get((int)0)).counter;
                for (int j = 1; j < list.size(); ++j) {
                    FPNode node = (FPNode)list.get(j);
                    if (mapSupportBeta.get(node.itemID) == null) {
                        mapSupportBeta.put(node.itemID, n);
                        continue;
                    }
                    mapSupportBeta.put(node.itemID, (Integer)mapSupportBeta.get(node.itemID) + n);
                }
            }
            FPTree treeBeta = new FPTree();
            for (List list : prefixPaths) {
                treeBeta.addPrefixPath(list, mapSupportBeta, this.relativeMinsupp);
            }
            treeBeta.createHeaderList(mapSupportBeta);
            if (treeBeta.root.childs.size() <= 0) continue;
            this.fpgrowth(treeBeta, beta, betaSupport, mapSupportBeta);
        }
    }

    private void addAllCombinationsForPathAndPrefix(FPNode node, int[] prefix) throws IOException {
        int[] itemset = new int[prefix.length + 1];
        System.arraycopy(prefix, 0, itemset, 0, prefix.length);
        itemset[prefix.length] = node.itemID;
        this.saveItemset(itemset, node.counter);
        if (node.childs.size() != 0) {
            this.addAllCombinationsForPathAndPrefix(node.childs.get(0), itemset);
            this.addAllCombinationsForPathAndPrefix(node.childs.get(0), prefix);
        }
    }

    private void saveItemset(int[] itemset, int support) throws IOException {
        ++this.itemsetCount;
        Arrays.sort(itemset);
        if (this.writer != null) {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < itemset.length; ++i) {
                buffer.append(itemset[i]);
                if (i == itemset.length - 1) continue;
                buffer.append(' ');
            }
            buffer.append(" #SUP: ");
            buffer.append(support);
            this.writer.write(buffer.toString());
            this.writer.newLine();
        } else {
            Itemset itemsetObj = new Itemset(itemset);
            itemsetObj.setAbsoluteSupport(support);
            this.patterns.addItemset(itemsetObj, itemsetObj.size());
        }
    }

    public void printStats() {
        System.out.println("=============  FP-GROWTH - STATS =============");
        long temps = this.endTime - this.startTimestamp;
        System.out.println(" Transactions count from database : " + this.transactionCount);
        System.out.print(" Max memory usage: " + this.memoryLogger.getMaxMemory() + " mb \n");
        System.out.println(" Frequent itemsets count : " + this.itemsetCount);
        System.out.println(" Total time ~ " + temps + " ms");
        System.out.println("===================================================");
    }

    public int getDatabaseSize() {
        return this.transactionCount;
    }
}

