/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.eclat;

import ca.pfv.spmf.datastructures.triangularmatrix.TriangularMatrix;
import ca.pfv.spmf.input.transaction_database_list_integers.TransactionDatabase;
import ca.pfv.spmf.patterns.itemset_array_integers_with_tids.Itemset;
import ca.pfv.spmf.patterns.itemset_array_integers_with_tids.Itemsets;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AlgoEclat {
    private int minsupRelative;
    protected TransactionDatabase database;
    protected long startTimestamp;
    protected long endTime;
    protected Itemsets frequentItemsets;
    BufferedWriter writer = null;
    protected int itemsetCount;
    private TriangularMatrix matrix;

    public Itemsets runAlgorithm(String output, TransactionDatabase database, double minsupp, boolean useTriangularMatrixOptimization) throws IOException {
        MemoryLogger.getInstance().reset();
        if (output == null) {
            this.writer = null;
            this.frequentItemsets = new Itemsets("FREQUENT ITEMSETS");
        } else {
            this.frequentItemsets = null;
            this.writer = new BufferedWriter(new FileWriter(output));
        }
        this.itemsetCount = 0;
        this.database = database;
        this.startTimestamp = System.currentTimeMillis();
        this.minsupRelative = (int)Math.ceil(minsupp * (double)database.size());
        final HashMap<Integer, Set<Integer>> mapItemCount = new HashMap<Integer, Set<Integer>>();
        int maxItemId = this.calculateSupportSingleItems(database, mapItemCount);
        if (useTriangularMatrixOptimization) {
            this.matrix = new TriangularMatrix(maxItemId + 1);
            for (List<Integer> itemset : database.getTransactions()) {
                Object[] array = itemset.toArray();
                for (int i = 0; i < itemset.size(); ++i) {
                    Integer itemI = (Integer)array[i];
                    for (int j = i + 1; j < itemset.size(); ++j) {
                        Integer itemJ = (Integer)array[j];
                        this.matrix.incrementCount(itemI, itemJ);
                    }
                }
            }
        }
        ArrayList<Integer> frequentItems = new ArrayList<Integer>();
        for (Map.Entry entry : mapItemCount.entrySet()) {
            Set tidset = (Set)entry.getValue();
            int support = tidset.size();
            int item = (Integer)entry.getKey();
            if (support < this.minsupRelative) continue;
            frequentItems.add(item);
            this.saveSingleItem(item, tidset, tidset.size());
        }
        Collections.sort(frequentItems, new Comparator<Integer>(){

            @Override
            public int compare(Integer arg0, Integer arg1) {
                return ((Set)mapItemCount.get(arg0)).size() - ((Set)mapItemCount.get(arg1)).size();
            }
        });
        for (int i = 0; i < frequentItems.size(); ++i) {
            Integer itemI = (Integer)frequentItems.get(i);
            Set tidsetI = (Set)mapItemCount.get(itemI);
            int supportI = tidsetI.size();
            ArrayList<Integer> equivalenceClassIitems = new ArrayList<Integer>();
            ArrayList<Set<Integer>> equivalenceClassItidsets = new ArrayList<Set<Integer>>();
            for (int j = i + 1; j < frequentItems.size(); ++j) {
                int support;
                int itemJ = (Integer)frequentItems.get(j);
                if (useTriangularMatrixOptimization && (support = this.matrix.getSupportForItems(itemI, itemJ)) < this.minsupRelative) continue;
                Set tidsetJ = (Set)mapItemCount.get(itemJ);
                int supportJ = tidsetJ.size();
                Set<Integer> tidsetIJ = this.performAND(tidsetI, supportI, tidsetJ, supportJ);
                if (!useTriangularMatrixOptimization && tidsetIJ.size() < this.minsupRelative) continue;
                equivalenceClassIitems.add(itemJ);
                equivalenceClassItidsets.add(tidsetIJ);
            }
            if (equivalenceClassIitems.size() <= 0) continue;
            this.processEquivalenceClass(new int[]{itemI}, supportI, equivalenceClassIitems, equivalenceClassItidsets);
        }
        MemoryLogger.getInstance().checkMemory();
        if (this.writer != null) {
            this.writer.close();
        }
        this.endTime = System.currentTimeMillis();
        return this.frequentItemsets;
    }

    private int calculateSupportSingleItems(TransactionDatabase database, Map<Integer, Set<Integer>> mapItemCount) {
        int maxItemId = 0;
        for (int i = 0; i < database.size(); ++i) {
            for (Integer item : database.getTransactions().get(i)) {
                Set<Integer> set = mapItemCount.get(item);
                if (set == null) {
                    set = new HashSet<Integer>();
                    mapItemCount.put(item, set);
                    if (item > maxItemId) {
                        maxItemId = item;
                    }
                }
                set.add(i);
            }
        }
        return maxItemId;
    }

    private void processEquivalenceClass(int[] prefix, int supportPrefix, List<Integer> equivalenceClassItems, List<Set<Integer>> equivalenceClassTidsets) throws IOException {
        if (equivalenceClassItems.size() == 1) {
            int itemI = equivalenceClassItems.get(0);
            Set<Integer> tidsetItemset = equivalenceClassTidsets.get(0);
            int support = this.calculateSupport(prefix.length, supportPrefix, tidsetItemset);
            this.save(prefix, itemI, tidsetItemset, support);
            return;
        }
        if (equivalenceClassItems.size() == 2) {
            int itemI = equivalenceClassItems.get(0);
            Set<Integer> tidsetI = equivalenceClassTidsets.get(0);
            int supportI = this.calculateSupport(prefix.length, supportPrefix, tidsetI);
            this.save(prefix, itemI, tidsetI, supportI);
            int itemJ = equivalenceClassItems.get(1);
            Set<Integer> tidsetJ = equivalenceClassTidsets.get(1);
            int supportJ = this.calculateSupport(prefix.length, supportPrefix, tidsetJ);
            this.save(prefix, itemJ, tidsetJ, supportJ);
            Set<Integer> tidsetIJ = this.performAND(tidsetI, tidsetI.size(), tidsetJ, tidsetJ.size());
            if (tidsetIJ.size() >= this.minsupRelative) {
                int[] newPrefix = new int[prefix.length + 1];
                System.arraycopy(prefix, 0, newPrefix, 0, prefix.length);
                newPrefix[prefix.length] = itemI;
                int supportIJ = this.calculateSupport(newPrefix.length, supportI, tidsetIJ);
                this.save(newPrefix, itemJ, tidsetIJ, supportIJ);
            }
            return;
        }
        for (int i = 0; i < equivalenceClassItems.size(); ++i) {
            int suffixI = equivalenceClassItems.get(i);
            Set<Integer> tidsetI = equivalenceClassTidsets.get(i);
            int supportI = this.calculateSupport(prefix.length, supportPrefix, tidsetI);
            this.save(prefix, suffixI, tidsetI, supportI);
            ArrayList<Integer> equivalenceClassISuffixItems = new ArrayList<Integer>();
            ArrayList<Set<Integer>> equivalenceITidsets = new ArrayList<Set<Integer>>();
            for (int j = i + 1; j < equivalenceClassItems.size(); ++j) {
                int supportJ;
                int suffixJ = equivalenceClassItems.get(j);
                Set<Integer> tidsetJ = equivalenceClassTidsets.get(j);
                Set<Integer> tidsetIJ = this.performAND(tidsetI, supportI, tidsetJ, supportJ = this.calculateSupport(prefix.length, supportPrefix, tidsetJ));
                if (tidsetIJ.size() < this.minsupRelative) continue;
                equivalenceClassISuffixItems.add(suffixJ);
                equivalenceITidsets.add(tidsetIJ);
            }
            if (equivalenceClassISuffixItems.size() <= 0) continue;
            int[] newPrefix = new int[prefix.length + 1];
            System.arraycopy(prefix, 0, newPrefix, 0, prefix.length);
            newPrefix[prefix.length] = suffixI;
            this.processEquivalenceClass(newPrefix, supportI, equivalenceClassISuffixItems, equivalenceITidsets);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private int calculateSupport(int lengthOfX, int supportPrefix, Set<Integer> tidsetI) {
        return tidsetI.size();
    }

    private Set<Integer> performAND(Set<Integer> tidsetI, int supportI, Set<Integer> tidsetJ, int supportJ) {
        HashSet<Integer> tidsetIJ = new HashSet<Integer>();
        if (supportI > supportJ) {
            for (Integer tid : tidsetJ) {
                if (!tidsetI.contains(tid)) continue;
                tidsetIJ.add(tid);
            }
        } else {
            for (Integer tid : tidsetI) {
                if (!tidsetJ.contains(tid)) continue;
                tidsetIJ.add(tid);
            }
        }
        return tidsetIJ;
    }

    private void save(int[] prefix, int suffixItem, Set<Integer> tidset, int support) throws IOException {
        ++this.itemsetCount;
        if (this.writer == null) {
            int[] itemsetArray = new int[prefix.length + 1];
            System.arraycopy(prefix, 0, itemsetArray, 0, prefix.length);
            itemsetArray[prefix.length] = suffixItem;
            Itemset itemset = new Itemset(itemsetArray);
            itemset.setTIDs(tidset);
            this.frequentItemsets.addItemset(itemset, itemset.size());
        } else {
            StringBuffer buffer = new StringBuffer();
            for (int item : prefix) {
                buffer.append(item);
                buffer.append(" ");
            }
            buffer.append(suffixItem);
            buffer.append(" #SUP: ");
            buffer.append(tidset.size());
            this.writer.write(buffer.toString());
            this.writer.newLine();
        }
    }

    private void saveSingleItem(int item, Set<Integer> tidset, int support) throws IOException {
        ++this.itemsetCount;
        if (this.writer == null) {
            Itemset itemset = new Itemset(new int[]{item});
            itemset.setTIDs(tidset);
            this.frequentItemsets.addItemset(itemset, itemset.size());
        } else {
            StringBuffer buffer = new StringBuffer();
            buffer.append(item);
            buffer.append(" #SUP: ");
            buffer.append(support);
            this.writer.write(buffer.toString());
            this.writer.newLine();
        }
    }

    public void printStats() {
        System.out.println("=============  ECLAT v0.96 - STATS =============");
        long temps = this.endTime - this.startTimestamp;
        System.out.println(" Transactions count from database : " + this.database.size());
        System.out.println(" Frequent itemsets count : " + this.itemsetCount);
        System.out.println(" Total time ~ " + temps + " ms");
        System.out.println(" Maximum memory usage : " + MemoryLogger.getInstance().getMaxMemory() + " mb");
        System.out.println("===================================================");
    }

    public Itemsets getItemsets() {
        return this.frequentItemsets;
    }
}

