/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Statistics.Regression;

import Catalano.Math.Matrix;
import Catalano.Statistics.Correlations;
import Catalano.Statistics.Regression.ILinear;
import Catalano.Statistics.Regression.ISimpleRegression;
import Catalano.Statistics.Tools;

public class LogarithmicRegression
implements ISimpleRegression,
ILinear {
    private double[] x;
    private double[] y;
    private double inclination;
    private double interception;

    public LogarithmicRegression(double[] x, double[] y) {
        this.x = x;
        this.y = y;
        double[] xx = Matrix.Log(x);
        this.inclination = Tools.Inclination(xx, y);
        this.interception = Tools.Interception(xx, y);
    }

    @Override
    public double getInclination() {
        return this.inclination;
    }

    @Override
    public void setInclination(double inclination) {
        this.inclination = inclination;
    }

    @Override
    public double getInterception() {
        return this.interception;
    }

    @Override
    public void setInterception(double interception) {
        this.interception = interception;
    }

    @Override
    public double Regression(double x) {
        return this.inclination * Math.log(x) + this.interception;
    }

    @Override
    public double[] Regression(double[] x) {
        double[] r = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            r[i] = this.inclination * Math.log(x[i]) + this.interception;
        }
        return r;
    }

    @Override
    public double CoefficientOfDetermination() {
        double[] r = this.Regression(this.x);
        return Math.pow(Correlations.PearsonCorrelation(r, this.y), 2.0);
    }

    @Override
    public String toString() {
        if (this.interception > 0.0) {
            return "y = " + String.format("%.4f", this.inclination) + "ln(x) + " + this.interception;
        }
        return "y = " + this.inclination + "ln(x) " + this.interception;
    }
}

