/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Statistics.Kernels;

import Catalano.Statistics.Kernels.IMercerKernel;

public class Gaussian
implements IMercerKernel<double[]> {
    private double gamma;

    public double getGamma() {
        return this.gamma;
    }

    public void setGamma(double gamma) {
        this.gamma = gamma / 100.0;
    }

    public Gaussian() {
        this(1.0);
    }

    public Gaussian(double gamma) {
        this.setGamma(gamma);
    }

    @Override
    public double Function(double[] x, double[] y) {
        if (x == y) {
            return 1.0;
        }
        double norm = 0.0;
        for (int i = 0; i < x.length; ++i) {
            double d = x[i] - y[i];
            norm += d * d;
        }
        return Math.exp(-this.gamma * norm);
    }
}

