/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Statistics.Distributions;

import Catalano.Math.Functions.Beta;
import Catalano.Math.Functions.Gamma;
import Catalano.Statistics.Distributions.IDistribution;

public class TStudentDistribution
implements IDistribution {
    private double constant;
    private double degreesOfFreedom;

    public double getDegreesOfFreedom() {
        return this.degreesOfFreedom;
    }

    public void setDegreesOfFreedom(double degreesOfFreedom) {
        this.degreesOfFreedom = degreesOfFreedom;
    }

    public TStudentDistribution(double degreesOfFreedom) {
        if (degreesOfFreedom < 1.0) {
            try {
                throw new IllegalArgumentException("degreesOfFreedom");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.degreesOfFreedom = degreesOfFreedom;
        double v = degreesOfFreedom;
        this.constant = Gamma.Function((v + 1.0) / 2.0) / (Math.sqrt(v * Math.PI) * Gamma.Function(v / 2.0));
    }

    @Override
    public double Mean() {
        return this.degreesOfFreedom > 1.0 ? 0.0 : Double.NaN;
    }

    @Override
    public double Variance() {
        if (this.degreesOfFreedom > 2.0) {
            return this.degreesOfFreedom / (this.degreesOfFreedom - 2.0);
        }
        if (this.degreesOfFreedom > 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return Double.NaN;
    }

    @Override
    public double Entropy() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public double DistributionFunction(double x) {
        double v = this.degreesOfFreedom;
        double sqrt = Math.sqrt(x * x + v);
        double u = (x + sqrt) / (2.0 * sqrt);
        return Beta.Incomplete(v / 2.0, v / 2.0, u);
    }

    @Override
    public double ProbabilityDensityFunction(double x) {
        double v = this.degreesOfFreedom;
        return this.constant * Math.pow(1.0 + x * x / this.degreesOfFreedom, -(v + 1.0) / 2.0);
    }

    @Override
    public double LogProbabilityDensityFunction(double x) {
        double v = this.degreesOfFreedom;
        return Math.log(this.constant) - (v + 1.0) / 2.0 * Math.log(1.0 + x * x / this.degreesOfFreedom);
    }
}

