/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Statistics.Distributions;

import Catalano.Math.Special;
import Catalano.Statistics.Distributions.IDistribution;

public class InverseGammaDistribution
implements IDistribution {
    private double mean;
    private double lambda;

    public InverseGammaDistribution(double mean, double shape) {
        if (mean <= 0.0 || shape <= 0.0) {
            try {
                throw new IllegalArgumentException("Mean or shape must be greater than 0");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.mean = mean;
        this.lambda = shape;
    }

    public double getShape() {
        return this.lambda;
    }

    @Override
    public double Variance() {
        return this.mean * this.mean * this.mean / this.lambda;
    }

    @Override
    public double DistributionFunction(double x) {
        double sqrt = Math.sqrt(this.lambda / x);
        double a = 0.5 * Special.Erfc(sqrt * (this.mean - x) / (1.4142135623730951 * this.mean));
        double b = 0.5 * Special.Erfc(sqrt * (this.mean + x) / (1.4142135623730951 * this.mean));
        double c = Math.exp(2.0 * this.lambda / this.mean);
        return a + b * c;
    }

    @Override
    public double ProbabilityDensityFunction(double x) {
        double a = Math.sqrt(this.lambda / (Math.PI * 2 * x * x * x));
        double b = -this.lambda * ((x - this.mean) * (x - this.mean)) / (2.0 * this.mean * this.mean * x);
        return a * Math.exp(b);
    }

    @Override
    public double LogProbabilityDensityFunction(double x) {
        double a = Math.sqrt(this.lambda / (Math.PI * 2 * x * x * x));
        double b = -this.lambda * ((x - this.mean) * (x - this.mean)) / (2.0 * this.mean * this.mean * x);
        return Math.log(a) + b;
    }

    @Override
    public double Mean() {
        return this.mean;
    }

    @Override
    public double Entropy() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

