/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Statistics.Distributions;

import Catalano.Math.Functions.Gamma;
import Catalano.Statistics.Distributions.IDistribution;

public class ChiSquareDistribution
implements IDistribution {
    private int degreesOfFreedom;
    private double entropy;

    public ChiSquareDistribution(int degreesOfFreedom) {
        this.degreesOfFreedom = degreesOfFreedom;
    }

    public int getDegreesOfFreedom() {
        return this.degreesOfFreedom;
    }

    @Override
    public double Mean() {
        return this.degreesOfFreedom;
    }

    @Override
    public double Variance() {
        return 2.0 * (double)this.degreesOfFreedom;
    }

    @Override
    public double Entropy() {
        double kd2 = (double)this.degreesOfFreedom / 2.0;
        double m1 = Math.log(2.0 * Gamma.Function(kd2));
        double m2 = (1.0 - kd2) * Gamma.Digamma(kd2);
        this.entropy = kd2 + m1 + m2;
        return this.entropy;
    }

    public double ComplementaryDistributionFunction(double x) {
        return Gamma.ComplementedIncomplete((double)this.degreesOfFreedom / 2.0, x / 2.0);
    }

    @Override
    public double DistributionFunction(double x) {
        return Gamma.Incomplete((double)this.degreesOfFreedom / 2.0, x / 2.0);
    }

    @Override
    public double ProbabilityDensityFunction(double x) {
        double v = this.degreesOfFreedom;
        double m1 = Math.pow(x, (v - 2.0) / 2.0);
        double m2 = Math.exp(-x / 2.0);
        double m3 = Math.pow(2.0, v / 2.0) * Gamma.Function(v / 2.0);
        return m1 * m2 / m3;
    }

    @Override
    public double LogProbabilityDensityFunction(double x) {
        double v = this.degreesOfFreedom;
        double m1 = (v - 2.0) / 2.0 * Math.log(x);
        double m2 = -x / 2.0;
        double m3 = v / 2.0 * Math.log(2.0) + Gamma.Log(v / 2.0);
        return m1 + m2 - m3;
    }
}

