/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Math;

import Catalano.Math.Vector4;

public class Vector3 {
    public float x;
    public float y;
    public float z;

    public Vector3() {
    }

    public Vector3(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3(float value) {
        this.y = this.z = value;
        this.x = this.z;
    }

    public float getMax() {
        return this.x > this.y ? (this.x > this.z ? this.x : this.z) : (this.y > this.z ? this.y : this.z);
    }

    public float getMin() {
        return this.x < this.y ? (this.x < this.z ? this.x : this.z) : (this.y < this.z ? this.y : this.z);
    }

    public int getMaxIndex() {
        return this.x >= this.y ? (this.x >= this.z ? 0 : 2) : (this.y >= this.z ? 1 : 2);
    }

    public int getMinIndex() {
        return this.x <= this.y ? (this.x <= this.z ? 0 : 2) : (this.y <= this.z ? 1 : 2);
    }

    public float Norm() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public float Square() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public float[] toArray() {
        return new float[]{this.x, this.y, this.z};
    }

    public static Vector3 Add(Vector3 vector1, Vector3 vector2) {
        return new Vector3(vector1.x + vector2.x, vector1.y + vector2.y, vector1.z + vector2.z);
    }

    public static Vector3 Add(Vector3 vector, float value) {
        return new Vector3(vector.x + value, vector.y + value, vector.z + value);
    }

    public static Vector3 Subtract(Vector3 vector1, Vector3 vector2) {
        return new Vector3(vector1.x - vector2.x, vector1.y - vector2.y, vector1.z - vector2.z);
    }

    public static Vector3 Subtract(Vector3 vector, float value) {
        return new Vector3(vector.x - value, vector.y - value, vector.z - value);
    }

    public static Vector3 Multiply(Vector3 vector1, Vector3 vector2) {
        return new Vector3(vector1.x * vector2.x, vector1.y * vector2.y, vector1.z * vector2.z);
    }

    public static Vector3 Multiply(Vector3 vector, float factor) {
        return new Vector3(vector.x * factor, vector.y * factor, vector.z * factor);
    }

    public static Vector3 Divide(Vector3 vector1, Vector3 vector2) {
        return new Vector3(vector1.x / vector2.x, vector1.y / vector2.y, vector1.z / vector2.z);
    }

    public static Vector3 Divide(Vector3 vector, float factor) {
        return new Vector3(vector.x / factor, vector.y / factor, vector.z / factor);
    }

    public float Normalize() {
        float norm = (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        float invNorm = 1.0f / norm;
        this.x *= invNorm;
        this.y *= invNorm;
        this.z *= invNorm;
        return norm;
    }

    public Vector3 Inverse() {
        return new Vector3(this.x == 0.0f ? 0.0f : 1.0f / this.z, this.y == 0.0f ? 0.0f : 1.0f / this.y, this.z == 0.0f ? 0.0f : 1.0f / this.z);
    }

    public Vector3 Abs() {
        return new Vector3(Math.abs(this.x), Math.abs(this.y), Math.abs(this.z));
    }

    public static Vector3 Cross(Vector3 vector1, Vector3 vector2) {
        return new Vector3(vector1.y * vector2.z - vector1.z * vector2.y, vector1.z * vector2.x - vector1.x * vector2.z, vector1.x * vector2.y - vector1.y * vector2.x);
    }

    public static float Dot(Vector3 vector1, Vector3 vector2) {
        return vector1.x * vector2.x + vector1.y * vector2.y + vector1.z * vector2.z;
    }

    public Vector4 toVector4() {
        return new Vector4(this.x, this.y, this.z, 1.0f);
    }

    public boolean equals(Object obj) {
        if (obj.getClass().isAssignableFrom(Vector3.class)) {
            Vector3 v = (Vector3)obj;
            if (this.x == v.x && this.y == v.y && this.z == v.z) {
                return true;
            }
        }
        return false;
    }
}

