/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Math.Transforms;

public final class DiscreteCosineTransform {
    private DiscreteCosineTransform() {
    }

    public static void Forward(double[] data) {
        double[] result = new double[data.length];
        double scale = Math.sqrt(2.0 / (double)data.length);
        for (int f = 0; f < data.length; ++f) {
            double sum = 0.0;
            for (int t = 0; t < data.length; ++t) {
                double cos = Math.cos((2.0 * (double)t + 1.0) * (double)f * Math.PI / (2.0 * (double)data.length));
                sum += data[t] * cos * DiscreteCosineTransform.alpha(f);
            }
            result[f] = scale * sum;
        }
        for (int i = 0; i < data.length; ++i) {
            data[i] = result[i];
        }
    }

    public static void Forward(double[][] data) {
        int rows = data.length;
        int cols = data[0].length;
        double[] row = new double[cols];
        double[] col = new double[rows];
        for (int i = 0; i < rows; ++i) {
            int j;
            for (j = 0; j < row.length; ++j) {
                row[j] = data[i][j];
            }
            DiscreteCosineTransform.Forward(row);
            for (j = 0; j < row.length; ++j) {
                data[i][j] = row[j];
            }
        }
        for (int j = 0; j < cols; ++j) {
            int i;
            for (i = 0; i < col.length; ++i) {
                col[i] = data[i][j];
            }
            DiscreteCosineTransform.Forward(col);
            for (i = 0; i < col.length; ++i) {
                data[i][j] = col[i];
            }
        }
    }

    public static void Backward(double[] data) {
        double[] result = new double[data.length];
        double scale = Math.sqrt(2.0 / (double)data.length);
        for (int t = 0; t < data.length; ++t) {
            double sum = 0.0;
            for (int j = 0; j < data.length; ++j) {
                double cos = Math.cos((double)((2 * t + 1) * j) * Math.PI / (double)(2 * data.length));
                sum += DiscreteCosineTransform.alpha(j) * data[j] * cos;
            }
            result[t] = scale * sum;
        }
        for (int i = 0; i < data.length; ++i) {
            data[i] = result[i];
        }
    }

    public static void Backward(double[][] data) {
        int rows = data.length;
        int cols = data[0].length;
        double[] row = new double[cols];
        double[] col = new double[rows];
        for (int j = 0; j < cols; ++j) {
            int i;
            for (i = 0; i < row.length; ++i) {
                col[i] = data[i][j];
            }
            DiscreteCosineTransform.Backward(col);
            for (i = 0; i < col.length; ++i) {
                data[i][j] = col[i];
            }
        }
        for (int i = 0; i < rows; ++i) {
            int j;
            for (j = 0; j < row.length; ++j) {
                row[j] = data[i][j];
            }
            DiscreteCosineTransform.Backward(row);
            for (j = 0; j < row.length; ++j) {
                data[i][j] = row[j];
            }
        }
    }

    private static double alpha(double v) {
        if (v == 0.0) {
            return 1.0 / Math.sqrt(2.0);
        }
        return 1.0;
    }
}

