/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Math.Random;

import Catalano.Math.Random.IRandomNumberGenerator;
import java.util.concurrent.atomic.AtomicLong;

public class Pcg32
implements IRandomNumberGenerator {
    private long state;
    private long inc;
    private static final long MULTIPLIER = 6364136223846793005L;
    private double nextNextGaussian;
    private boolean haveNextNextGaussian = false;
    private static final AtomicLong streamUniquifier = new AtomicLong(System.identityHashCode(Pcg32.class));

    @Override
    public void setSeed(long seed) {
        this.seed(seed, Pcg32.streamUniquifier());
    }

    public Pcg32(long initState, long initSeq) {
        this.seed(initState, initSeq);
    }

    public Pcg32() {
        this.seed();
    }

    @Override
    public int nextInt() {
        long oldState = this.state;
        this.state = oldState * 6364136223846793005L + this.inc;
        int xorShifted = (int)((oldState >>> 18 ^ oldState) >>> 27);
        int rot = (int)(oldState >>> 59);
        return Integer.rotateRight(xorShifted, rot);
    }

    @Override
    public int nextInt(int n) {
        int val;
        int bits;
        if (n <= 0) {
            throw new IllegalArgumentException("n must be positive");
        }
        while ((bits = this.nextInt() >>> 1) - (val = bits % n) + (n - 1) < 0) {
        }
        return val;
    }

    @Override
    public long nextLong() {
        return ((long)this.nextInt() << 32) + (long)this.nextInt();
    }

    public long nextLong(long n) {
        long val;
        long bits;
        if (n <= 0L) {
            throw new IllegalArgumentException("n must be positive");
        }
        while ((bits = this.nextLong() >>> 1) - (val = bits % n) + (n - 1L) < 0L) {
        }
        return val;
    }

    public boolean nextBoolean() {
        return (this.nextInt() & 1) != 0;
    }

    public float nextFloat() {
        return (float)this.nextBits(24) / 1.6777216E7f;
    }

    public float nextFloat(float bound) {
        return bound * this.nextFloat();
    }

    @Override
    public double nextDouble() {
        return (double)(((long)this.nextBits(26) << 27) + (long)this.nextBits(27)) / 9.007199254740992E15;
    }

    public double nextDouble(double bound) {
        return bound * this.nextDouble();
    }

    @Override
    public int nextBits(int bits) {
        return this.nextInt() >>> 32 - bits;
    }

    public double nextGaussian() {
        double v2;
        double v1;
        double s;
        if (this.haveNextNextGaussian) {
            this.haveNextNextGaussian = false;
            return this.nextNextGaussian;
        }
        while ((s = (v1 = 2.0 * this.nextDouble() - 1.0) * v1 + (v2 = 2.0 * this.nextDouble() - 1.0) * v2) >= 1.0 || s == 0.0) {
        }
        double multiplier = StrictMath.sqrt(-2.0 * StrictMath.log(s) / s);
        this.nextNextGaussian = v2 * multiplier;
        this.haveNextNextGaussian = true;
        return v1 * multiplier;
    }

    public double nextGaussian(double mean, double standardDeviation) {
        return this.nextGaussian() * standardDeviation + mean;
    }

    public void seed(long initState, long initSeq) {
        this.state = 0L;
        this.inc = 2L * initSeq + 1L;
        this.nextInt();
        this.state += initState;
        this.nextInt();
    }

    public void seed() {
        this.seed(System.nanoTime(), Pcg32.streamUniquifier());
    }

    private static long streamUniquifier() {
        long next;
        long current;
        while (!streamUniquifier.compareAndSet(current = streamUniquifier.get(), next = current * 181783497276652981L)) {
        }
        return next;
    }

    @Override
    public void nextDoubles(double[] d) {
        int n = d.length;
        for (int i = 0; i < n; ++i) {
            d[i] = this.nextDouble();
        }
    }
}

