/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Math.Functions;

import Catalano.Math.Special;

public class Normal {
    private Normal() {
    }

    public static double Function(double value) {
        return 0.5 * Special.Erfc(-value / 1.4142135623730951);
    }

    public static double Inverse(double y0) {
        if (y0 <= 0.0) {
            if (y0 == 0.0) {
                return Double.NEGATIVE_INFINITY;
            }
            try {
                throw new IllegalArgumentException("y0");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (y0 >= 1.0) {
            if (y0 == 1.0) {
                return Double.POSITIVE_INFINITY;
            }
            try {
                throw new IllegalArgumentException("y0");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        double s2pi = Math.sqrt(Math.PI * 2);
        boolean code = true;
        double y = y0;
        double[] P0 = new double[]{-59.96335010141079, 98.00107541859997, -56.67628574690703, 13.931260938727968, -1.2391658386738125};
        double[] Q0 = new double[]{1.9544885833814176, 4.676279128988815, 86.36024213908905, -225.46268785411937, 200.26021238006066, -82.03722561683334, 15.90562251262117, -1.1833162112133};
        double[] P1 = new double[]{4.0554489230596245, 31.525109459989388, 57.16281922464213, 44.08050738932008, 14.684956192885803, 2.1866330685079025, -0.1402560791713545, -0.03504246268278482, -8.574567851546854E-4};
        double[] Q1 = new double[]{15.779988325646675, 45.39076351288792, 41.3172038254672, 15.04253856929075, 2.504649462083094, -0.14218292285478779, -0.03808064076915783, -9.332594808954574E-4};
        double[] P2 = new double[]{3.2377489177694603, 6.915228890689842, 3.9388102529247444, 1.3330346081580755, 0.20148538954917908, 0.012371663481782003, 3.0158155350823543E-4, 2.6580697468673755E-6, 6.239745391849833E-9};
        double[] Q2 = new double[]{6.02427039364742, 3.6798356385616087, 1.3770209948908132, 0.21623699359449663, 0.013420400608854318, 3.2801446468212774E-4, 2.8924786474538068E-6, 6.790194080099813E-9};
        if (y > 0.8646647167633873) {
            y = 1.0 - y;
            code = false;
        }
        if (y > 0.1353352832366127) {
            double y2 = (y -= 0.5) * y;
            double x = y + y * (y2 * Special.Polevl(y2, P0, 4) / Special.P1evl(y2, Q0, 8));
            return x *= s2pi;
        }
        double x = Math.sqrt(-2.0 * Math.log(y));
        double x0 = x - Math.log(x) / x;
        double z = 1.0 / x;
        double x1 = x < 8.0 ? z * Special.Polevl(z, P1, 8) / Special.P1evl(z, Q1, 8) : z * Special.Polevl(z, P2, 8) / Special.P1evl(z, Q2, 8);
        x = x0 - x1;
        if (code) {
            x = -x;
        }
        return x;
    }

    public static double HighAccuracyFunction(double x) {
        double sum;
        if (x < -8.0 || x > 8.0) {
            return 0.0;
        }
        double term = 0.0;
        double nextTerm = x;
        double pwr = x * x;
        double i = 1.0;
        for (sum = x; sum != term; sum += (nextTerm *= pwr / (i += 2.0))) {
            term = sum;
        }
        return 0.5 + sum * Math.exp(-0.5 * pwr - 0.9189385332046728);
    }

    public static double HighAccuracyComplemented(double x) {
        double[] R = new double[]{1.2533141373155003, 0.4213692292880545, 0.23665238291356067, 0.16237766089686745, 0.1231319632579323, 0.09902859647173193, 0.08276628650136918, 0.07106958053885211, 0.0622586659950262};
        int j = (int)(0.5 * (Math.abs(x) + 1.0));
        double a = R[j];
        double z = 2 * j;
        double b = a * z - 1.0;
        double h = Math.abs(x) - z;
        double q = h * h;
        double pwr = 1.0;
        double sum = a + h * b;
        double term = a;
        int i = 2;
        while (sum != term) {
            term = sum;
            a = (a + z * b) / (double)i;
            b = (b + z * a) / (double)(i + 1);
            sum = term + (pwr *= q) * (a + h * b);
            i += 2;
        }
        return x >= 0.0 ? sum : 1.0 - (sum *= Math.exp(-0.5 * (x * x) - 0.9189385332046728));
    }
}

