/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Math.Functions.Chaotic;

import Catalano.Math.Functions.Chaotic.IChaoticFunction;

public class SineMap
implements IChaoticFunction {
    private double u;

    public SineMap() {
        this(1.0);
    }

    public SineMap(double u) {
        this.u = u;
    }

    @Override
    public double Generate(double x) {
        return this.u * Math.sin(Math.PI * x);
    }

    @Override
    public double[] Generate(double initialState, int iterations) {
        double[] map = new double[iterations];
        map[0] = initialState;
        for (int i = 1; i < iterations; ++i) {
            map[i] = this.Generate(map[i - 1]);
        }
        return map;
    }
}

