/*
 * Decompiled with CFR 0.152.
 */
package Catalano.MachineLearning.Regression;

import Catalano.MachineLearning.Dataset.DatasetRegression;
import Catalano.MachineLearning.Regression.IRegression;
import Catalano.Math.Matrix;
import Catalano.Statistics.Tools;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class BaggingLearning
implements IRegression {
    private int times;
    private List<IRegression> regressions;
    private IRegression regression;
    private boolean includeAttributes;

    public boolean isIncludeAttributes() {
        return this.includeAttributes;
    }

    public void setIncludeAttributes(boolean includeAttributes) {
        this.includeAttributes = includeAttributes;
    }

    public BaggingLearning(IRegression regression) {
        this(regression, 11);
    }

    public BaggingLearning(IRegression regression, int times) {
        this(regression, times, false);
    }

    public BaggingLearning(IRegression regression, int times, boolean includeAttributes) {
        this.regression = regression;
        this.regressions = new ArrayList<IRegression>(times);
        this.times = times;
        this.includeAttributes = includeAttributes;
    }

    @Override
    public void Learn(DatasetRegression dataset) {
        this.Learn(dataset.getInput(), dataset.getOutput());
    }

    @Override
    public void Learn(double[][] input, double[] output) {
        for (int i = 0; i < this.times; ++i) {
            Random r = new Random();
            int[] index = new int[input.length];
            for (int j = 0; j < index.length; ++j) {
                index[j] = r.nextInt(input.length);
            }
            double[][] train = Matrix.getRows(input, index);
            double[] outputTrain = Matrix.getColumns(output, index);
            if (this.includeAttributes) {
                index = new int[input[0].length];
                for (int j = 0; j < index.length; ++j) {
                    index[j] = r.nextInt(input[0].length);
                }
                train = Matrix.getColumns(train, index);
            }
            this.regression.Learn(train, outputTrain);
            this.regressions.add(this.regression.clone());
        }
    }

    @Override
    public double Predict(double[] sample) {
        double[] map = new double[this.regressions.size()];
        for (int i = 0; i < map.length; ++i) {
            map[i] = this.regressions.get(i).Predict(sample);
        }
        return Tools.Mean(map);
    }

    @Override
    public IRegression clone() {
        try {
            return (IRegression)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalArgumentException("Clone not supported: " + ex.getMessage());
        }
    }
}

