/*
 * Decompiled with CFR 0.152.
 */
package Catalano.MachineLearning.FeatureSelection;

import Catalano.Core.ArraysUtil;
import Catalano.MachineLearning.Dataset.DatasetClassification;
import Catalano.MachineLearning.FeatureSelection.ISupervisionedFeatureSelection;
import Catalano.Math.Matrix;

public class MeanVarianceFeatureSelection
implements ISupervisionedFeatureSelection {
    private double[] rank;
    private int[] features;

    @Override
    public void Compute(DatasetClassification dataset) {
        this.Compute(dataset.getInput(), dataset.getOutput());
    }

    @Override
    public void Compute(double[][] input, int[] labels) {
        int i;
        int j;
        int i2;
        int j2;
        int i3;
        this.rank = new double[input[0].length];
        int n = Matrix.Max(labels) + 1;
        int[] groups = this.CountGroups(labels, n);
        double[][] means = new double[n][input[0].length];
        for (i3 = 0; i3 < input.length; ++i3) {
            for (j2 = 0; j2 < input[0].length; ++j2) {
                double[] dArray = means[labels[i3]];
                int n2 = j2;
                dArray[n2] = dArray[n2] + input[i3][j2];
            }
        }
        for (i3 = 0; i3 < means.length; ++i3) {
            j2 = 0;
            while (j2 < means[0].length) {
                double[] dArray = means[i3];
                int n3 = j2++;
                dArray[n3] = dArray[n3] / (double)groups[i3];
            }
        }
        double[][] vars = new double[n][input[0].length];
        for (i2 = 0; i2 < input.length; ++i2) {
            for (j = 0; j < input[0].length; ++j) {
                double[] dArray = vars[labels[i2]];
                int n4 = j;
                dArray[n4] = dArray[n4] + Math.pow(input[i2][j] - means[labels[i2]][j], 2.0);
            }
        }
        for (i2 = 0; i2 < vars.length; ++i2) {
            j = 0;
            while (j < vars[0].length) {
                double[] dArray = vars[i2];
                int n5 = j++;
                dArray[n5] = dArray[n5] / (double)(groups[i2] - 1);
            }
        }
        double[] se = new double[input[0].length];
        for (j = 0; j < se.length; ++j) {
            double t = 0.0;
            for (i = 0; i < vars.length; ++i) {
                t += vars[i][j] / (double)groups[i];
            }
            se[j] = Math.sqrt(t);
        }
        for (int j3 = 0; j3 < means[0].length; ++j3) {
            double mean = means[0][j3];
            for (i = 1; i < means.length; ++i) {
                mean -= means[i][j3];
            }
            this.rank[j3] = Math.abs(mean) / se[j3];
        }
        this.features = ArraysUtil.Argsort(this.rank, false);
    }

    @Override
    public int[] getFeatureIndex() {
        return this.features;
    }

    @Override
    public double[] getRank() {
        return this.rank;
    }

    private int[] CountGroups(int[] labels, int classes) {
        int[] groups = new int[classes];
        for (int i = 0; i < labels.length; ++i) {
            int n = labels[i];
            groups[n] = groups[n] + 1;
        }
        return groups;
    }

    private double[][] SplitInGroups(double[][] data, int columnIndex, int[] labels, int groups) {
        double[][] newData = new double[groups][];
        for (int i = 0; i < data.length; ++i) {
            newData[labels[i]][i] = data[i][columnIndex];
        }
        return newData;
    }
}

