/*
 * Decompiled with CFR 0.152.
 */
package Catalano.MachineLearning.FeatureSelection;

import Catalano.MachineLearning.Classification.IClassifier;
import Catalano.MachineLearning.Dataset.DatasetClassification;
import Catalano.MachineLearning.Performance.IValidation;
import Catalano.Math.Matrix;
import java.util.ArrayList;

public class CombinatorialFeatureSelection {
    private IClassifier classifier;
    private IValidation validation;
    private double score;
    private int[] bestIndexes;

    public IClassifier getClassifier() {
        return this.classifier;
    }

    public void setClassifier(IClassifier classifier) {
        this.classifier = classifier;
    }

    public IValidation getValidation() {
        return this.validation;
    }

    public void setValidation(IValidation validation) {
        this.validation = validation;
    }

    public double bestScore() {
        return this.score;
    }

    public int[] getFeatureIndex() {
        return this.bestIndexes;
    }

    public CombinatorialFeatureSelection(IClassifier classifier, IValidation validation) {
        this.classifier = classifier;
        this.validation = validation;
    }

    public void Compute(DatasetClassification dataset) {
        this.Compute(dataset.getInput(), dataset.getOutput());
    }

    public void Compute(double[][] input, int[] labels) {
        int n = (int)Math.pow(2.0, input[0].length);
        this.score = 0.0;
        for (int i = 0; i < n; ++i) {
            boolean[] usage = this.toBinary(i + 1, input[0].length);
            int[] index = this.getIndex(usage);
            double[][] features = Matrix.getColumns(input, index);
            double val = this.validation.Run(this.classifier, features, labels);
            if (!(val > this.score)) continue;
            this.score = val;
            this.bestIndexes = index;
        }
    }

    private boolean[] toBinary(int number, int bits) {
        boolean[] ret = new boolean[bits];
        for (int i = 0; i < bits; ++i) {
            ret[bits - 1 - i] = (1 << i & number) != 0;
        }
        return ret;
    }

    private int[] getIndex(boolean[] bits) {
        ArrayList<Integer> lst = new ArrayList<Integer>();
        for (int i = 0; i < bits.length; ++i) {
            if (!bits[i]) continue;
            lst.add(new Integer(i));
        }
        int[] elem = new int[lst.size()];
        for (int i = 0; i < elem.length; ++i) {
            elem[i] = (Integer)lst.get(i);
        }
        return elem;
    }
}

