/*
 * Decompiled with CFR 0.152.
 */
package Catalano.MachineLearning.FeatureScaling;

import Catalano.MachineLearning.Dataset.DecisionVariable;
import Catalano.MachineLearning.FeatureScaling.IFeatureScaling;
import Catalano.Math.Matrix;

public class PowerNormalization
implements IFeatureScaling {
    private double power;

    public double getPower() {
        return this.power;
    }

    public void setPower(double power) {
        this.power = power;
    }

    public PowerNormalization() {
        this(1.0);
    }

    public PowerNormalization(double power) {
        this.power = power;
    }

    @Override
    public double[][] Apply(double[][] data) {
        double[][] result = Matrix.Copy(data);
        this.ApplyInPlace(result);
        return result;
    }

    @Override
    public double[][] Apply(DecisionVariable[] variables, double[][] data) {
        double[][] result = Matrix.Copy(data);
        this.ApplyInPlace(variables, result);
        return result;
    }

    @Override
    public void ApplyInPlace(double[][] data) {
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                data[i][j] = Math.signum(data[i][j]) * Math.pow(Math.abs(data[i][j]), this.power);
            }
        }
    }

    @Override
    public void ApplyInPlace(DecisionVariable[] variables, double[][] data) {
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                if (variables[j].type != DecisionVariable.Type.Continuous) continue;
                data[i][j] = Math.signum(data[i][j]) * Math.pow(Math.abs(data[i][j]), this.power);
            }
        }
    }

    @Override
    public double[] Compute(double[] feature) {
        double[] result = new double[feature.length];
        for (int i = 0; i < feature.length; ++i) {
            result[i] = Math.signum(feature[i]) * Math.pow(Math.abs(feature[i]), this.power);
        }
        return result;
    }

    @Override
    public double[] Compute(DecisionVariable[] variables, double[] feature) {
        double[] result = new double[feature.length];
        for (int i = 0; i < feature.length; ++i) {
            if (variables[i].type != DecisionVariable.Type.Continuous) continue;
            result[i] = Math.signum(feature[i]) * Math.pow(Math.abs(feature[i]), this.power);
        }
        return result;
    }
}

