/*
 * Decompiled with CFR 0.152.
 */
package Catalano.MachineLearning.FeatureScaling;

import Catalano.MachineLearning.Dataset.DecisionVariable;
import Catalano.MachineLearning.FeatureScaling.IFeatureScaling;
import Catalano.Math.Matrix;
import Catalano.Statistics.Tools;

public class MaximumNormalization
implements IFeatureScaling {
    private double[] range;

    public double[] getRangeNormalization() {
        return this.range;
    }

    public void setRangeNormalization(double[] range) {
        this.range = range;
    }

    @Override
    public double[][] Apply(double[][] data) {
        double[][] result = Matrix.Copy(data);
        this.ApplyInPlace(result);
        return result;
    }

    @Override
    public double[][] Apply(DecisionVariable[] variables, double[][] data) {
        double[][] result = Matrix.Copy(data);
        this.ApplyInPlace(variables, result);
        return result;
    }

    @Override
    public void ApplyInPlace(double[][] data) {
        this.range = new double[data[0].length];
        int idx = 0;
        for (int i = 0; i < data[0].length; ++i) {
            double max;
            double[] temp = Matrix.getColumn(data, i);
            this.range[idx] = max = Tools.Max(temp);
            ++idx;
            for (int j = 0; j < temp.length; ++j) {
                data[j][i] = temp[j] / max;
            }
        }
    }

    @Override
    public void ApplyInPlace(DecisionVariable[] attributes, double[][] data) {
        int i;
        int continuous = 0;
        if (attributes == null) {
            attributes = new DecisionVariable[data[0].length + 1];
            for (i = 0; i < attributes.length - 1; ++i) {
                attributes[i] = new DecisionVariable("F" + i, DecisionVariable.Type.Continuous);
            }
            attributes[attributes.length - 1] = new DecisionVariable("Class", DecisionVariable.Type.Discrete);
            continuous += data[0].length;
        } else {
            for (i = 0; i < attributes.length; ++i) {
                if (attributes[i].type != DecisionVariable.Type.Continuous) continue;
                ++continuous;
            }
        }
        this.range = new double[continuous];
        int idx = 0;
        for (int i2 = 0; i2 < data[0].length; ++i2) {
            double max;
            if (attributes[i2].type != DecisionVariable.Type.Continuous) continue;
            double[] temp = Matrix.getColumn(data, i2);
            this.range[idx] = max = Tools.Max(temp);
            ++idx;
            for (int j = 0; j < temp.length; ++j) {
                data[j][i2] = temp[j] / max;
            }
        }
    }

    @Override
    public double[] Compute(double[] feature) {
        double[] norm = new double[feature.length];
        for (int i = 0; i < norm.length; ++i) {
            double v;
            norm[i] = v = feature[i] / this.range[i];
        }
        return norm;
    }

    @Override
    public double[] Compute(DecisionVariable[] attributes, double[] feature) {
        double[] norm = new double[feature.length];
        for (int i = 0; i < norm.length; ++i) {
            int idx = 0;
            if (attributes[i].type != DecisionVariable.Type.Continuous) continue;
            double v = feature[i] / this.range[idx];
            ++idx;
            v = v > 1.0 ? 1.0 : v;
            norm[i] = v = v < 0.0 ? 0.0 : v;
        }
        return norm;
    }
}

