/*
 * Decompiled with CFR 0.152.
 */
package Catalano.MachineLearning.Dataset;

import Catalano.Core.ArraysUtil;
import Catalano.MachineLearning.Codebook;
import Catalano.MachineLearning.Dataset.DecisionVariable;
import Catalano.MachineLearning.Dataset.IDataset;
import Catalano.MachineLearning.Dataset.Imputation.IImputation;
import Catalano.MachineLearning.Dataset.StatisticsDataset;
import Catalano.MachineLearning.FeatureScaling.IFeatureScaling;
import Catalano.MachineLearning.FeatureScaling.Normalization;
import Catalano.MachineLearning.FeatureScaling.Standartization;
import Catalano.Math.Matrix;
import Catalano.Math.Tools;
import Catalano.Statistics.DescriptiveStatistics;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DatasetClassification
implements IDataset<double[][], int[]> {
    private String name;
    private double[][] input;
    private int[] output;
    private DecisionVariable[] attributes;
    private int numClasses;
    private int continuous = 0;
    private int classIndex = -1;
    private IFeatureScaling normalization;
    private Codebook codebook;

    public String getName() {
        return this.name;
    }

    @Override
    public double[][] getInput() {
        return this.input;
    }

    @Override
    public void setInput(double[][] input, DecisionVariable[] variables) {
        if (this.input[0].length != variables.length) {
            throw new IllegalArgumentException("The number of features and variables are not the same.");
        }
        this.input = input;
        this.attributes = variables;
    }

    @Override
    public int[] getOutput() {
        return this.output;
    }

    public int getClassIndex() {
        return this.classIndex;
    }

    public void setClassIndex(int classIndex) {
        this.classIndex = classIndex;
    }

    @Override
    public DecisionVariable[] getDecisionVariables() {
        return this.attributes;
    }

    public int getNumberOfInstances() {
        return this.input.length;
    }

    public int getNumberOfAttributes() {
        return this.attributes.length;
    }

    public int getNumberOfClasses() {
        return this.numClasses;
    }

    public int getNumberOfContinuous() {
        return this.continuous;
    }

    public int getNumberOfDiscrete() {
        return this.attributes.length - this.continuous;
    }

    public IFeatureScaling getFeatureScaling() {
        return this.normalization;
    }

    public Codebook getCodebook() {
        return this.codebook;
    }

    public static DatasetClassification FromCSV(String filepath, String name) {
        return DatasetClassification.FromCSV(filepath, name, false);
    }

    public static DatasetClassification FromCSV(String filepath, String name, boolean ignoreAttributeInfo) {
        return DatasetClassification.FromCSV(filepath, name, ignoreAttributeInfo, -1);
    }

    public static DatasetClassification FromCSV(String filepath, String name, boolean ignoreAttributeInfo, int classIndex) {
        double[][] input = null;
        int[] output = null;
        DecisionVariable[] attributes = null;
        int numClasses = 0;
        int continuous = 0;
        Codebook codebook = null;
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filepath), "UTF-8"));
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = br.readLine()) != null) {
                lines.add(line);
            }
            if (lines.size() > 0) {
                int[] indexes;
                ArrayList lst;
                int start;
                String[] header = null;
                String[] firstInstance = null;
                if (ignoreAttributeInfo) {
                    firstInstance = ((String)lines.get(0)).split(String.valueOf(','));
                    header = new String[firstInstance.length];
                    for (int i = 0; i < header.length - 1; ++i) {
                        header[i] = "F" + i;
                    }
                    header[header.length - 1] = "Class";
                    start = 0;
                } else {
                    header = ((String)lines.get(0)).split(String.valueOf(','));
                    firstInstance = ((String)lines.get(1)).split(String.valueOf(','));
                    start = 1;
                }
                if (classIndex == -1) {
                    classIndex = header.length - 1;
                }
                attributes = new DecisionVariable[header.length];
                HashSet<String> hs = new HashSet<String>();
                int discretes = 0;
                int idx = 0;
                for (int i = 0; i < header.length; ++i) {
                    hs.add(header[i]);
                    if (Tools.isNumeric(firstInstance[i])) {
                        attributes[idx] = new DecisionVariable(header[i], DecisionVariable.Type.Continuous);
                        ++continuous;
                    } else {
                        attributes[idx] = new DecisionVariable(header[i], DecisionVariable.Type.Discrete);
                        ++discretes;
                    }
                    ++idx;
                }
                if (hs.size() != attributes.length) {
                    throw new IllegalArgumentException("The column names of attributes must be unique.");
                }
                input = new double[lines.size() - start][attributes.length - 1];
                if (discretes == 0) {
                    lst = null;
                    indexes = null;
                } else {
                    lst = new ArrayList(discretes);
                    for (int i = 0; i < discretes; ++i) {
                        lst.add(new HashMap());
                    }
                    indexes = new int[discretes];
                }
                for (int i = start; i < lines.size(); ++i) {
                    int idxAtt = 0;
                    String[] temp = ((String)lines.get(i)).split(String.valueOf(','));
                    idx = 0;
                    for (int j = 0; j < attributes.length; ++j) {
                        if (j == classIndex) continue;
                        if (attributes[j].type == DecisionVariable.Type.Continuous) {
                            double value = temp[j].equals("?") ? Double.NaN : Double.valueOf(DatasetClassification.fix(temp[j]));
                            input[i - start][idx++] = value;
                            continue;
                        }
                        HashMap map = (HashMap)lst.get(idxAtt);
                        if (temp[j].equals("?")) {
                            input[i - start][idx++] = Double.NaN;
                            ++idxAtt;
                            continue;
                        }
                        if (!map.containsKey(temp[j])) {
                            int n = idxAtt;
                            int n2 = indexes[n];
                            indexes[n] = n2 + 1;
                            map.put(temp[j], n2);
                        }
                        ++idxAtt;
                        input[i - start][idx++] = ((Integer)map.get(temp[j])).intValue();
                    }
                }
                output = new int[lines.size() - start];
                idx = 0;
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                for (int j = start; j < lines.size(); ++j) {
                    String[] temp = ((String)lines.get(j)).split(String.valueOf(","));
                    String s = temp[classIndex];
                    if (!map.containsKey(s)) {
                        map.put(s, idx++);
                        output[j - start] = map.get(s);
                        ++numClasses;
                        continue;
                    }
                    output[j - start] = map.get(s);
                }
                codebook = new Codebook(map);
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(DatasetClassification.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(DatasetClassification.class.getName()).log(Level.SEVERE, null, ex);
        }
        return new DatasetClassification(name, attributes, input, output, numClasses, continuous, classIndex, codebook);
    }

    public double[][] getInput(int label) {
        ArrayList<Integer> lst = new ArrayList<Integer>();
        for (int i = 0; i < this.output.length; ++i) {
            if (this.output[i] != label) continue;
            lst.add(i);
        }
        int[] v = new int[lst.size()];
        for (int i = 0; i < v.length; ++i) {
            v[i] = (Integer)lst.get(i);
        }
        double[][] data = Matrix.getRows(this.input, v);
        return data;
    }

    private static String fix(String x) {
        String r = "";
        for (int i = 0; i < x.length(); ++i) {
            char c = x.charAt(i);
            if (!Character.isDigit(c) && c != '.' && c != '-' && c != 'E') continue;
            r = r + c;
        }
        return r;
    }

    public DatasetClassification(String filepath) {
        this(filepath, "Unknown");
    }

    public DatasetClassification(String filepath, String name) {
        this(filepath, name, false);
    }

    public DatasetClassification(String filepath, String name, boolean ignoreAttributeInfo) {
        this(filepath, name, ignoreAttributeInfo, -1);
    }

    public DatasetClassification(String filepath, String name, boolean ignoreAttributeInfo, int classIndex) {
        DatasetClassification dataset = DatasetClassification.FromCSV(filepath, name, ignoreAttributeInfo, classIndex);
        this.name = dataset.getName();
        this.attributes = dataset.getDecisionVariables();
        this.continuous = dataset.getNumberOfContinuous();
        this.input = dataset.getInput();
        this.output = dataset.getOutput();
        this.numClasses = dataset.getNumberOfClasses();
        this.classIndex = dataset.getClassIndex();
        this.codebook = dataset.getCodebook();
    }

    public DatasetClassification(String name, double[][] input, int[] output) {
        this(name, input, output, null);
    }

    public DatasetClassification(String name, double[][] input, int[] output, DecisionVariable[] attributes) {
        this(name, input, output, attributes, input[0].length);
    }

    public DatasetClassification(String name, double[][] input, int[] output, DecisionVariable[] attributes, int classIndex) {
        this.name = name;
        this.input = input;
        this.output = output;
        this.numClasses = Matrix.Max(output) + 1;
        this.classIndex = classIndex;
        if (attributes == null) {
            attributes = new DecisionVariable[input[0].length];
            for (int i = 0; i < attributes.length; ++i) {
                attributes[i] = new DecisionVariable("F" + i);
            }
        }
        int c = 0;
        for (int i = 0; i < attributes.length; ++i) {
            if (attributes[i].type != DecisionVariable.Type.Continuous) continue;
            ++c;
        }
        this.attributes = attributes;
        this.continuous = c;
    }

    private DatasetClassification(String name, DecisionVariable[] attributes, double[][] input, int[] output, int numClasses, int continuous, int classIndex) {
        this.name = name;
        this.attributes = attributes;
        this.input = input;
        this.output = output;
        this.numClasses = numClasses;
        this.continuous = continuous;
        this.classIndex = classIndex;
    }

    private DatasetClassification(String name, DecisionVariable[] attributes, double[][] input, int[] output, int numClasses, int continuous, int classIndex, Codebook codebook) {
        this.name = name;
        this.attributes = attributes;
        this.input = input;
        this.output = output;
        this.numClasses = numClasses;
        this.continuous = continuous;
        this.classIndex = classIndex;
        this.codebook = codebook;
    }

    public void Imputation(IImputation filter) {
        filter.ApplyInPlace(this);
    }

    public void Normalize() {
        this.Normalize(0.0, 1.0);
    }

    public void Normalize(double min, double max) {
        this.Normalize(new Normalization(min, max));
    }

    public void Normalize(IFeatureScaling normalization) {
        this.normalization = normalization;
        normalization.ApplyInPlace(this.getDecisionVariables(), this.input);
    }

    public void RemoveAttribute(int index) {
        this.input = Matrix.RemoveColumn(this.input, index);
        this.attributes = Matrix.RemoveColumn(this.attributes, index);
    }

    public void RemoveAttribute(int[] indexes) {
        this.input = Matrix.RemoveColumns(this.input, indexes);
        this.attributes = Matrix.RemoveColumns(this.attributes, indexes);
    }

    public void KeepAttributes(int[] indexes) {
        this.input = Matrix.getColumns(this.input, indexes);
        this.attributes = Matrix.getColumns(this.attributes, indexes);
    }

    public void RemoveClass(int id) {
        --this.numClasses;
        ArrayList<Integer> lst = new ArrayList<Integer>();
        for (int i = 0; i < this.output.length; ++i) {
            if (this.output[i] != id) continue;
            lst.add(i);
        }
        int[] v = new int[lst.size()];
        for (int i = 0; i < lst.size(); ++i) {
            v[i] = (Integer)lst.get(i);
        }
        this.input = Matrix.RemoveRows(this.input, v);
        this.output = Matrix.RemoveColumns(this.output, v);
        int[] uniques = Tools.Unique(this.output);
        for (int i = 0; i < uniques.length; ++i) {
            int el = uniques[i];
            for (int j = 0; j < this.output.length; ++j) {
                if (this.output[j] != el) continue;
                this.output[j] = i;
            }
        }
    }

    public void RemoveMissingInstances() {
        ArrayList<Integer> lst = new ArrayList<Integer>();
        for (int i = 0; i < this.input.length; ++i) {
            boolean isMissing = false;
            for (int j = 0; j < this.input[0].length; ++j) {
                if (this.input[i][j] != Double.NaN) continue;
                isMissing = true;
            }
            if (!isMissing) continue;
            lst.add(i);
        }
        int[] v = new int[lst.size()];
        for (int i = 0; i < v.length; ++i) {
            v[i] = (Integer)lst.get(i);
        }
        this.input = Matrix.RemoveRows(this.input, v);
        this.output = Matrix.RemoveColumns(this.output, v);
    }

    public DatasetClassification Split(float percentage) {
        return this.Split(percentage, this.name + "_Validation");
    }

    public DatasetClassification Split(float percentage, String name) {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (int i = 0; i < this.output.length; ++i) {
            if (!map.containsKey(this.output[i])) {
                map.put(this.output[i], 1);
                continue;
            }
            int t = (Integer)map.get(this.output[i]) + 1;
            map.put(this.output[i], t);
        }
        int[] sizeClass = new int[map.size()];
        for (Map.Entry entry : map.entrySet()) {
            sizeClass[((Integer)entry.getKey()).intValue()] = (int)((float)((Integer)entry.getValue()).intValue() * percentage);
        }
        int size = 0;
        for (int i = 0; i < sizeClass.length; ++i) {
            size += sizeClass[i];
        }
        int[] indexTraining = new int[size];
        int[] indexValidation = new int[this.input.length - size];
        int idxT = 0;
        int idxV = 0;
        for (int i = 0; i < this.input.length; ++i) {
            if (sizeClass[this.output[i]] > 0) {
                indexTraining[idxT++] = i;
                int n = this.output[i];
                sizeClass[n] = sizeClass[n] - 1;
                continue;
            }
            indexValidation[idxV++] = i;
        }
        double[][] valInput = Matrix.getRows(this.input, indexValidation);
        int[] valOutput = Matrix.getRows(this.output, indexValidation);
        this.input = Matrix.getRows(this.input, indexTraining);
        this.output = Matrix.getRows(this.output, indexTraining);
        return new DatasetClassification(name, valInput, valOutput, this.attributes);
    }

    public void Shuffle() {
        this.Shuffle(0L);
    }

    public void Shuffle(long seed) {
        int[] idx = Matrix.Indices(0, this.output.length);
        ArraysUtil.Shuffle(idx, seed);
        for (int j = 0; j < this.input[0].length; ++j) {
            double[] col = Matrix.getColumn(this.input, j);
            for (int i = 0; i < col.length; ++i) {
                this.input[i][j] = col[idx[i]];
            }
        }
        int[] copy = (int[])this.output.clone();
        for (int i = 0; i < this.output.length; ++i) {
            this.output[i] = copy[idx[i]];
        }
    }

    public void Sort() {
        int[] idx = ArraysUtil.Argsort(this.output, true);
        for (int j = 0; j < this.input[0].length; ++j) {
            double[] col = Matrix.getColumn(this.input, j);
            for (int i = 0; i < col.length; ++i) {
                this.input[i][j] = col[idx[i]];
            }
        }
        int[] copy = (int[])this.output.clone();
        for (int i = 0; i < this.output.length; ++i) {
            this.output[i] = copy[idx[i]];
        }
    }

    public void Standartize() {
        this.Normalize(new Standartization());
    }

    @Override
    public StatisticsDataset[] getStatistics() {
        int continuous = 0;
        for (int i = 0; i < this.attributes.length; ++i) {
            if (this.attributes[i].type != DecisionVariable.Type.Continuous) continue;
            ++continuous;
        }
        StatisticsDataset[] stat = new StatisticsDataset[continuous];
        int idx = 0;
        for (int i = 0; i < this.attributes.length; ++i) {
            if (this.attributes[i].type != DecisionVariable.Type.Continuous) continue;
            boolean isMissing = false;
            double[] temp = Matrix.getColumn(this.input, i);
            ArrayList<Integer> lst = new ArrayList<Integer>();
            for (int j = 0; j < temp.length; ++j) {
                if (temp[i] != Double.NaN) continue;
                isMissing = true;
                lst.add(j);
            }
            int[] v = new int[lst.size()];
            for (int j = 0; j < v.length; ++j) {
                v[j] = (Integer)lst.get(j);
            }
            temp = Matrix.RemoveColumns(temp, v);
            double mean = DescriptiveStatistics.Mean(temp);
            double median = DescriptiveStatistics.Median(temp);
            double min = DescriptiveStatistics.Minimum(temp);
            double max = DescriptiveStatistics.Maximum(temp);
            double std = DescriptiveStatistics.StandartDeviation(temp, mean);
            double kurtosis = DescriptiveStatistics.Kurtosis(temp, mean, std);
            double skewness = DescriptiveStatistics.Skewness(temp, mean, std);
            stat[idx++] = new StatisticsDataset(this.attributes[i].name, mean, median, min, max, std, skewness, kurtosis, isMissing);
        }
        return stat;
    }

    public void WriteAsCSV(String filename) {
        this.WriteAsCSV(filename, -1, ',', System.getProperty("line.separator"));
    }

    public void WriteAsCSV(String filename, int decimalPlaces) {
        this.WriteAsCSV(filename, decimalPlaces, ',', System.getProperty("line.separator"));
    }

    public void WriteAsCSV(String filename, int decimalPlaces, char delimiter) {
        this.WriteAsCSV(filename, decimalPlaces, delimiter, System.getProperty("line.separator"));
    }

    public void WriteAsCSV(String filename, int decimalPlaces, char delimiter, String newLine) {
        this.WriteAsCSV(filename, decimalPlaces, delimiter, System.getProperty("line.separator"), true);
    }

    public void WriteAsCSV(String filename, int decimalPlaces, char delimiter, String newLine, boolean writeHeader) {
        try {
            int i;
            String dec = "%." + decimalPlaces + "f";
            FileWriter fw = new FileWriter(filename);
            if (this.classIndex < 0) {
                this.classIndex = this.attributes.length - 1;
            }
            if (writeHeader) {
                for (i = 0; i < this.attributes.length; ++i) {
                    if (i == this.classIndex) continue;
                    fw.append(this.attributes[i].name + delimiter);
                }
                fw.append(this.attributes[this.classIndex].name);
                fw.append(newLine);
            }
            for (i = 0; i < this.input.length; ++i) {
                for (int j = 0; j < this.input[0].length; ++j) {
                    if (this.attributes[j].type == DecisionVariable.Type.Continuous) {
                        if (decimalPlaces >= 0) {
                            fw.append(String.format(Locale.US, dec, this.input[i][j]) + delimiter);
                            continue;
                        }
                        fw.append(String.valueOf(this.input[i][j]) + delimiter);
                        continue;
                    }
                    fw.append(String.valueOf(this.input[i][j]) + delimiter);
                }
                fw.append(String.valueOf(this.output[i]) + newLine);
            }
            fw.flush();
            fw.close();
        }
        catch (IOException ex) {
            Logger.getLogger(DatasetClassification.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void WriteAsARFF(String filename) {
        this.WriteAsARFF(filename, -1);
    }

    public void WriteAsARFF(String filename, int decimalPlaces) {
        try {
            int j;
            String dec = "%." + decimalPlaces + "f";
            String newLine = System.getProperty("line.separator");
            char delimiter = ',';
            FileWriter fw = new FileWriter(filename);
            fw.append("@RELATION " + this.name);
            fw.append(newLine + newLine);
            for (int i = 0; i < this.attributes.length; ++i) {
                if (i == this.classIndex) continue;
                if (this.attributes[i].type == DecisionVariable.Type.Continuous) {
                    fw.append("@ATTRIBUTE " + this.attributes[i].name.replace(" ", "_") + " NUMERIC");
                    fw.append(newLine);
                    continue;
                }
                String nominal = "{";
                int max = (int)Matrix.Max(Matrix.getColumn(this.input, i));
                for (j = 0; j < max; ++j) {
                    nominal = nominal + j + ", ";
                }
                nominal = nominal + max + "}";
                fw.append("@ATTRIBUTE " + this.attributes[i].name.replace(" ", "_") + nominal);
                fw.append(newLine);
            }
            String nominal = "{";
            int max = Matrix.Max(this.output);
            for (int j2 = 0; j2 < max; ++j2) {
                nominal = nominal + j2 + ", ";
            }
            nominal = nominal + max + "}";
            fw.append("@ATTRIBUTE " + this.attributes[this.classIndex].name + " " + nominal);
            fw.append(newLine);
            fw.append(newLine);
            fw.append("@DATA" + newLine);
            for (int i = 0; i < this.input.length; ++i) {
                for (j = 0; j < this.input[0].length; ++j) {
                    if (decimalPlaces >= 0) {
                        fw.append(String.format(Locale.US, dec, this.input[i][j]) + delimiter);
                        continue;
                    }
                    fw.append(String.valueOf(this.input[i][j]) + delimiter);
                }
                fw.append(String.valueOf(this.output[i]) + newLine);
            }
            fw.flush();
            fw.close();
        }
        catch (IOException ex) {
            Logger.getLogger(DatasetClassification.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

