/*
 * Decompiled with CFR 0.152.
 */
package Catalano.MachineLearning.Classification;

import Catalano.MachineLearning.Classification.IClassifier;
import Catalano.MachineLearning.Classification.SVM;
import Catalano.MachineLearning.Dataset.DatasetClassification;
import Catalano.Statistics.Kernels.IMercerKernel;
import java.io.Serializable;

public class MulticlassSupportVectorMachine
implements IClassifier,
Serializable {
    private IMercerKernel kernel;
    private double c;
    private int numberOfClasses;
    private SVM.Strategy strategy;
    private SVM<double[]> svm;

    public MulticlassSupportVectorMachine(IMercerKernel kernel, double c, int numberOfClasses) {
        this(kernel, c, numberOfClasses, SVM.Strategy.ONE_VS_ONE);
    }

    public MulticlassSupportVectorMachine(IMercerKernel kernel, double c, int numberOfClasses, SVM.Strategy strategy) {
        this.kernel = kernel;
        this.c = c;
        this.numberOfClasses = numberOfClasses;
        this.strategy = strategy;
        this.Initialize(kernel, c, numberOfClasses, strategy);
    }

    public MulticlassSupportVectorMachine(IMercerKernel kernel, double c, double[] weight) {
        this(kernel, c, weight, SVM.Strategy.ONE_VS_ONE);
    }

    public MulticlassSupportVectorMachine(IMercerKernel kernel, double c, double[] weight, SVM.Strategy strategy) {
        this.kernel = kernel;
        this.c = c;
        this.numberOfClasses = weight.length;
        this.strategy = strategy;
        this.Initialize(kernel, c, weight, strategy);
    }

    private void Initialize(IMercerKernel kernel, double c, int nClasses, SVM.Strategy strategy) {
        this.svm = new SVM(kernel, c, nClasses, strategy);
    }

    private void Initialize(IMercerKernel kernel, double c, double[] weight, SVM.Strategy strategy) {
        this.svm = new SVM(kernel, c, weight, strategy);
    }

    @Override
    public void Learn(DatasetClassification dataset) {
        this.Learn(dataset.getInput(), dataset.getOutput());
    }

    @Override
    public void Learn(double[][] input, int[] output) {
        this.Initialize(this.kernel, this.c, this.numberOfClasses, this.strategy);
        this.svm.Learn((T[])input, output);
    }

    public void Learn(double[] input, int output) {
        this.svm.Learn(input, output);
    }

    @Override
    public int Predict(double[] feature) {
        return this.svm.Predict(feature);
    }

    @Override
    public IClassifier clone() {
        try {
            return (IClassifier)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalArgumentException("Clone not supported: " + ex.getMessage());
        }
    }

    public void Finish() {
        this.svm.Finish();
    }
}

