/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Tools;

import Catalano.Core.DoublePoint;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Tools.ImageMoments;

public class SukFlusserMoments {
    private boolean normalize;

    public boolean isNormalize() {
        return this.normalize;
    }

    public void setNormalize(boolean normalize) {
        this.normalize = normalize;
    }

    public SukFlusserMoments() {
        this(false);
    }

    public SukFlusserMoments(boolean normalize) {
        this.normalize = normalize;
    }

    public double[] Compute(FastBitmap fastBitmap) {
        if (fastBitmap.isGrayscale()) {
            double m00 = ImageMoments.getRawMoment(fastBitmap, 0, 0);
            DoublePoint centroid = ImageMoments.getCentroid(fastBitmap, m00);
            double m20 = ImageMoments.getCentralMoment(fastBitmap, 2, 0, centroid);
            double m02 = ImageMoments.getCentralMoment(fastBitmap, 0, 2, centroid);
            double m11 = ImageMoments.getCentralMoment(fastBitmap, 1, 1, centroid);
            double m30 = ImageMoments.getCentralMoment(fastBitmap, 3, 0, centroid);
            double m03 = ImageMoments.getCentralMoment(fastBitmap, 0, 3, centroid);
            double m21 = ImageMoments.getCentralMoment(fastBitmap, 2, 1, centroid);
            double m12 = ImageMoments.getCentralMoment(fastBitmap, 1, 2, centroid);
            double m40 = ImageMoments.getCentralMoment(fastBitmap, 4, 0, centroid);
            double m04 = ImageMoments.getCentralMoment(fastBitmap, 0, 4, centroid);
            double m31 = ImageMoments.getCentralMoment(fastBitmap, 3, 1, centroid);
            double m13 = ImageMoments.getCentralMoment(fastBitmap, 1, 3, centroid);
            double m22 = ImageMoments.getCentralMoment(fastBitmap, 2, 2, centroid);
            double m50 = ImageMoments.getCentralMoment(fastBitmap, 5, 0, centroid);
            double m05 = ImageMoments.getCentralMoment(fastBitmap, 0, 5, centroid);
            double m41 = ImageMoments.getCentralMoment(fastBitmap, 4, 1, centroid);
            double m14 = ImageMoments.getCentralMoment(fastBitmap, 1, 4, centroid);
            double m32 = ImageMoments.getCentralMoment(fastBitmap, 3, 2, centroid);
            double m23 = ImageMoments.getCentralMoment(fastBitmap, 2, 3, centroid);
            double m70 = ImageMoments.getCentralMoment(fastBitmap, 7, 0, centroid);
            double m07 = ImageMoments.getCentralMoment(fastBitmap, 0, 7, centroid);
            double m16 = ImageMoments.getCentralMoment(fastBitmap, 1, 6, centroid);
            double m61 = ImageMoments.getCentralMoment(fastBitmap, 6, 1, centroid);
            double m52 = ImageMoments.getCentralMoment(fastBitmap, 5, 2, centroid);
            double m25 = ImageMoments.getCentralMoment(fastBitmap, 2, 5, centroid);
            double m43 = ImageMoments.getCentralMoment(fastBitmap, 4, 3, centroid);
            double m34 = ImageMoments.getCentralMoment(fastBitmap, 3, 4, centroid);
            m50 -= 10.0 * m30 * m20 / m00;
            m41 -= 2.0 * (3.0 * m21 * m20 + 2.0 * m30 * m11) / m00;
            m32 -= (3.0 * m12 * m20 + m30 * m02 + 6.0 * m21 * m11) / m00;
            m23 -= (3.0 * m21 * m02 + m03 * m20 + 6.0 * m12 * m11) / m00;
            m14 -= 2.0 * (3.0 * m12 * m02 + 2.0 * m03 * m11) / m00;
            m05 -= 10.0 * m03 * m02 / m00;
            m70 = m70 - 7.0 * (3.0 * m50 * m20 + 5.0 * m30 * m40) / m00 + 210.0 * m30 * (m20 * m20) / (m00 * m00);
            m61 = m61 - (6.0 * m50 * m11 + 15.0 * m41 * m20 + 15.0 * m40 * m21 + 20.0 * m31 * m30) / m00 + 30.0 * (3.0 * m21 * (m20 * m20) + 4.0 * m30 * m20 * m11) / (m00 * m00);
            m52 = m52 - (m50 * m02 + 10.0 * m30 * m22 + 10.0 * m32 * m20 + 20.0 * m31 * m21 + 10.0 * m41 * m11 + 5.0 * m40 * m12) / m00 + 10.0 * (3.0 * m12 * (m20 * m20) + 2.0 * m30 * m20 * m02 + 4.0 * m30 * (m11 * m11) + 12.0 * m21 * m20 * m11) / (m00 * m00);
            m43 = m43 - (m40 * m03 + 18.0 * m21 * m22 + 12.0 * m31 * m12 + 4.0 * m30 * m13 + 3.0 * m41 * m02 + 12.0 * m32 * m11 + 6.0 * m23 * m20) / m00 + 6.0 * (m03 * (m20 * m20) + 4.0 * m30 * m11 * m02 + 12.0 * m21 * (m11 * m11) + 12.0 * m12 * m20 * m11 + 6.0 * m21 * m02 * m20);
            m34 = m34 - (m04 * m30 + 18.0 * m12 * m22 + 12.0 * m13 * m21 + 4.0 * m03 * m31 + 3.0 * m14 * m20 + 12.0 * m23 * m11 + 6.0 * m32 * m02) / m00 + 6.0 * (m30 * (m02 * m02) + 4.0 * m03 * m11 * m20 + 12.0 * m12 * (m11 * m11) + 12.0 * m21 * m02 * m11 + 6.0 * m12 * m20 * m02) / (m00 * m00);
            m25 = m25 - (m05 * m20 + 10.0 * m03 * m22 + 10.0 * m23 * m02 + 20.0 * m13 * m12 + 10.0 * m14 * m11 + 5.0 * m04 * m21) / m00 + 10.0 * (3.0 * m21 * (m02 * m02) + 2.0 * m03 * m02 * m20 + 4.0 * m03 * (m11 * m11) + 12.0 * m12 * m02 * m11) / (m00 * m00);
            m16 = m16 - (6.0 * m05 * m11 + 15.0 * m14 * m02 + 15.0 * m04 * m12 + 20.0 * m13 * m03) / m00 + 30.0 * (3.0 * m12 * (m02 * m02) + 4.0 * m03 * m02 * m11) / (m00 * m00);
            m07 = m07 - 7.0 * (3.0 * m05 * m02 + 5.0 * m03 * m04) / m00 + 210.0 * m03 * (m02 * m02) / (m00 * m00);
            double I1 = (m30 * m30 * (m03 * m03) - 6.0 * m30 * m21 * m12 * m03 + 4.0 * m30 * (m12 * m12 * m12) + 4.0 * (m21 * m21 * m21) * m03 - 3.0 * (m21 * m21) * (m12 * m12)) / Math.pow(m00, 10.0);
            double I2 = (m50 * m50 * (m05 * m05) - 10.0 * m50 * m41 * m14 * m05 + 4.0 * m50 * m32 * m23 * m05 + 16.0 * m50 * m32 * (m14 * m14) - 12.0 * m50 * (m23 * m23) * m14 + 16.0 * (m41 * m41) * m23 * m05 + 9.0 * (m41 * m41) * (m14 * m14) - 12.0 * m41 * (m32 * m32) * m05 - 76.0 * m41 * m32 * m23 * m14 + 48.0 * m41 * (m23 * m23 * m23) + 48.0 * (m32 * m32 * m32) * m14 - 32.0 * (m32 * m32) * (m23 * m23)) / Math.pow(m00, 14.0);
            double I3 = (m30 * m30 * m12 * m05 - m30 * m30 * m03 * m14 - m30 * (m21 * m21) * m05 - 2.0 * m30 * m21 * m12 * m14 + 4.0 * m30 * m21 * m03 * m23 + 2.0 * m30 * (m12 * m12) * m23 - 4.0 * m30 * m12 * m03 * m32 + m30 * (m03 * m03) * m41 + 3.0 * (m21 * m21 * m21) * m14 - 6.0 * (m21 * m21) * m12 * m23 - 2.0 * (m21 * m21) * m03 * m32 + 6.0 * m21 * (m12 * m12) * m32 + 2.0 * m21 * m12 * m03 * m41 - m21 * (m03 * m03) * m50 - 3.0 * (m12 * m12 * m12) * m41 + m12 * m12 * m03 * m50) / Math.pow(m00, 11.0);
            double I4 = (2.0 * m30 * m12 * m41 * m05 - 8.0 * m30 * m12 * m32 * m14 + 6.0 * m30 * m12 * (m23 * m23) - m30 * m03 * m50 * m05 + 3.0 * m30 * m03 * m41 * m14 - 2.0 * m30 * m03 * m32 * m23 - 2.0 * (m21 * m21) * m41 * m05 + 8.0 * (m21 * m21) * m32 * m14 - 6.0 * (m21 * m21) * (m23 * m23) + m21 * m12 * m50 * m05 - 3.0 * m21 * m12 * m41 * m14 + 2.0 * m21 * m12 * m32 * m23 + 2.0 * m21 * m03 * m50 * m14 - 8.0 * m21 * m03 * m41 * m23 + 6.0 * m21 * m03 * (m32 * m32) - 2.0 * (m12 * m12) * m50 * m14 + 8.0 * (m12 * m12) * m41 * m23 - 6.0 * (m12 * m12) * (m32 * m32)) / Math.pow(m00, 12.0);
            double I5 = (m30 * m41 * m23 * m05 - m30 * m41 * (m14 * m14) - m30 * (m32 * m32) * m05 + 2.0 * m30 * m32 * m23 * m14 - m30 * (m23 * m23 * m23) - m21 * m50 * m23 * m05 + m21 * m50 * (m14 * m14) + m21 * m41 * m32 * m05 - m21 * m41 * m23 * m14 - m21 * (m32 * m32) * m14 + m21 * m32 * (m23 * m23) + m12 * m50 * m32 * m05 - m12 * m50 * m23 * m14 - m12 * (m41 * m41) * m05 + m12 * m41 * m32 * m14 + m12 * m41 * (m23 * m23) - m12 * (m32 * m32) * m23 - m03 * m50 * m32 * m14 + m03 * m50 * (m23 * m23) + m03 * (m41 * m41) * m14 - 2.0 * m03 * m41 * m32 * m23 + m03 * (m32 * m32 * m32)) / Math.pow(m00, 13.0);
            double I6 = (m70 * m70 * (m07 * m07) - 14.0 * m70 * m61 * m16 * m07 + 18.0 * m70 * m52 * m25 * m07 + 24.0 * m70 * m52 * (m16 * m16) - 10.0 * m70 * m43 * m34 * m07 - 60.0 * m70 * m43 * m25 * m16 + 40.0 * m70 * (m34 * m34) * m16 + 24.0 * (m61 * m61) * m25 * m07 + 25.0 * (m61 * m61) * (m16 * m16) - 60.0 * m61 * m52 * m34 * m07 - 234.0 * m61 * m52 * m25 * m16 + 40.0 * m61 * (m43 * m43) * m07 + 50.0 * m61 * m43 * m34 * m16 + 360.0 * m61 * m43 * (m25 * m25) - 240.0 * m61 * (m34 * m34) * m25 + 360.0 * (m52 * m52) * m34 * m16 + 81.0 * (m52 * m52) * (m25 * m25) - 240.0 * m52 * (m43 * m43) * m16 - 990.0 * m52 * m43 * m34 * m25 + 600.0 * m52 * (m34 * m34 * m34) + 600.0 * (m43 * m43 * m43) * m25 - 375.0 * (m43 * m43) * (m34 * m34)) / Math.pow(m00, 18.0);
            double[] moments = new double[]{I1, I2, I3, I4, I5, I6};
            if (this.normalize) {
                for (int i = 0; i < moments.length; ++i) {
                    moments[i] = Math.signum(moments[i]) * Math.log10(Math.abs(moments[i]) + 1.0);
                }
            }
            return moments;
        }
        throw new IllegalArgumentException("Suk Flusser Moments only works with grayscale images.");
    }
}

