/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Tools;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Tools.ImageHistogram;
import java.util.Arrays;

public class MedianBinaryPattern {
    public ImageHistogram ProcessImage(FastBitmap fastBitmap) {
        if (!fastBitmap.isGrayscale()) {
            try {
                throw new Exception("MBP works only with grayscale images.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int width = fastBitmap.getWidth() - 1;
        int height = fastBitmap.getHeight() - 1;
        int[] g = new int[511];
        int[] values = new int[9];
        for (int x = 1; x < height; ++x) {
            for (int y = 1; y < width; ++y) {
                values[0] = fastBitmap.getGray(x - 1, y - 1);
                values[1] = fastBitmap.getGray(x - 1, y);
                values[2] = fastBitmap.getGray(x - 1, y + 1);
                values[3] = fastBitmap.getGray(x, y - 1);
                values[4] = fastBitmap.getGray(x, y);
                values[5] = fastBitmap.getGray(x, y + 1);
                values[6] = fastBitmap.getGray(x + 1, y - 1);
                values[7] = fastBitmap.getGray(x + 1, y);
                values[8] = fastBitmap.getGray(x + 1, y + 1);
                Arrays.sort(values);
                int median = values[4];
                int sum = 0;
                if (median < fastBitmap.getGray(x - 1, y - 1)) {
                    sum += 128;
                }
                if (median < fastBitmap.getGray(x - 1, y)) {
                    sum += 64;
                }
                if (median < fastBitmap.getGray(x - 1, y + 1)) {
                    sum += 32;
                }
                if (median < fastBitmap.getGray(x, y + 1)) {
                    sum += 16;
                }
                if (median < fastBitmap.getGray(x + 1, y + 1)) {
                    sum += 8;
                }
                if (median < fastBitmap.getGray(x + 1, y)) {
                    sum += 4;
                }
                if (median < fastBitmap.getGray(x + 1, y - 1)) {
                    sum += 2;
                }
                if (median < fastBitmap.getGray(x, y - 1)) {
                    ++sum;
                }
                if (median < fastBitmap.getGray(x, y)) {
                    sum += 256;
                }
                if (sum == 511) {
                    sum = 0;
                }
                int n = sum;
                g[n] = g[n] + 1;
            }
        }
        return new ImageHistogram(g);
    }
}

