/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Tools;

public class ColorDifference {
    private ColorDifference() {
    }

    public static double DeltaC(double[] cieLab1, double[] cieLab2) {
        double part1 = Math.sqrt(Math.pow(cieLab2[1], 2.0) + Math.pow(cieLab2[2], 2.0));
        double part2 = Math.sqrt(Math.pow(cieLab1[1], 2.0) + Math.pow(cieLab1[2], 2.0));
        return part1 - part2;
    }

    public static double DeltaH(double[] cieLab1, double[] cieLab2) {
        double xDE = ColorDifference.DeltaC(cieLab1, cieLab2);
        double part1 = Math.pow(cieLab2[1] - cieLab1[1], 2.0);
        double part2 = Math.pow(cieLab2[2] - cieLab1[2], 2.0);
        double result = part1 + part2 - xDE * xDE;
        return Math.sqrt(result);
    }

    public static double DeltaE(double[] cieLab1, double[] cieLab2) {
        double sum = 0.0;
        for (int i = 0; i < cieLab1.length; ++i) {
            sum += Math.pow(cieLab1[i] - cieLab2[i], 2.0);
        }
        return Math.sqrt(sum);
    }

    public static double CIEDE2000(double[] cieLab1, double[] cieLab2) {
        return ColorDifference.CIEDE2000(cieLab1[0], cieLab1[1], cieLab1[2], cieLab2[0], cieLab2[1], cieLab2[2]);
    }

    public static double CIEDE2000(double l1, double a1, double b1, double l2, double a2, double b2) {
        double C1 = Math.sqrt(a1 * a1 + b1 * b1);
        double C2 = Math.sqrt(a2 * a2 + b2 * b2);
        double lMean = (l1 + l2) / 2.0;
        double cMean = (C1 + C2) / 2.0;
        double G = (1.0 - Math.sqrt(Math.pow(cMean, 7.0) / (Math.pow(cMean, 7.0) + Math.pow(25.0, 7.0)))) / 2.0;
        double a1prime = a1 * (1.0 + G);
        double a2prime = a2 * (1.0 + G);
        double C1prime = Math.sqrt(a1prime * a1prime + b1 * b1);
        double C2prime = Math.sqrt(a2prime * a2prime + b2 * b2);
        double Cmeanprime = (C1prime + C2prime) / 2.0;
        double h1prime = Math.atan2(b1, a1prime) + Math.PI * 2 * (double)(Math.atan2(b1, a1prime) < 0.0 ? 1 : 0);
        double h2prime = Math.atan2(b2, a2prime) + Math.PI * 2 * (double)(Math.atan2(b2, a2prime) < 0.0 ? 1 : 0);
        double Hmeanprime = Math.abs(h1prime - h2prime) > Math.PI ? (h1prime + h2prime + Math.PI * 2) / 2.0 : (h1prime + h2prime) / 2.0;
        double T = 1.0 - 0.17 * Math.cos(Hmeanprime - 0.5235987755982988) + 0.24 * Math.cos(2.0 * Hmeanprime) + 0.32 * Math.cos(3.0 * Hmeanprime + 0.10471975511965977) - 0.2 * Math.cos(4.0 * Hmeanprime - 1.0995574287564276);
        double deltahprime = Math.abs(h1prime - h2prime) <= Math.PI ? h2prime - h1prime : (h2prime <= h1prime ? h2prime - h1prime + Math.PI * 2 : h2prime - h1prime - Math.PI * 2);
        double deltaLprime = l2 - l1;
        double deltaCprime = C2prime - C1prime;
        double deltaHprime = 2.0 * Math.sqrt(C1prime * C2prime) * Math.sin(deltahprime / 2.0);
        double SL = 1.0 + 0.015 * (lMean - 50.0) * (lMean - 50.0) / Math.sqrt(20.0 + (lMean - 50.0) * (lMean - 50.0));
        double SC = 1.0 + 0.045 * Cmeanprime;
        double SH = 1.0 + 0.015 * Cmeanprime * T;
        double deltaTheta = 0.5235987755982988 * Math.exp(-((57.29577951308232 * Hmeanprime - 275.0) / 25.0) * ((57.29577951308232 * Hmeanprime - 275.0) / 25.0));
        double RC = 2.0 * Math.sqrt(Math.pow(Cmeanprime, 7.0) / (Math.pow(Cmeanprime, 7.0) + Math.pow(25.0, 7.0)));
        double RT = -RC * Math.sin(2.0 * deltaTheta);
        double KL = 1.0;
        double KC = 1.0;
        double KH = 1.0;
        double deltaE = Math.sqrt(deltaLprime / (KL * SL) * (deltaLprime / (KL * SL)) + deltaCprime / (KC * SC) * (deltaCprime / (KC * SC)) + deltaHprime / (KH * SH) * (deltaHprime / (KH * SH)) + RT * (deltaCprime / (KC * SC)) * (deltaHprime / (KH * SH)));
        return deltaE;
    }

    public static double DeltaCMC(double[] cieLab1, double[] cieLab2, double wheightL, double wheightC) {
        double xc1 = Math.sqrt(cieLab1[1] * cieLab1[1] + cieLab1[2] * cieLab1[2]);
        double xc2 = Math.sqrt(cieLab2[1] * cieLab2[1] + cieLab2[2] * cieLab2[2]);
        double xc1_4 = xc1 * xc1 * xc1 * xc1;
        double xff = Math.sqrt(xc1_4 / (xc1_4 + 1900.0));
        double xh1 = ColorDifference.CieLab2Hue(cieLab1[1], cieLab1[2]);
        double xTT = xh1 < 164.0 || xh1 > 345.0 ? 0.36 + Math.abs(0.4 * Math.cos(35.0 + xh1)) : 0.56 + Math.abs(0.2 * Math.cos(168.0 + xh1));
        double xSL = cieLab1[0] < 16.0 ? 0.511 : 0.040975 * cieLab1[0] / (1.0 + 0.01765 * cieLab1[0]);
        double xSC = 0.0638 * xc1 / (1.0 + 0.0131 * xc1) + 0.638;
        double xSH = (xff * xTT + 1.0 - xff) * xSC;
        double xDH = Math.sqrt(Math.pow(cieLab2[1] - cieLab1[1], 2.0) + Math.pow(cieLab2[2] - cieLab1[2], 2.0) - Math.pow(xc2 - xc1, 2.0));
        xSL = (cieLab2[0] - cieLab1[0]) / wheightL * xSL;
        xSC = (xc2 - xc1) / wheightL * xSC;
        xSH = xDH / xSH;
        return Math.sqrt(xSL * xSL + xSC * xSC + xSH * xSH);
    }

    private static double CieLab2Hue(double a, double b) {
        if (a >= 0.0 && b == 0.0) {
            return 0.0;
        }
        if (a < 0.0 && b == 0.0) {
            return 180.0;
        }
        if (a == 0.0 && b > 0.0) {
            return 90.0;
        }
        if (a == 0.0 && b < 0.0) {
            return 270.0;
        }
        double var = 0.0;
        if (a > 0.0 && b > 0.0) {
            var = 0.0;
        }
        if (a < 0.0) {
            var = 180.0;
        }
        if (a > 0.0 && b < 0.0) {
            var = 360.0;
        }
        double atan = Math.atan2(b, a);
        return Math.toRadians(atan) + var;
    }
}

