/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Texture;

import Catalano.Core.IntPoint;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Filters.Convolution;

public class LawsTextureEnergy {
    public static final int[] Level = new int[]{1, 4, 6, 4, 1};
    public static final int[] Edges = new int[]{-1, -2, 0, 2, 1};
    public static final int[] Spots = new int[]{-1, 0, 2, 0, -1};
    public static final int[] Ripples = new int[]{1, -4, 6, -4, 1};
    public static final int[] Waves = new int[]{-1, 2, 0, -2, 1};
    private int[][] mask;
    private int[] vector1;
    private int[] vector2;
    private FastBitmap fb;

    public LawsTextureEnergy() {
    }

    public LawsTextureEnergy(int[] vector1, int[] vector2) {
        this.vector1 = vector1;
        this.vector2 = vector2;
    }

    public LawsTextureEnergy(int[][] mask) {
        this.mask = mask;
    }

    public int[] getVector1() {
        return this.vector1;
    }

    public void setVector1(int[] vector1) {
        this.vector1 = vector1;
    }

    public int[] getVector2() {
        return this.vector2;
    }

    public void setVector2(int[] vector2) {
        this.vector2 = vector2;
    }

    public void ProcessImage(FastBitmap fastBitmap) {
        if (fastBitmap.isGrayscale()) {
            this.fb = fastBitmap;
            this.mask = this.CreateMask(this.vector1, this.vector2);
            Convolution c = new Convolution(this.mask);
            c.applyInPlace(this.fb);
        }
    }

    public FastBitmap toFastBitmap() {
        return this.fb;
    }

    public long getTextureEnergyMap() {
        int width = this.fb.getWidth();
        int height = this.fb.getHeight();
        long energy = 0L;
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                energy += (long)this.fb.getGray(i, j);
            }
        }
        return energy;
    }

    public long getTextureEnergyMap(int x, int y, int width, int height) {
        long energy = 0L;
        for (int i = x; i < i + height; ++i) {
            for (int j = y; j < j + width; ++j) {
                energy += (long)this.fb.getGray(i, j);
            }
        }
        return energy;
    }

    public long getTextureEnergyMap(IntPoint point, int width, int height) {
        return this.getTextureEnergyMap(point.x, point.y, width, height);
    }

    private int[][] CreateMask(int[] vector1, int[] vector2) {
        this.mask = new int[vector1.length][vector2.length];
        for (int i = 0; i < vector1.length; ++i) {
            for (int j = 0; j < vector2.length; ++j) {
                this.mask[i][j] = vector1[i] * vector2[j];
            }
        }
        return this.mask;
    }
}

