/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Core.FloatRange;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;
import Catalano.Imaging.Tools.ColorConverter;

public class YCbCrFiltering
implements IApplyInPlace {
    private FloatRange yRange = new FloatRange(0.0f, 1.0f);
    private FloatRange cbRange = new FloatRange(-0.5f, 0.5f);
    private FloatRange crRange = new FloatRange(-0.5f, 0.5f);
    private float fillY = 0.0f;
    private float fillCb = 0.0f;
    private float fillCr = 0.0f;
    private boolean fillOutsideRange = true;
    private boolean updateY = true;
    private boolean updateCb = true;
    private boolean updateCr = true;

    public FloatRange getY() {
        return this.yRange;
    }

    public void setHue(FloatRange y) {
        this.yRange = y;
    }

    public FloatRange getCb() {
        return this.cbRange;
    }

    public void setCb(FloatRange cb) {
        this.cbRange = cb;
    }

    public FloatRange getCr() {
        return this.crRange;
    }

    public void setCr(FloatRange cr) {
        this.crRange = cr;
    }

    public float[] getFillColor() {
        return new float[]{this.fillY, this.fillCb, this.fillCr};
    }

    public void setFillColor(float y, float cb, float cr) {
        this.fillY = y;
        this.fillCb = cb;
        this.fillCr = cr;
    }

    public boolean isFillOutsideRange() {
        return this.fillOutsideRange;
    }

    public void setFillOutsideRange(boolean fillOutsideRange) {
        this.fillOutsideRange = fillOutsideRange;
    }

    public boolean isUpdatedY() {
        return this.updateY;
    }

    public void setUpdateY(boolean update) {
        this.updateY = update;
    }

    public boolean isUpdatedCb() {
        return this.updateCb;
    }

    public void setUpdateCb(boolean update) {
        this.updateCb = update;
    }

    public boolean isUpdatedCr() {
        return this.updateCr;
    }

    public void setUpdateCr(boolean update) {
        this.updateCr = update;
    }

    public YCbCrFiltering() {
    }

    public YCbCrFiltering(FloatRange y, FloatRange cb, FloatRange cr) {
        this.yRange = y;
        this.cbRange = cb;
        this.crRange = cr;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (fastBitmap.isRGB()) {
            int size = fastBitmap.getSize();
            for (int i = 0; i < size; ++i) {
                int b;
                int g;
                boolean updated = false;
                int r = fastBitmap.getRed(i);
                double[] ycbcr = ColorConverter.RGBtoYCbCr(r, g = fastBitmap.getGreen(i), b = fastBitmap.getBlue(i), ColorConverter.YCbCrColorSpace.ITU_BT_601);
                if (ycbcr[0] >= (double)this.yRange.getMin() && ycbcr[0] <= (double)this.yRange.getMax() && ycbcr[1] >= (double)this.cbRange.getMin() && ycbcr[1] <= (double)this.cbRange.getMax() && ycbcr[2] >= (double)this.crRange.getMin() && ycbcr[2] <= (double)this.crRange.getMax()) {
                    if (!this.fillOutsideRange) {
                        if (this.updateY) {
                            ycbcr[0] = this.fillY;
                        }
                        if (this.updateCb) {
                            ycbcr[1] = this.fillCb;
                        }
                        if (this.updateCr) {
                            ycbcr[2] = this.fillCr;
                        }
                        updated = true;
                    }
                } else if (this.fillOutsideRange) {
                    if (this.updateY) {
                        ycbcr[0] = this.fillY;
                    }
                    if (this.updateCb) {
                        ycbcr[1] = this.fillCb;
                    }
                    if (this.updateCr) {
                        ycbcr[2] = this.fillCr;
                    }
                    updated = true;
                }
                if (!updated) continue;
                int[] rgb = ColorConverter.YCbCrtoRGB(ycbcr[0], ycbcr[1], ycbcr[2], ColorConverter.YCbCrColorSpace.ITU_BT_601);
                fastBitmap.setRGB(i, rgb);
            }
        } else {
            throw new IllegalArgumentException("HSL Filtering only works in RGB images.");
        }
    }
}

