/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Filters.Threshold;
import Catalano.Imaging.IApplyInPlace;
import Catalano.Imaging.Tools.ImageHistogram;
import Catalano.Imaging.Tools.ImageStatistics;
import Catalano.Math.Distances.Distance;
import Catalano.Math.Matrix;

public class RosinThreshold
implements IApplyInPlace {
    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (!fastBitmap.isGrayscale()) {
            throw new IllegalArgumentException("Rosin Threshold only works in grayscale images.");
        }
        int value = this.CalculateThreshold(fastBitmap);
        Threshold t = new Threshold(value);
        t.applyInPlace(fastBitmap);
    }

    public int CalculateThreshold(FastBitmap fastBitmap) {
        if (fastBitmap.isGrayscale()) {
            int lastIndex;
            ImageStatistics stat = new ImageStatistics(fastBitmap);
            ImageHistogram hist = stat.getHistogramGray();
            int[] values = hist.getValues();
            int maxIndex = Matrix.MaxIndex(values);
            int maxValue = values[maxIndex];
            for (int i = lastIndex = maxIndex; i < values.length; ++i) {
                if (values[i] <= 0) continue;
                lastIndex = i;
            }
            int lastValue = values[lastIndex];
            double d = Distance.Euclidean(maxIndex, maxValue, lastIndex, lastValue);
            int threshold = lastIndex;
            if (d != 0.0) {
                double t = -1.0;
                for (int i = maxIndex; i < lastIndex; ++i) {
                    int tempIndex = i;
                    int tempVal = values[i];
                    double p = (lastIndex - maxIndex) * (maxValue - tempVal) - (maxIndex - tempIndex) * (lastValue - maxValue);
                    if (!((p /= d) > t) || values[i] <= 0) continue;
                    t = (int)p;
                    threshold = i;
                }
            }
            return threshold;
        }
        throw new IllegalArgumentException("Rosin Threshold only works in grayscale images.");
    }
}

