/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters.Photometric;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Filters.Photometric.IPhotometricFilter;
import Catalano.Imaging.Filters.Photometric.SingleScaleRetinex;
import Catalano.Imaging.Tools.ImageUtils;
import Catalano.Math.Matrix;

public class MultiscaleRetinex
implements IPhotometricFilter {
    private int[] scales;

    public int[] getScales() {
        return this.scales;
    }

    public void setScales(int[] scales) {
        this.scales = scales;
    }

    public MultiscaleRetinex() {
        this(new int[]{7, 15, 21});
    }

    public MultiscaleRetinex(int[] scales) {
        this.scales = scales;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        double[][] image = fastBitmap.toMatrixGrayAsDouble();
        double[][] r = this.Process(image, true);
        fastBitmap.matrixToImage(r);
    }

    public double[][] Process(double[][] image, boolean normalize) {
        SingleScaleRetinex ssr = new SingleScaleRetinex(this.scales[0]);
        double[][] r = ssr.Process(image, normalize);
        for (int i = 1; i < this.scales.length; ++i) {
            ssr.setScale(this.scales[i]);
            Matrix.Add(r, ssr.Process(image, normalize));
        }
        if (normalize) {
            ImageUtils.Normalize(r);
        }
        return r;
    }
}

