/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class Multiply
implements IApplyInPlace {
    private FastBitmap overlayImage;
    private double red = 0.0;
    private double green = 0.0;
    private double blue = 0.0;
    private double gray = 0.0;
    private boolean isOverlay = false;

    public Multiply() {
    }

    public Multiply(double gray) {
        this.gray = gray;
    }

    public Multiply(double r, double g, double b) {
        this.red = Math.abs(r);
        this.green = Math.abs(g);
        this.blue = Math.abs(b);
    }

    public Multiply(FastBitmap overlayImage) {
        this.overlayImage = overlayImage;
        this.isOverlay = true;
    }

    public void setOverlayImage(FastBitmap overlayImage) {
        this.overlayImage = overlayImage;
        this.isOverlay = true;
    }

    @Override
    public void applyInPlace(FastBitmap sourceImage) {
        if (this.isOverlay) {
            this.ApplyInPlaceImage(sourceImage);
        } else {
            this.ApplyInPlaceValues(sourceImage);
        }
    }

    private void ApplyInPlaceValues(FastBitmap sourceImage) {
        block5: {
            int height;
            int width;
            block4: {
                width = sourceImage.getWidth();
                height = sourceImage.getHeight();
                if (!sourceImage.isGrayscale()) break block4;
                for (int x = 0; x < height; ++x) {
                    for (int y = 0; y < width; ++y) {
                        int l = (int)((double)sourceImage.getGray(x, y) * this.gray);
                        l = l > 255 ? 255 : l;
                        sourceImage.setGray(x, y, l);
                    }
                }
                break block5;
            }
            if (!sourceImage.isRGB()) break block5;
            for (int x = 0; x < height; ++x) {
                for (int y = 0; y < width; ++y) {
                    int r = (int)((double)sourceImage.getRed(x, y) * this.red);
                    int g = (int)((double)sourceImage.getGreen(x, y) * this.green);
                    int b = (int)((double)sourceImage.getBlue(x, y) * this.blue);
                    r = r > 255 ? 255 : r;
                    g = g > 255 ? 255 : g;
                    b = b > 255 ? 255 : b;
                    sourceImage.setRGB(x, y, r, g, b);
                }
            }
        }
    }

    private void ApplyInPlaceImage(FastBitmap sourceImage) {
        block6: {
            int sizeDestination;
            int sizeOrigin;
            int height;
            int width;
            block5: {
                width = sourceImage.getWidth();
                height = sourceImage.getHeight();
                sizeOrigin = width * height;
                sizeDestination = this.overlayImage.getWidth() * this.overlayImage.getHeight();
                if (!sourceImage.isGrayscale() || !this.overlayImage.isGrayscale()) break block5;
                if (sizeOrigin != sizeDestination) break block6;
                for (int x = 0; x < height; ++x) {
                    for (int y = 0; y < width; ++y) {
                        int l = sourceImage.getGray(x, y) * this.overlayImage.getGray(x, y);
                        l = l > 255 ? 255 : l;
                        sourceImage.setGray(x, y, l);
                    }
                }
                break block6;
            }
            if (sourceImage.isRGB() && this.overlayImage.isRGB() && sizeOrigin == sizeDestination) {
                for (int x = 0; x < height; ++x) {
                    for (int y = 0; y < width; ++y) {
                        int r = sourceImage.getRed(x, y) * this.overlayImage.getRed(x, y);
                        int g = sourceImage.getGreen(x, y) * this.overlayImage.getGreen(x, y);
                        int b = sourceImage.getBlue(x, y) * this.overlayImage.getBlue(x, y);
                        r = r > 255 ? 255 : r;
                        g = g > 255 ? 255 : g;
                        b = b > 255 ? 255 : b;
                        sourceImage.setRGB(x, y, r, g, b);
                    }
                }
            }
        }
    }
}

