/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;
import java.util.Arrays;

public class Mode
implements IApplyInPlace {
    private int radius = 1;

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public Mode() {
    }

    public Mode(int radius) {
        this.radius = Math.max(1, radius);
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        int width = fastBitmap.getWidth();
        int height = fastBitmap.getHeight();
        int lines = this.CalcLines(this.radius);
        int maxArray = lines * lines;
        FastBitmap copy = new FastBitmap(fastBitmap);
        if (fastBitmap.isGrayscale()) {
            int[] avgL = new int[maxArray];
            for (int x = 0; x < height; ++x) {
                for (int y = 0; y < width; ++y) {
                    int Yline;
                    int Xline;
                    int c = 0;
                    double mean = 0.0;
                    int min = 255;
                    int max = 0;
                    for (int i = 0; i < lines; ++i) {
                        Xline = x + (i - this.radius);
                        for (int j = 0; j < lines; ++j) {
                            int g;
                            Yline = y + (j - this.radius);
                            if (Xline < 0 || Xline >= height || Yline < 0 || Yline >= width) continue;
                            avgL[c] = g = copy.getGray(Xline, Yline);
                            mean += (double)g;
                            ++c;
                            if (g > max) {
                                max = g;
                            }
                            if (g >= min) continue;
                            min = g;
                        }
                    }
                    Arrays.sort(avgL, 0, c);
                    int median = c / 2;
                    median = avgL[median];
                    mean /= (double)c;
                    int upper = 2 * median - min;
                    int lower = 2 * median - max;
                    int cc = 0;
                    for (int i = 0; i < lines; ++i) {
                        Xline = x + (i - this.radius);
                        for (int j = 0; j < lines; ++j) {
                            Yline = y + (j - this.radius);
                            if (Xline < 0 || Xline >= height || Yline < 0 || Yline >= width) continue;
                            int g = copy.getGray(Xline, Yline);
                            if (g < upper && (double)median < mean) {
                                avgL[cc] = g;
                                ++cc;
                            }
                            if (g <= lower || !((double)median > mean)) continue;
                            avgL[cc] = g;
                            ++cc;
                        }
                    }
                    if (cc > 0) {
                        Arrays.sort(avgL, 0, cc);
                        median = cc / 2;
                        median = avgL[median];
                        fastBitmap.setGray(x, y, median);
                    }
                    fastBitmap.setGray(x, y, median);
                }
            }
        } else if (fastBitmap.isRGB()) {
            int[] avgR = new int[maxArray];
            int[] avgG = new int[maxArray];
            int[] avgB = new int[maxArray];
            for (int x = 0; x < height; ++x) {
                for (int y = 0; y < width; ++y) {
                    int Yline;
                    int Xline;
                    int c = 0;
                    double meanB = 0.0;
                    double meanG = 0.0;
                    double meanR = 0.0;
                    int minB = 255;
                    int minG = 255;
                    int minR = 255;
                    int maxB = 0;
                    int maxG = 0;
                    int maxR = 0;
                    for (int i = 0; i < lines; ++i) {
                        Xline = x + (i - this.radius);
                        for (int j = 0; j < lines; ++j) {
                            Yline = y + (j - this.radius);
                            if (Xline < 0 || Xline >= height || Yline < 0 || Yline >= width) continue;
                            int r = copy.getRed(Xline, Yline);
                            int g = copy.getGreen(Xline, Yline);
                            int b = copy.getBlue(Xline, Yline);
                            avgR[c] = r;
                            meanR += (double)r;
                            avgG[c] = g;
                            meanG += (double)g;
                            avgB[c] = b;
                            meanB += (double)b;
                            maxR = Math.max(r, maxR);
                            maxG = Math.max(g, maxG);
                            maxB = Math.max(b, maxB);
                            minR = Math.min(r, minR);
                            minG = Math.min(g, minG);
                            minB = Math.min(b, minB);
                            ++c;
                        }
                    }
                    Arrays.sort(avgR, 0, c);
                    Arrays.sort(avgG, 0, c);
                    Arrays.sort(avgB, 0, c);
                    int medianR = c / 2;
                    medianR = avgR[medianR];
                    int medianG = c / 2;
                    medianG = avgG[medianG];
                    int medianB = c / 2;
                    medianB = avgB[medianB];
                    meanR /= (double)c;
                    meanG /= (double)c;
                    meanB /= (double)c;
                    int upperR = 2 * medianR - minR;
                    int upperG = 2 * medianG - minG;
                    int upperB = 2 * medianB - minB;
                    int lowerR = 2 * medianR - maxR;
                    int lowerG = 2 * medianG - maxG;
                    int lowerB = 2 * medianB - maxB;
                    int ccR = 0;
                    int ccG = 0;
                    int ccB = 0;
                    for (int i = 0; i < lines; ++i) {
                        Xline = x + (i - this.radius);
                        for (int j = 0; j < lines; ++j) {
                            Yline = y + (j - this.radius);
                            if (Xline < 0 || Xline >= height || Yline < 0 || Yline >= width) continue;
                            int v = copy.getRed(Xline, Yline);
                            if (v < upperR && (double)medianR < meanR) {
                                avgR[ccR] = v;
                                ++ccR;
                            }
                            if (v > lowerR && (double)medianR > meanR) {
                                avgR[ccR] = v;
                                ++ccR;
                            }
                            if ((v = copy.getGreen(Xline, Yline)) < upperG && (double)medianG < meanG) {
                                avgG[ccG] = v;
                                ++ccG;
                            }
                            if (v > lowerG && (double)medianG > meanG) {
                                avgG[ccG] = v;
                                ++ccG;
                            }
                            if ((v = copy.getBlue(Xline, Yline)) < upperB && (double)medianB < meanB) {
                                avgB[ccB] = v;
                                ++ccB;
                            }
                            if (v <= lowerB || !((double)medianB > meanB)) continue;
                            avgB[ccB] = v;
                            ++ccB;
                        }
                    }
                    if (ccR > 0) {
                        Arrays.sort(avgR, 0, ccR);
                        medianR = ccR / 2;
                        medianR = avgR[medianR];
                        fastBitmap.setRed(x, y, medianR);
                    } else {
                        fastBitmap.setRed(x, y, medianR);
                    }
                    if (ccG > 0) {
                        Arrays.sort(avgG, 0, ccG);
                        medianG = ccG / 2;
                        medianG = avgG[medianG];
                        fastBitmap.setGreen(x, y, medianG);
                    } else {
                        fastBitmap.setGreen(x, y, medianG);
                    }
                    if (ccB > 0) {
                        Arrays.sort(avgB, 0, ccB);
                        medianB = ccB / 2;
                        medianB = avgB[medianB];
                        fastBitmap.setBlue(x, y, medianB);
                        continue;
                    }
                    fastBitmap.setBlue(x, y, medianB);
                }
            }
        } else {
            throw new IllegalArgumentException("Mode only works in grayscale or rgb images.");
        }
    }

    private int CalcLines(int radius) {
        return radius * 2 + 1;
    }
}

